/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.itemphysic.physics;

import com.creativemd.itemphysic.ItemDummyContainer;
import com.creativemd.itemphysic.lib.ClassTransformer;
import com.creativemd.itemphysic.physics.ClientPhysic;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;

public class ServerPhysic {
    public static Random random = new Random();
    public static ArrayList swimItem = new ArrayList();
    public static ArrayList burnItem = new ArrayList();
    public static double lastPosY;
    public static String health;
    public static String age;
    public static String delayBeforeCanPickup;

    public static void loadItemList() {
        swimItem.add(Material.field_151575_d);
        swimItem.add(Material.field_151580_n);
        swimItem.add(Material.field_151583_m);
        swimItem.add(Material.field_151598_x);
        swimItem.add(Material.field_151588_w);
        swimItem.add(Material.field_151584_j);
        swimItem.add(Material.field_151585_k);
        swimItem.add(Material.field_151593_r);
        swimItem.add(Material.field_151597_y);
        swimItem.add(Material.field_151570_A);
        swimItem.add(Material.field_151568_F);
        swimItem.add(Material.field_151582_l);
        swimItem.add(Material.field_151569_G);
        swimItem.add(Material.field_151577_b);
        swimItem.add("axe");
        swimItem.add("shovel");
        swimItem.add("hoe");
        swimItem.add("sword");
        swimItem.add(Items.field_151034_e);
        swimItem.add(Items.field_151031_f);
        swimItem.add(Items.field_151054_z);
        swimItem.add(Items.field_151032_g);
        swimItem.add(Items.field_151034_e);
        swimItem.add(Items.field_151007_F);
        swimItem.add(Items.field_151008_G);
        swimItem.add(Items.field_151015_O);
        swimItem.add(Items.field_151025_P);
        swimItem.add(Items.field_151116_aA);
        swimItem.add(Items.field_151021_T);
        swimItem.add(Items.field_151027_R);
        swimItem.add(Items.field_151024_Q);
        swimItem.add(Items.field_151026_S);
        swimItem.add(Items.field_151058_ca);
        swimItem.add(Items.field_151159_an);
        swimItem.add(Items.field_151155_ap);
        swimItem.add(Items.field_179568_as);
        swimItem.add(Items.field_179570_aq);
        swimItem.add(Items.field_179572_au);
        swimItem.add(Items.field_179567_at);
        swimItem.add(Items.field_151141_av);
        swimItem.add(Items.field_151124_az);
        swimItem.add(Items.field_151103_aS);
        swimItem.add(Items.field_151102_aT);
        swimItem.add(Items.field_151121_aF);
        swimItem.add(Items.field_151122_aG);
        swimItem.add(Items.field_151110_aK);
        swimItem.add(Items.field_151112_aM);
        swimItem.add(Items.field_151100_aR);
        swimItem.add(Items.field_151105_aU);
        swimItem.add(Items.field_151104_aV);
        swimItem.add(Items.field_151025_P);
        swimItem.add(Items.field_151127_ba);
        swimItem.add(Items.field_151097_aZ);
        swimItem.add(Items.field_151099_bA);
        swimItem.add(Items.field_151164_bB);
        swimItem.add(Items.field_151172_bF);
        swimItem.add(Items.field_151174_bG);
        swimItem.add(Items.field_151170_bI);
        swimItem.add(Items.field_151168_bH);
        swimItem.add(Items.field_151148_bJ);
        swimItem.add(Items.field_151158_bO);
        swimItem.add(Items.field_151057_cb);
        swimItem.add(Items.field_151134_bR);
        burnItem.add(Material.field_151575_d);
        burnItem.add(Material.field_151580_n);
        burnItem.add(Material.field_151583_m);
        burnItem.add(Material.field_151598_x);
        burnItem.add(Material.field_151588_w);
        burnItem.add(Material.field_151584_j);
        burnItem.add(Material.field_151585_k);
        burnItem.add(Material.field_151593_r);
        burnItem.add(Material.field_151597_y);
        burnItem.add(Material.field_151570_A);
        burnItem.add(Material.field_151568_F);
        burnItem.add(Material.field_151582_l);
        burnItem.add(Material.field_151569_G);
        burnItem.add(Material.field_151577_b);
        burnItem.add("axe");
        burnItem.add("shovel");
        burnItem.add("hoe");
        burnItem.add("sword");
        burnItem.add(Items.field_151034_e);
        burnItem.add(Items.field_151031_f);
        burnItem.add(Items.field_151054_z);
        burnItem.add(Items.field_151032_g);
        burnItem.add(Items.field_151034_e);
        burnItem.add(Items.field_151007_F);
        burnItem.add(Items.field_151008_G);
        burnItem.add(Items.field_151015_O);
        burnItem.add(Items.field_151025_P);
        burnItem.add(Items.field_151116_aA);
        burnItem.add(Items.field_151021_T);
        burnItem.add(Items.field_151027_R);
        burnItem.add(Items.field_151024_Q);
        burnItem.add(Items.field_151026_S);
        burnItem.add(Items.field_151058_ca);
        burnItem.add(Items.field_151159_an);
        burnItem.add(Items.field_151155_ap);
        burnItem.add(Items.field_151141_av);
        burnItem.add(Items.field_151124_az);
        burnItem.add(Items.field_151103_aS);
        burnItem.add(Items.field_151102_aT);
        burnItem.add(Items.field_151121_aF);
        burnItem.add(Items.field_151122_aG);
        burnItem.add(Items.field_151110_aK);
        burnItem.add(Items.field_151112_aM);
        burnItem.add(Items.field_151100_aR);
        burnItem.add(Items.field_151105_aU);
        burnItem.add(Items.field_151104_aV);
        burnItem.add(Items.field_151025_P);
        burnItem.add(Items.field_151127_ba);
        burnItem.add(Items.field_151097_aZ);
        burnItem.add(Items.field_151099_bA);
        burnItem.add(Items.field_151164_bB);
        burnItem.add(Items.field_151172_bF);
        burnItem.add(Items.field_151174_bG);
        burnItem.add(Items.field_151170_bI);
        burnItem.add(Items.field_151168_bH);
        burnItem.add(Items.field_151148_bJ);
        burnItem.add(Items.field_151158_bO);
        burnItem.add(Items.field_151057_cb);
        burnItem.add(Items.field_151134_bR);
    }

    public static void update(EntityItem item) {
        ItemStack stack = item.func_70096_w().func_82710_f(10);
        if (stack != null && stack.func_77973_b() != null && stack.func_77973_b().onEntityItemUpdate(item)) {
            return;
        }
        if (item.func_92059_d() == null) {
            item.func_70106_y();
        } else {
            boolean flag;
            item.func_70030_z();
            if (ServerPhysic.getInt(item, delayBeforeCanPickup) > 0) {
                ServerPhysic.setInt(item, delayBeforeCanPickup, ServerPhysic.getInt(item, delayBeforeCanPickup) - 1);
            }
            item.field_70169_q = item.field_70165_t;
            item.field_70167_r = item.field_70163_u;
            item.field_70166_s = item.field_70161_v;
            float f = 0.98f;
            Fluid fluid = ServerPhysic.getFluid(item);
            if (fluid == null) {
                item.field_70181_x -= 0.04;
            } else {
                double density = (double)fluid.getDensity() / 1000.0;
                double range = 0.005;
                double amount = 50.0;
                double speed = -0.05 / (density * 5.0);
                item.field_70181_x = item.field_70181_x > range + speed ? (item.field_70181_x -= density / amount) : (item.field_70181_x < range - speed ? (item.field_70181_x += density / amount) : -speed);
                if (ServerPhysic.canItemSwim(stack)) {
                    item.field_70181_x += 0.024 * density;
                }
                f = (float)(1.0 / density / 1.2);
            }
            item.field_70145_X = ServerPhysic.pushOutOfBlocks(item, item.field_70165_t, (item.func_174813_aQ().field_72338_b + item.func_174813_aQ().field_72337_e) / 2.0, item.field_70161_v);
            item.func_70091_d(item.field_70159_w, item.field_70181_x, item.field_70179_y);
            boolean bl = flag = (int)item.field_70169_q != (int)item.field_70165_t || (int)item.field_70167_r != (int)item.field_70163_u || (int)item.field_70166_s != (int)item.field_70161_v;
            if (flag || item.field_70173_aa % 25 == 0) {
                if (item.field_70170_p.func_180495_p(new BlockPos((Entity)item)).func_177230_c().func_149688_o() == Material.field_151587_i && ServerPhysic.canItemBurn(stack)) {
                    item.func_85030_a("random.fizz", 0.4f, 2.0f + random.nextFloat() * 0.4f);
                    for (int zahl = 0; zahl < 100; ++zahl) {
                        item.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, item.field_70165_t, item.field_70163_u, item.field_70161_v, (double)random.nextFloat() * 0.1 - 0.05, 0.2 * random.nextDouble(), (double)random.nextFloat() * 0.1 - 0.05, new int[0]);
                    }
                }
                if (!item.field_70170_p.field_72995_K) {
                    ServerPhysic.searchForOtherItemsNearby(item);
                }
            }
            if (item.field_70122_E) {
                f = item.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)item.field_70165_t), (int)(MathHelper.func_76128_c((double)item.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)item.field_70161_v))).func_177230_c().field_149765_K * 0.98f;
            }
            item.field_70159_w *= (double)f;
            item.field_70179_y *= (double)f;
            if (fluid == null) {
                item.field_70181_x *= 0.98;
                if (item.field_70122_E) {
                    item.field_70181_x *= -0.5;
                }
            }
            if (ServerPhysic.getInt(item, age) < 1) {
                item.lifespan = ItemDummyContainer.despawnItem;
            }
            if (ServerPhysic.getInt(item, age) != Short.MIN_VALUE) {
                ServerPhysic.setInt(item, age, ServerPhysic.getInt(item, age) + 1);
            }
            if (!item.field_70170_p.field_72995_K && ServerPhysic.getInt(item, age) >= item.lifespan) {
                int hook = ForgeEventFactory.onItemExpire((EntityItem)item, (ItemStack)stack);
                if (hook < 0) {
                    item.func_70106_y();
                } else {
                    item.lifespan += hook;
                }
            }
            if (stack != null && stack.field_77994_a <= 0) {
                item.func_70106_y();
            }
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            ClientPhysic.tick = System.nanoTime();
        }
    }

    public static Fluid getFluid(EntityItem item) {
        int k;
        int j;
        double d0 = item.field_70163_u + (double)item.func_70047_e();
        int i = MathHelper.func_76128_c((double)item.field_70165_t);
        Block block = item.field_70170_p.func_180495_p(new BlockPos(i, j = MathHelper.func_76141_d((float)MathHelper.func_76128_c((double)d0)), k = MathHelper.func_76128_c((double)item.field_70161_v))).func_177230_c();
        Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)block);
        if (fluid == null && block instanceof IFluidBlock) {
            fluid = ((IFluidBlock)block).getFluid();
        } else if (block instanceof BlockLiquid) {
            fluid = FluidRegistry.WATER;
        }
        double filled = 1.0;
        if (block instanceof IFluidBlock) {
            filled = ((IFluidBlock)block).getFilledPercentage(item.field_70170_p, new BlockPos(i, j, k));
        }
        if (filled < 0.0 ? d0 > (double)j + (1.0 - (filled *= -1.0)) : d0 < (double)j + filled) {
            return fluid;
        }
        return null;
    }

    public static void updatePositionBefore(EntityItem item) {
        lastPosY = item.field_70163_u;
    }

    public static void updatePosition(EntityItem item, double posY) {
        double diff = Math.sqrt(Math.pow(lastPosY - posY, 2.0));
        if (diff < 0.5 && diff > 0.0) {
            item.func_70107_b(item.field_70165_t, lastPosY, item.field_70161_v);
        }
    }

    private static void searchForOtherItemsNearby(EntityItem item) {
        for (EntityItem entityitem : item.field_70170_p.func_72872_a(EntityItem.class, item.func_174813_aQ().func_72314_b(0.5, 0.0, 0.5))) {
            ServerPhysic.combineItems(item, entityitem);
        }
    }

    public static boolean combineItems(EntityItem item, EntityItem other) {
        if (other == item) {
            return false;
        }
        if (other.func_70089_S() && item.func_70089_S()) {
            ItemStack itemstack = item.func_92059_d();
            ItemStack itemstack1 = other.func_92059_d();
            if (ServerPhysic.getInt(item, delayBeforeCanPickup) != Short.MAX_VALUE && ServerPhysic.getInt(other, delayBeforeCanPickup) != Short.MAX_VALUE) {
                if (ServerPhysic.getInt(item, age) != Short.MIN_VALUE && ServerPhysic.getInt(other, age) != Short.MIN_VALUE) {
                    if (itemstack1.func_77973_b() != itemstack.func_77973_b()) {
                        return false;
                    }
                    if (itemstack1.func_77942_o() ^ itemstack.func_77942_o()) {
                        return false;
                    }
                    if (itemstack1.func_77942_o() && !itemstack1.func_77978_p().equals((Object)itemstack.func_77978_p())) {
                        return false;
                    }
                    if (itemstack1.func_77973_b() == null) {
                        return false;
                    }
                    if (itemstack1.func_77973_b().func_77614_k() && itemstack1.func_77960_j() != itemstack.func_77960_j()) {
                        return false;
                    }
                    if (itemstack1.field_77994_a < itemstack.field_77994_a) {
                        return ServerPhysic.combineItems(other, item);
                    }
                    if (itemstack1.field_77994_a + itemstack.field_77994_a > itemstack1.func_77976_d()) {
                        return false;
                    }
                    itemstack1.field_77994_a += itemstack.field_77994_a;
                    ServerPhysic.setInt(other, delayBeforeCanPickup, Math.max(ServerPhysic.getInt(other, delayBeforeCanPickup), ServerPhysic.getInt(item, delayBeforeCanPickup)));
                    ServerPhysic.setInt(other, age, Math.min(ServerPhysic.getInt(other, age), ServerPhysic.getInt(item, age)));
                    other.func_92058_a(itemstack1);
                    item.func_70106_y();
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public static boolean pushOutOfBlocks(EntityItem item, double x, double y, double z) {
        BlockPos blockpos = new BlockPos(x, y, z);
        double d3 = x - (double)blockpos.func_177958_n();
        double d4 = y - (double)blockpos.func_177956_o();
        double d5 = z - (double)blockpos.func_177952_p();
        List list = item.field_70170_p.func_147461_a(item.func_174813_aQ());
        if (list.isEmpty() && !item.field_70170_p.func_175665_u(blockpos)) {
            return false;
        }
        int b0 = 3;
        double d6 = 9999.0;
        if (!item.field_70170_p.func_175665_u(blockpos.func_177976_e()) && d3 < d6) {
            d6 = d3;
            b0 = 0;
        }
        if (!item.field_70170_p.func_175665_u(blockpos.func_177974_f()) && 1.0 - d3 < d6) {
            d6 = 1.0 - d3;
            b0 = 1;
        }
        if (!item.field_70170_p.func_175665_u(blockpos.func_177984_a()) && 1.0 - d4 < d6) {
            d6 = 1.0 - d4;
            b0 = 3;
        }
        if (!item.field_70170_p.func_175665_u(blockpos.func_177978_c()) && d5 < d6) {
            d6 = d5;
            b0 = 4;
        }
        if (!item.field_70170_p.func_175665_u(blockpos.func_177968_d()) && 1.0 - d5 < d6) {
            d6 = 1.0 - d5;
            b0 = 5;
        }
        float f = random.nextFloat() * 0.2f + 0.1f;
        if (b0 == 0) {
            item.field_70159_w = -f;
        }
        if (b0 == 1) {
            item.field_70159_w = f;
        }
        if (b0 == 3) {
            item.field_70181_x = f;
        }
        if (b0 == 4) {
            item.field_70179_y = -f;
        }
        if (b0 == 5) {
            item.field_70179_y = f;
        }
        return true;
    }

    public static void onCollideWithPlayer(EntityItem item, EntityPlayer par1EntityPlayer) {
        ServerPhysic.onCollideWithPlayer(item, par1EntityPlayer, true);
    }

    public static void onCollideWithPlayer(EntityItem item, EntityPlayer par1EntityPlayer, boolean needsSneak) {
        if (ItemDummyContainer.customPickup && needsSneak && !par1EntityPlayer.func_70093_af()) {
            return;
        }
        if (!item.field_70170_p.field_72995_K) {
            if (!ItemDummyContainer.customPickup && ServerPhysic.getInt(item, delayBeforeCanPickup) > 0) {
                return;
            }
            ItemStack itemstack = item.func_92059_d();
            int i = itemstack.field_77994_a;
            int hook = ForgeEventFactory.onItemPickup((EntityItem)item, (EntityPlayer)par1EntityPlayer, (ItemStack)itemstack);
            if (hook < 0) {
                return;
            }
            if (ServerPhysic.getInt(item, delayBeforeCanPickup) <= 0 && (item.func_145798_i() == null || item.lifespan - ServerPhysic.getInt(item, age) <= 200 || item.func_145798_i().equals(par1EntityPlayer.func_70005_c_())) && (hook == 1 || i <= 0 || par1EntityPlayer.field_71071_by.func_70441_a(itemstack))) {
                EntityPlayer entityplayer1;
                if (itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150364_r)) {
                    par1EntityPlayer.func_71029_a((StatBase)AchievementList.field_76005_g);
                }
                if (itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150363_s)) {
                    par1EntityPlayer.func_71029_a((StatBase)AchievementList.field_76005_g);
                }
                if (itemstack.func_77973_b() == Items.field_151116_aA) {
                    par1EntityPlayer.func_71029_a((StatBase)AchievementList.field_76022_t);
                }
                if (itemstack.func_77973_b() == Items.field_151045_i) {
                    par1EntityPlayer.func_71029_a((StatBase)AchievementList.field_76019_w);
                }
                if (itemstack.func_77973_b() == Items.field_151072_bj) {
                    par1EntityPlayer.func_71029_a((StatBase)AchievementList.field_76027_z);
                }
                if (itemstack.func_77973_b() == Items.field_151045_i && item.func_145800_j() != null && (entityplayer1 = item.field_70170_p.func_72924_a(item.func_145800_j())) != null && entityplayer1 != par1EntityPlayer) {
                    entityplayer1.func_71029_a((StatBase)AchievementList.field_150966_x);
                }
                FMLCommonHandler.instance().firePlayerItemPickupEvent(par1EntityPlayer, item);
                if (!item.func_174814_R()) {
                    item.field_70170_p.func_72956_a((Entity)par1EntityPlayer, "random.pop", 0.2f, ((random.nextFloat() - random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                }
                par1EntityPlayer.func_71001_a((Entity)item, i);
                if (itemstack.field_77994_a <= 0) {
                    item.func_70106_y();
                }
            }
        }
    }

    public static boolean interactFirst(EntityItem item, EntityPlayer par1EntityPlayer) {
        if (ItemDummyContainer.customPickup) {
            ServerPhysic.onCollideWithPlayer(item, par1EntityPlayer, false);
            return true;
        }
        return false;
    }

    public static boolean attackEntityFrom(EntityItem item, DamageSource par1DamageSource, float par2) {
        if (item.func_180431_b(par1DamageSource)) {
            return false;
        }
        if (item.func_92059_d() != null && item.func_92059_d().func_77973_b() == Items.field_151156_bN && par1DamageSource.func_94541_c() && ServerPhysic.canItemBurn(item.func_92059_d())) {
            return false;
        }
        if (par1DamageSource == DamageSource.field_76371_c | par1DamageSource == DamageSource.field_76370_b | par1DamageSource == DamageSource.field_76372_a && !ServerPhysic.canItemBurn(item.func_92059_d())) {
            return false;
        }
        if (par1DamageSource == DamageSource.field_76367_g) {
            return false;
        }
        ServerPhysic.setInt(item, health, ServerPhysic.getInt(item, health) - 1);
        if (ServerPhysic.getInt(item, health) <= 0) {
            item.func_70106_y();
        }
        return false;
    }

    public static int getInt(EntityItem item, String name) {
        boolean obfuscated = false;
        try {
            obfuscated = EntityItem.class.getField(name) == null;
        }
        catch (Exception e) {
            obfuscated = true;
        }
        name = ClassTransformer.patch(name);
        try {
            return EntityItem.class.getField(name).getInt(item);
        }
        catch (Exception e) {
            try {
                return EntityItem.class.getField(name).getInt(item);
            }
            catch (Exception e1) {
                System.out.println("Field not found health (" + name + ")");
                return 0;
            }
        }
    }

    public static void setInt(EntityItem item, String name, int value) {
        boolean obfuscated = false;
        try {
            obfuscated = EntityItem.class.getField(name) == null;
        }
        catch (Exception e) {
            obfuscated = true;
        }
        name = ClassTransformer.patch(name);
        try {
            EntityItem.class.getField(name).setInt(item, value);
        }
        catch (Exception e) {
            try {
                EntityItem.class.getField(name).setInt(item, value);
            }
            catch (Exception e1) {
                System.out.println("Field not found health (" + name + ")");
            }
        }
    }

    public static boolean isItemBurning(EntityItem item) {
        boolean flag;
        boolean bl = flag = item.field_70170_p != null && item.field_70170_p.field_72995_K;
        if (item.func_70045_F() || !flag || (item.func_70096_w().func_75683_a(0) & 1) == 0) {
            return false;
        }
        return ServerPhysic.canItemBurn(item.func_92059_d());
    }

    public static boolean canItemSwim(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return ServerPhysic.contains(swimItem, stack);
    }

    public static boolean canItemBurn(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (TileEntityFurnace.func_145954_b((ItemStack)stack)) {
            return true;
        }
        return ServerPhysic.contains(burnItem, stack);
    }

    public static boolean contains(ArrayList list, ItemStack stack) {
        Item object = stack.func_77973_b();
        Material material = null;
        if (object instanceof ItemBlock) {
            object = Block.func_149634_a((Item)object);
            material = ((Block)object).func_149688_o();
        }
        int[] ores = OreDictionary.getOreIDs((ItemStack)stack);
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) instanceof ItemStack && ItemStack.func_77989_b((ItemStack)stack, (ItemStack)((ItemStack)list.get(i)))) {
                return true;
            }
            if (list.get(i) == object) {
                return true;
            }
            if (list.get(i) == material) {
                return true;
            }
            if (!(list.get(i) instanceof String)) continue;
            for (int j = 0; j < ores.length; ++j) {
                if (!OreDictionary.getOreName((int)ores[j]).contains((CharSequence)list.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    static {
        health = "health";
        age = "age";
        delayBeforeCanPickup = "delayBeforeCanPickup";
    }
}

