/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.itemphysic.transformers;

import com.creativemd.itemphysic.lib.ClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class EntityItemTransformer
extends ClassTransformer {
    public EntityItemTransformer() {
        super("net/minecraft/entity/item/EntityItem");
    }

    @Override
    public byte[] transform(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        this.replaceAttackMethod(classNode);
        this.replaceOnUpdateMethod(classNode);
        this.replaceCollideMethod(classNode);
        this.replaceFieldsToPublic(classNode);
        this.addBurningMethod(classNode);
        this.addSetPositionMethod(classNode);
        this.addInteractFirstMethod(classNode);
        for (MethodNode m : classNode.methods) {
            System.out.println("Name:" + m.name + " DESC:" + m.desc + " int:" + m.instructions.size());
            m.visitCode();
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public void addInteractFirstMethod(ClassNode node) {
        String newDESC3 = "(Lnet/minecraft/entity/item/EntityItem;Lnet/minecraft/entity/player/EntityPlayer;)Z";
        String newMethodDESC = "(Lnet/minecraft/entity/player/EntityPlayer;)Z";
        String newMethod = EntityItemTransformer.patch("interactFirst");
        MethodNode m = new MethodNode(1, newMethod, newMethodDESC, null, null);
        LabelNode label = new LabelNode();
        m.instructions.add((AbstractInsnNode)label);
        m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        m.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/creativemd/itemphysic/physics/ServerPhysic", "interactFirst", newDESC3, false));
        LabelNode label2 = new LabelNode();
        m.instructions.add((AbstractInsnNode)label2);
        m.instructions.add((AbstractInsnNode)new InsnNode(4));
        m.instructions.add((AbstractInsnNode)new InsnNode(172));
        m.localVariables.add(new LocalVariableNode("this", "L" + this.className.replace(".", "/") + ";", null, label, label2, 0));
        m.localVariables.add(new LocalVariableNode("par1EntityPlayer", "Lnet/minecraft/entity/player/EntityPlayer;", null, label, label2, 0));
        node.methods.add(m);
    }

    public void replaceOnUpdateMethod(ClassNode node) {
        String targetMethodName = EntityItemTransformer.patch("onUpdate");
        String targetDESC = "(Lnet/minecraft/entity/item/EntityItem;)V";
        for (MethodNode m : node.methods) {
            if (!m.name.equals(targetMethodName) || !m.desc.equals("()V")) continue;
            m.instructions.clear();
            m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            m.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/creativemd/itemphysic/physics/ServerPhysic", "update", targetDESC, false));
            m.instructions.add((AbstractInsnNode)new InsnNode(177));
        }
    }

    public void replaceAttackMethod(ClassNode node) {
        String targetDESC = "(Lnet/minecraft/util/DamageSource;F)Z";
        String targetMethodName = EntityItemTransformer.patch("attackEntityFrom");
        String targetNewDESC = "(Lnet/minecraft/entity/item/EntityItem;Lnet/minecraft/util/DamageSource;F)Z";
        for (MethodNode m : node.methods) {
            if (!m.name.equals(targetMethodName) || !m.desc.equals(targetDESC)) continue;
            m.instructions.clear();
            m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            m.instructions.add((AbstractInsnNode)new VarInsnNode(23, 2));
            m.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/creativemd/itemphysic/physics/ServerPhysic", "attackEntityFrom", targetNewDESC, false));
            m.instructions.add((AbstractInsnNode)new InsnNode(172));
        }
    }

    public void replaceFieldsToPublic(ClassNode node) {
        String[] fields = new String[]{EntityItemTransformer.patch("health"), EntityItemTransformer.patch("age"), EntityItemTransformer.patch("delayBeforeCanPickup")};
        for (FieldNode f : node.fields) {
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].equals(f.name)) continue;
                f.access = 1;
            }
        }
    }

    public void replaceCollideMethod(ClassNode node) {
        String targetDESC = "(Lnet/minecraft/entity/player/EntityPlayer;)V";
        String targetMethodName = EntityItemTransformer.patch("onCollideWithPlayer");
        String newDESC2 = "(Lnet/minecraft/entity/item/EntityItem;Lnet/minecraft/entity/player/EntityPlayer;)V";
        for (MethodNode m : node.methods) {
            if (!m.name.equals(targetMethodName) || !m.desc.equals(targetDESC)) continue;
            m.instructions.clear();
            m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            m.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/creativemd/itemphysic/physics/ServerPhysic", "onCollideWithPlayer", newDESC2, false));
            m.instructions.add((AbstractInsnNode)new InsnNode(177));
        }
    }

    public void addBurningMethod(ClassNode node) {
        String targetMethodName = EntityItemTransformer.patch("isBurning");
        String targetDESC = "(Lnet/minecraft/entity/item/EntityItem;)Z";
        MethodNode m = new MethodNode(1, targetMethodName, "()Z", null, null);
        LabelNode label = new LabelNode();
        m.instructions.add((AbstractInsnNode)label);
        m.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        m.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/creativemd/itemphysic/physics/ServerPhysic", "isItemBurning", targetDESC, false));
        m.instructions.add((AbstractInsnNode)new InsnNode(172));
        LabelNode label2 = new LabelNode();
        m.instructions.add((AbstractInsnNode)label2);
        m.localVariables.add(new LocalVariableNode("this", "L" + this.className.replace(".", "/") + ";", null, label, label2, 0));
        node.methods.add(m);
    }

    public void addSetPositionMethod(ClassNode node) {
    }
}

