/*
 * Decompiled with CFR 0.152.
 */
package de.failender.lumberjack.handler;

import de.failender.lumberjack.extended.ExtendedPlayer;
import de.failender.lumberjack.proxies.CommonProxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventHandlerLJ {
    private static int amount;
    private static HashMap<String, Integer> map;

    @SubscribeEvent
    public void breakSpeed(PlayerEvent.BreakSpeed speed) {
        ExtendedPlayer ext;
        if (speed.state.func_177230_c() instanceof BlockLog && speed.entityPlayer.func_70005_c_() != null && !speed.entityPlayer.func_70093_af() && (ext = (ExtendedPlayer)speed.entityPlayer.getExtendedProperties("LumberjackCut")).getCutDown()) {
            try {
                speed.newSpeed = speed.originalSpeed / (float)map.get(speed.entityPlayer.func_70005_c_()).intValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void interact(PlayerInteractEvent event) {
        if (event.world.func_180495_p(event.pos).func_177230_c() instanceof BlockLog) {
            ExtendedPlayer ext = (ExtendedPlayer)event.entityPlayer.getExtendedProperties("LumberjackCut");
            if (ext.getCutDown()) {
                ArrayList<BlockPos> checked = new ArrayList<BlockPos>();
                checked.add(event.pos);
                int size = this.calculateTreeSize(event.pos, event.world, checked, 1);
                System.out.println(size);
                map.put(event.entityPlayer.func_70005_c_(), size);
            } else {
                map.put(event.entityPlayer.func_70005_c_(), 1);
            }
        }
    }

    @SubscribeEvent
    public void EntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer && ExtendedPlayer.get((EntityPlayer)event.entity) == null) {
            ExtendedPlayer.register((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        Entity entity = event.entity;
        if (entity instanceof EntityPlayer && !entity.field_70170_p.field_72995_K) {
            NBTTagCompound playerData = new NBTTagCompound();
            ((ExtendedPlayer)event.entity.getExtendedProperties("LumberjackCut")).saveNBTData(playerData);
            CommonProxy.storeEntityData(((EntityPlayer)event.entity).func_70005_c_(), playerData);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.world.field_72995_K && event.entity instanceof EntityPlayer) {
            NBTTagCompound compound = CommonProxy.getEntityData(event.entity.func_70005_c_());
            if (compound != null) {
                ((ExtendedPlayer)event.entity.getExtendedProperties("LumberjackCut")).loadNBTData(compound);
            }
        }
    }

    @SubscribeEvent
    public void onBlockHarvested(BlockEvent.BreakEvent event) {
        if (event.state.func_177230_c() instanceof BlockLog && !event.world.field_72995_K && event.getPlayer() != null && event.getPlayer().func_71045_bC() != null && event.getPlayer().func_71045_bC().func_77973_b() instanceof ItemAxe && ((ExtendedPlayer)event.getPlayer().getExtendedProperties("LumberjackCut")).getCutDown() && !event.getPlayer().func_70093_af()) {
            amount = 0;
            ItemStack item = event.getPlayer().func_71045_bC();
            this.breakBlock(event.pos, event.world);
            item.func_96631_a(amount, new Random());
            item.func_77972_a(amount, (EntityLivingBase)event.getPlayer());
        }
    }

    public void breakBlock(BlockPos pos, World world) {
        world.func_175655_b(pos, true);
        BlockPos top = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
        BlockPos front = new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p());
        BlockPos behind = new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p());
        BlockPos left = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1);
        BlockPos right = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1);
        if (world.func_180495_p(top).func_177230_c() instanceof BlockLog) {
            this.breakBlock(top, world);
            ++amount;
        }
        if (world.func_180495_p(front).func_177230_c() instanceof BlockLog) {
            this.breakBlock(front, world);
            ++amount;
        }
        if (world.func_180495_p(behind).func_177230_c() instanceof BlockLog) {
            this.breakBlock(behind, world);
            ++amount;
        }
        if (world.func_180495_p(left).func_177230_c() instanceof BlockLog) {
            this.breakBlock(left, world);
            ++amount;
        }
        if (world.func_180495_p(right).func_177230_c() instanceof BlockLog) {
            this.breakBlock(right, world);
            ++amount;
        }
        if (world.func_180495_p(top).func_177230_c() instanceof BlockLeaves) {
            this.breakBlock(top, world);
        }
        if (world.func_180495_p(front).func_177230_c() instanceof BlockLeaves) {
            this.breakBlock(front, world);
        }
        if (world.func_180495_p(behind).func_177230_c() instanceof BlockLeaves) {
            this.breakBlock(behind, world);
        }
        if (world.func_180495_p(left).func_177230_c() instanceof BlockLeaves) {
            this.breakBlock(left, world);
        }
        if (world.func_180495_p(right).func_177230_c() instanceof BlockLeaves) {
            this.breakBlock(right, world);
        }
    }

    private int calculateTreeSize(BlockPos pos, World world, ArrayList<BlockPos> checked, int ret) {
        if (world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockLog && !checked.contains(pos.func_177984_a())) {
            ++ret;
            checked.add(pos.func_177984_a());
            ret = this.calculateTreeSize(pos.func_177984_a(), world, checked, ret);
        }
        if (world.func_180495_p(pos.func_177978_c()).func_177230_c() instanceof BlockLog && !checked.contains(pos.func_177978_c())) {
            ++ret;
            checked.add(pos.func_177978_c());
            ret = this.calculateTreeSize(pos.func_177978_c(), world, checked, ret);
        }
        if (world.func_180495_p(pos.func_177974_f()).func_177230_c() instanceof BlockLog && !checked.contains(pos.func_177974_f())) {
            ++ret;
            checked.add(pos.func_177974_f());
            ret = this.calculateTreeSize(pos.func_177974_f(), world, checked, ret);
        }
        if (world.func_180495_p(pos.func_177968_d()).func_177230_c() instanceof BlockLog && !checked.contains(pos.func_177968_d())) {
            ++ret;
            checked.add(pos.func_177968_d());
            ret = this.calculateTreeSize(pos.func_177968_d(), world, checked, ret);
        }
        if (world.func_180495_p(pos.func_177976_e()).func_177230_c() instanceof BlockLog && !checked.contains(pos.func_177976_e())) {
            ++ret;
            checked.add(pos.func_177976_e());
            ret = this.calculateTreeSize(pos.func_177976_e(), world, checked, ret);
        }
        if (world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockLeaves && !checked.contains(pos.func_177984_a())) {
            checked.add(pos.func_177984_a());
            ret = this.calculateTreeSize(pos.func_177984_a(), world, checked, ret);
        }
        if (world.func_180495_p(pos.func_177978_c()).func_177230_c() instanceof BlockLeaves && !checked.contains(pos.func_177978_c())) {
            checked.add(pos.func_177978_c());
            ret = this.calculateTreeSize(pos.func_177978_c(), world, checked, ret);
        }
        if (world.func_180495_p(pos.func_177974_f()).func_177230_c() instanceof BlockLeaves && !checked.contains(pos.func_177974_f())) {
            checked.add(pos.func_177974_f());
            ret = this.calculateTreeSize(pos.func_177974_f(), world, checked, ret);
        }
        if (world.func_180495_p(pos.func_177968_d()).func_177230_c() instanceof BlockLeaves && !checked.contains(pos.func_177968_d())) {
            checked.add(pos.func_177968_d());
            ret = this.calculateTreeSize(pos.func_177968_d(), world, checked, ret);
        }
        if (world.func_180495_p(pos.func_177976_e()).func_177230_c() instanceof BlockLeaves && !checked.contains(pos.func_177976_e())) {
            checked.add(pos.func_177976_e());
            ret = this.calculateTreeSize(pos.func_177976_e(), world, checked, ret);
        }
        return ret;
    }

    static {
        map = new HashMap();
    }
}

