/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo;

import crazypants.enderzoo.CommonProxy;
import crazypants.enderzoo.charge.BlockConcussionCharge;
import crazypants.enderzoo.charge.BlockConfusingCharge;
import crazypants.enderzoo.charge.BlockEnderCharge;
import crazypants.enderzoo.config.Config;
import crazypants.enderzoo.enchantment.Enchantments;
import crazypants.enderzoo.entity.MobInfo;
import crazypants.enderzoo.item.ItemConfusingDust;
import crazypants.enderzoo.item.ItemEnderFragment;
import crazypants.enderzoo.item.ItemForCreativeMenuIcon;
import crazypants.enderzoo.item.ItemGuardiansBow;
import crazypants.enderzoo.item.ItemSpawnEgg;
import crazypants.enderzoo.item.ItemWitheringDust;
import crazypants.enderzoo.spawn.MobSpawnEventHandler;
import crazypants.enderzoo.spawn.MobSpawns;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;

@Mod(modid="EnderZoo", name="Ender Zoo", version="1.8-1.1.24_beta", dependencies="required-after:Forge@10.13.0.1150,)", guiFactory="crazypants.enderzoo.config.ConfigFactoryEnderZoo", acceptedMinecraftVersions="[1.8]")
public class EnderZoo {
    public static final String MODID = "EnderZoo";
    public static final String MOD_NAME = "Ender Zoo";
    public static final String VERSION = "1.8-1.1.24_beta";
    @Mod.Instance(value="EnderZoo")
    public static EnderZoo instance;
    @SidedProxy(clientSide="crazypants.enderzoo.ClientProxy", serverSide="crazypants.enderzoo.CommonProxy")
    public static CommonProxy proxy;
    public static ItemSpawnEgg itemSpawnEgg;
    public static ItemWitheringDust itemWitheringDust;
    public static ItemConfusingDust itemConfusingDust;
    public static ItemEnderFragment itemEnderFragment;
    public static ItemForCreativeMenuIcon itemForCreativeMenuIcon;
    public static ItemGuardiansBow itemGuardiansBow;
    public static BlockConfusingCharge blockConfusingCharge;
    public static BlockEnderCharge blockEnderCharge;
    public static BlockConcussionCharge blockConcussionCharge;
    public static MobSpawnEventHandler spawnEventHandler;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        itemForCreativeMenuIcon = ItemForCreativeMenuIcon.create();
        Config.load(event);
        for (MobInfo mob : MobInfo.values()) {
            this.registerEntity(mob);
        }
        itemSpawnEgg = ItemSpawnEgg.create();
        itemWitheringDust = ItemWitheringDust.create();
        itemConfusingDust = ItemConfusingDust.create();
        itemEnderFragment = ItemEnderFragment.create();
        itemGuardiansBow = ItemGuardiansBow.create();
        if (Config.confusingChargeEnabled) {
            blockConfusingCharge = BlockConfusingCharge.create();
        }
        if (Config.enderChargeEnabled) {
            blockEnderCharge = BlockEnderCharge.create();
        }
        if (Config.concussionChargeEnabled) {
            blockConcussionCharge = BlockConcussionCharge.create();
        }
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"crazypants.enderzoo.waila.WailaCompat.load");
    }

    private void registerEntity(MobInfo mob) {
        if (!mob.isEnabled()) {
            return;
        }
        int entityID = EntityRegistry.findGlobalUniqueEntityId();
        EntityRegistry.registerGlobalEntityID(mob.getClz(), (String)mob.getName(), (int)entityID, (int)mob.getEggBackgroundColor(), (int)mob.getEggForegroundColor());
        EntityRegistry.registerModEntity(mob.getClz(), (String)mob.getName(), (int)entityID, (Object)this, (int)64, (int)3, (boolean)true);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        instance = this;
        proxy.load();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Enchantments.getInstance();
        MobSpawns.instance.loadSpawnConfig();
        this.addRecipes();
        if (Config.enderZooDifficultyModifierEnabled || Config.globalDifficultyModifierEnabled) {
            spawnEventHandler = new MobSpawnEventHandler();
            spawnEventHandler.init();
        }
    }

    private void addRecipes() {
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(Items.field_151079_bi), (Object[])new Object[]{" f ", "fff", " f ", Character.valueOf('f'), itemEnderFragment});
    }
}

