/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo.entity;

import crazypants.enderzoo.vec.Point3i;
import crazypants.enderzoo.vec.VecUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityUtil {
    public static boolean isHardDifficulty(World worldObj) {
        return worldObj.func_175659_aa() == EnumDifficulty.HARD;
    }

    public static float getDifficultyMultiplierForLocation(World world, double x, double y, double z) {
        float occupiedDiffcultyMultiplier = world.func_175649_E(VecUtil.bpos(x, y, z)).func_180170_c();
        return occupiedDiffcultyMultiplier /= 1.5f;
    }

    public static String getDisplayNameForEntity(String mobName) {
        return StatCollector.func_74838_a((String)("entity." + mobName + ".name"));
    }

    public static Vec3 getEntityPosition(Entity entity) {
        return new Vec3(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public static AxisAlignedBB getBoundsAround(Entity entity, double range) {
        return EntityUtil.getBoundsAround(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, range);
    }

    public static AxisAlignedBB getBoundsAround(Vec3 pos, double range) {
        return EntityUtil.getBoundsAround(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, range);
    }

    public static AxisAlignedBB getBoundsAround(double x, double y, double z, double range) {
        return new AxisAlignedBB(x - range, y - range, z - range, x + range, y + range, z + range);
    }

    public static Point3i getEntityPositionI(Entity entity) {
        return new Point3i((int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v);
    }

    public static void cancelCurrentTasks(EntityLiving ent) {
        Iterator iterator = ent.field_70714_bg.field_75782_a.iterator();
        ArrayList<EntityAITasks.EntityAITaskEntry> currentTasks = new ArrayList<EntityAITasks.EntityAITaskEntry>();
        while (iterator.hasNext()) {
            EntityAITasks.EntityAITaskEntry entityaitaskentry = (EntityAITasks.EntityAITaskEntry)iterator.next();
            if (entityaitaskentry == null) continue;
            currentTasks.add(entityaitaskentry);
        }
        for (EntityAITasks.EntityAITaskEntry task : currentTasks) {
            ent.field_70714_bg.func_85156_a(task.field_75733_a);
            ent.field_70714_bg.func_75776_a(task.field_75731_b, task.field_75733_a);
        }
        ent.func_70661_as().func_75499_g();
    }

    public static IAttributeInstance removeModifier(EntityLivingBase ent, IAttribute p, UUID u) {
        IAttributeInstance att = ent.func_110148_a(p);
        AttributeModifier curmod = att.func_111127_a(u);
        if (curmod != null) {
            att.func_111124_b(curmod);
        }
        return att;
    }

    public static double getDistanceSqToNearestPlayer(Entity entity, double maxRange) {
        AxisAlignedBB bounds = EntityUtil.getBoundsAround(entity, maxRange);
        EntityPlayer nearest = (EntityPlayer)entity.field_70170_p.func_72857_a(EntityPlayer.class, bounds, entity);
        if (nearest == null) {
            return 1.0;
        }
        return nearest.func_70068_e(entity);
    }

    public static boolean isPlayerWithinRange(Entity entity, double range) {
        List res = entity.field_70170_p.func_72872_a(EntityPlayer.class, EntityUtil.getBoundsAround(entity, range));
        return res != null && !res.isEmpty();
    }
}

