/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo.entity;

import crazypants.enderzoo.vec.Point3i;
import crazypants.enderzoo.vec.VecUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class SpawnUtil {
    public static boolean findClearGround(World world, Point3i startingLocation, Point3i clearLocation) {
        return SpawnUtil.findClearGround(world, startingLocation, clearLocation, 2, 10, false);
    }

    public static boolean findClearGround(World world, Point3i startingLocation, Point3i clearLocation, int horizRange, int vertRange, boolean checkForLivingEntities) {
        boolean foundTargetSpace = false;
        for (int xOff = -horizRange; xOff <= horizRange && !foundTargetSpace; ++xOff) {
            clearLocation.x = startingLocation.x + xOff;
            for (int zOff = -horizRange; zOff <= horizRange && !foundTargetSpace; ++zOff) {
                clearLocation.z = startingLocation.z + zOff;
                foundTargetSpace = SpawnUtil.seachYForClearGround(clearLocation, world, vertRange, checkForLivingEntities);
                if (foundTargetSpace) continue;
                clearLocation.y = startingLocation.y;
            }
        }
        return foundTargetSpace;
    }

    public static boolean seachYForClearGround(Point3i target, World world) {
        return SpawnUtil.seachYForClearGround(target, world, 10, false);
    }

    public static boolean seachYForClearGround(Point3i target, World world, int searchRange, boolean checkForLivingEntities) {
        boolean foundY = false;
        for (int i = 0; i < searchRange && !foundY; ++i) {
            if (world.func_175623_d(VecUtil.bpos(target.x, target.y, target.z))) {
                foundY = true;
                continue;
            }
            ++target.y;
        }
        boolean onGround = false;
        if (foundY) {
            for (int i = 0; i < searchRange && !onGround; ++i) {
                boolean bl = onGround = !world.func_175623_d(VecUtil.bpos(target.x, target.y - 1, target.z)) && !SpawnUtil.isLiquid(world, target.x, target.y - 1, target.z);
                if (!onGround) {
                    --target.y;
                    continue;
                }
                if (!checkForLivingEntities || !SpawnUtil.containsLiving(world, target)) continue;
                return false;
            }
        }
        return foundY && onGround;
    }

    public static boolean containsLiving(World world, Point3i blockCoord) {
        AxisAlignedBB bb = new AxisAlignedBB((double)blockCoord.x, (double)blockCoord.y, (double)blockCoord.z, (double)(blockCoord.x + 1), (double)(blockCoord.y + 1), (double)(blockCoord.z + 1));
        List ents = world.func_72872_a(EntityLivingBase.class, bb);
        return ents != null && !ents.isEmpty();
    }

    public static boolean isLiquid(World world, int x, int y, int z) {
        IBlockState bs = world.func_180495_p(VecUtil.bpos(x, y, z));
        if (bs == null || bs.func_177230_c() == null) {
            return false;
        }
        Block block = bs.func_177230_c();
        return block.func_149688_o().func_76224_d();
    }

    public static boolean isSpaceAvailableForSpawn(World worldObj, EntityCreature entity, boolean checkEntityCollisions, boolean canSpawnInLiquid) {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)entity.field_70165_t);
        if (entity.func_180484_a(VecUtil.bpos(i, j = MathHelper.func_76128_c((double)entity.func_174813_aQ().field_72338_b), k = MathHelper.func_76128_c((double)entity.field_70161_v))) < 0.0f) {
            return false;
        }
        if (checkEntityCollisions && !worldObj.func_72855_b(entity.func_174813_aQ())) {
            return false;
        }
        if (!worldObj.func_72945_a((Entity)entity, entity.func_174813_aQ()).isEmpty()) {
            return false;
        }
        return canSpawnInLiquid || !worldObj.func_72953_d(entity.func_174813_aQ());
    }

    public static boolean isSpaceAvailableForSpawn(World worldObj, EntityCreature entity, boolean checkEntityCollisions) {
        return SpawnUtil.isSpaceAvailableForSpawn(worldObj, entity, checkEntityCollisions, false);
    }
}

