/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo.entity.ai;

import crazypants.enderzoo.entity.EntityUtil;
import crazypants.enderzoo.entity.SpawnUtil;
import crazypants.enderzoo.vec.Point3i;
import crazypants.enderzoo.vec.VecUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityAIMountedArrowAttack
extends EntityAIBase {
    private final EntityLiving entityHost;
    private final IRangedAttackMob rangedAttackEntityHost;
    private EntityLivingBase attackTarget;
    private double entityMoveSpeed;
    private double mountedEntityMoveSpeed;
    private int timeUntilNextAttack = -1;
    private int timeTargetVisible;
    private int minRangedAttackTime;
    private int maxRangedAttackTime;
    private float attackRange;
    private float attackRangeSq;
    private int runAwayTimer = 0;
    private PathPoint runningAwayTo;
    private boolean useRunAwayTactic;

    public EntityAIMountedArrowAttack(IRangedAttackMob host, double moveSpeed, double mountedEntityMoveSpeed, int minAttackTime, int maxAttackTime, float attackRange, boolean useRunAwayTactic) {
        this.rangedAttackEntityHost = host;
        this.entityHost = (EntityLiving)host;
        this.entityMoveSpeed = moveSpeed;
        this.mountedEntityMoveSpeed = mountedEntityMoveSpeed;
        this.minRangedAttackTime = minAttackTime;
        this.maxRangedAttackTime = maxAttackTime;
        this.attackRange = attackRange;
        this.attackRangeSq = attackRange * attackRange;
        this.useRunAwayTactic = useRunAwayTactic;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        EntityLivingBase toAttack = this.entityHost.func_70638_az();
        if (toAttack == null) {
            return false;
        }
        this.attackTarget = toAttack;
        return true;
    }

    public boolean func_75253_b() {
        return this.func_75250_a() || !this.getNavigator().func_75500_f();
    }

    public void func_75251_c() {
        this.attackTarget = null;
        this.timeTargetVisible = 0;
        this.timeUntilNextAttack = -1;
        this.runAwayTimer = 0;
        this.runningAwayTo = null;
    }

    public void func_75246_d() {
        double distToTargetSq = this.entityHost.func_70092_e(this.attackTarget.field_70165_t, this.attackTarget.func_174813_aQ().field_72338_b, this.attackTarget.field_70161_v);
        boolean canSeeTarget = this.entityHost.func_70635_at().func_75522_a((Entity)this.attackTarget);
        this.timeTargetVisible = canSeeTarget ? ++this.timeTargetVisible : 0;
        boolean runningAway = this.isRunningAway();
        if (!runningAway) {
            --this.runAwayTimer;
        }
        if (!runningAway && distToTargetSq <= (double)this.attackRangeSq && this.timeTargetVisible >= 20) {
            this.getNavigator().func_75499_g();
        } else if (distToTargetSq > (double)this.attackRangeSq * 0.9) {
            this.getNavigator().func_75497_a((Entity)this.attackTarget, this.getMoveSpeed());
        }
        if (canSeeTarget && this.entityHost.func_70115_ae() && distToTargetSq < 36.0 && this.runAwayTimer <= 0 && this.runAway()) {
            --this.timeUntilNextAttack;
            return;
        }
        if (runningAway) {
            --this.timeUntilNextAttack;
            return;
        }
        this.entityHost.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
        if (--this.timeUntilNextAttack == 0) {
            if (distToTargetSq > (double)this.attackRangeSq || !canSeeTarget) {
                return;
            }
            float rangeRatio = MathHelper.func_76133_a((double)distToTargetSq) / this.attackRange;
            rangeRatio = MathHelper.func_76131_a((float)rangeRatio, (float)0.1f, (float)1.0f);
            this.rangedAttackEntityHost.func_82196_d(this.attackTarget, rangeRatio);
            this.timeUntilNextAttack = MathHelper.func_76141_d((float)(rangeRatio * (float)(this.maxRangedAttackTime - this.minRangedAttackTime) + (float)this.minRangedAttackTime));
        } else if (this.timeUntilNextAttack < 0) {
            float rangeRatio = MathHelper.func_76133_a((double)distToTargetSq) / this.attackRange;
            this.timeUntilNextAttack = MathHelper.func_76141_d((float)(rangeRatio * (float)(this.maxRangedAttackTime - this.minRangedAttackTime) + (float)this.minRangedAttackTime));
        }
    }

    private boolean isRunningAway() {
        if (this.runningAwayTo == null) {
            return false;
        }
        if (this.getNavigator().func_75500_f()) {
            this.runningAwayTo = null;
            return false;
        }
        PathPoint dest = this.getNavigator().func_75505_d().func_75870_c();
        return dest.equals((Object)this.runningAwayTo);
    }

    private boolean runAway() {
        if (!this.useRunAwayTactic) {
            return false;
        }
        this.runAwayTimer = 40;
        Vec3 targetDir = new Vec3(this.attackTarget.field_70165_t, this.attackTarget.func_174813_aQ().field_72338_b, this.attackTarget.field_70161_v);
        Vec3 entityPos = EntityUtil.getEntityPosition((Entity)this.entityHost);
        targetDir = VecUtil.subtract(targetDir, entityPos);
        targetDir = VecUtil.scale(targetDir, -1.0);
        targetDir = targetDir.func_72432_b();
        double distance = (double)this.attackRange * 0.9;
        targetDir = VecUtil.scale(targetDir, distance);
        targetDir = VecUtil.add(targetDir, entityPos);
        World world = this.entityHost.field_70170_p;
        Point3i probePoint = new Point3i((int)Math.round(targetDir.field_72450_a), (int)Math.round(this.entityHost.field_70163_u), (int)Math.round(targetDir.field_72449_c));
        Point3i target = new Point3i(probePoint);
        if (!SpawnUtil.findClearGround(world, target, probePoint)) {
            return false;
        }
        boolean res = this.getNavigator().func_75492_a((double)probePoint.x, (double)probePoint.y, (double)probePoint.z, this.mountedEntityMoveSpeed);
        this.runningAwayTo = this.getNavigator().func_75500_f() ? null : this.getNavigator().func_75505_d().func_75870_c();
        return res;
    }

    private double getMoveSpeed() {
        if (this.entityHost.func_70115_ae()) {
            return this.mountedEntityMoveSpeed;
        }
        return this.entityMoveSpeed;
    }

    protected PathNavigate getNavigator() {
        Entity ent;
        if (this.entityHost.func_70115_ae() && (ent = this.entityHost.field_70154_o) instanceof EntityLiving) {
            return ((EntityLiving)ent).func_70661_as();
        }
        return this.entityHost.func_70661_as();
    }
}

