/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.util.MathHelper;

public class EntityAIRangedAttack
extends EntityAIBase {
    private final EntityLiving entityHost;
    private final IRangedAttackMob rangedAttackEntityHost;
    private EntityLivingBase attackTarget;
    private int timeUntilNextAttack = -1;
    private double entityMoveSpeed;
    private int timeTargetVisible;
    private int timeTargetHidden;
    private int minRangedAttackTime;
    private int maxRangedAttackTime;
    private float attackRange;
    private float attackRangeSq;

    public EntityAIRangedAttack(IRangedAttackMob host, double moveSpeed, int timeBetweenAttacks, float attackRange) {
        this(host, moveSpeed, timeBetweenAttacks, timeBetweenAttacks, attackRange);
    }

    public EntityAIRangedAttack(IRangedAttackMob host, double moveSpeed, int minTimeBetweenAttacks, int maxTimeBetweenAttacks, float range) {
        this.rangedAttackEntityHost = host;
        this.entityHost = (EntityLiving)host;
        this.entityMoveSpeed = moveSpeed;
        this.minRangedAttackTime = minTimeBetweenAttacks;
        this.maxRangedAttackTime = maxTimeBetweenAttacks;
        this.attackRange = range;
        this.attackRangeSq = this.attackRange * this.attackRange;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        EntityLivingBase target = this.entityHost.func_70638_az();
        if (target == null) {
            return false;
        }
        this.attackTarget = target;
        return true;
    }

    public EntityLivingBase getAttackTarget() {
        return this.attackTarget;
    }

    public boolean func_75253_b() {
        return this.func_75250_a() || !this.entityHost.func_70661_as().func_75500_f();
    }

    protected double getTargetDistance() {
        IAttributeInstance iattributeinstance = this.entityHost.func_110148_a(SharedMonsterAttributes.field_111265_b);
        return iattributeinstance == null ? 16.0 : iattributeinstance.func_111126_e();
    }

    public void func_75251_c() {
        this.attackTarget = null;
        this.timeTargetVisible = 0;
        this.timeUntilNextAttack = -1;
    }

    public void func_75246_d() {
        double distToTargetSq = this.entityHost.func_70092_e(this.attackTarget.field_70165_t, this.attackTarget.func_174813_aQ().field_72338_b, this.attackTarget.field_70161_v);
        boolean canSee = this.entityHost.func_70635_at().func_75522_a((Entity)this.attackTarget);
        this.timeTargetVisible = canSee ? ++this.timeTargetVisible : 0;
        if (distToTargetSq <= (double)this.attackRangeSq && this.timeTargetVisible >= 20) {
            this.entityHost.func_70661_as().func_75499_g();
        } else if (this.timeTargetHidden < 100) {
            this.entityHost.func_70661_as().func_75497_a((Entity)this.attackTarget, this.entityMoveSpeed);
        }
        this.entityHost.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
        if (--this.timeUntilNextAttack <= 0) {
            if (distToTargetSq > (double)this.attackRangeSq || !canSee) {
                return;
            }
            float rangeRatio = MathHelper.func_76133_a((double)distToTargetSq) / this.attackRange;
            if (rangeRatio < 0.1f) {
                rangeRatio = 0.1f;
            } else if (rangeRatio > 1.0f) {
                rangeRatio = 1.0f;
            }
            this.rangedAttackEntityHost.func_82196_d(this.attackTarget, rangeRatio);
            this.timeUntilNextAttack = MathHelper.func_76141_d((float)(rangeRatio * (float)(this.maxRangedAttackTime - this.minRangedAttackTime) + (float)this.minRangedAttackTime));
        } else if (this.timeUntilNextAttack < 0) {
            this.entityHost.func_70624_b(this.attackTarget);
            float rangeRatio = MathHelper.func_76133_a((double)distToTargetSq) / this.attackRange;
            this.timeUntilNextAttack = MathHelper.func_76141_d((float)(rangeRatio * (float)(this.maxRangedAttackTime - this.minRangedAttackTime) + (float)this.minRangedAttackTime));
        }
    }
}

