/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo.entity.render;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelHorse;
import net.minecraft.client.renderer.entity.RenderHorse;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.LayeredTexture;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.util.ResourceLocation;

public class RenderFallenMount
extends RenderHorse {
    private static final String[] horseArmorTextures = new String[]{null, "textures/entity/horse/armor/horse_armor_iron.png", "textures/entity/horse/armor/horse_armor_gold.png", "textures/entity/horse/armor/horse_armor_diamond.png"};
    private static final String textureName = "textures/entity/horse/horse_zombie.png";
    private static final ResourceLocation zombieHorseTexture = new ResourceLocation("textures/entity/horse/horse_zombie.png");
    private static final Map<String, ResourceLocation> textureCache = Maps.newHashMap();

    public RenderFallenMount(RenderManager rm) {
        super(rm, new ModelHorse(), 0.75f);
    }

    protected ResourceLocation func_180581_a(EntityHorse horse) {
        if (horse.func_70658_aO() == 0) {
            return zombieHorseTexture;
        }
        return this.getArmoredTexture(horse);
    }

    private ResourceLocation getArmoredTexture(EntityHorse horse) {
        String s = horseArmorTextures[horse.func_110241_cb()];
        ResourceLocation resourcelocation = textureCache.get(s);
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation("Layered:" + s);
            Minecraft.func_71410_x().func_110434_K().func_110579_a(resourcelocation, (ITextureObject)new LayeredTexture(new String[]{textureName, s}));
            textureCache.put(s, resourcelocation);
        }
        return resourcelocation;
    }
}

