/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo.config;

import crazypants.enderzoo.Log;
import crazypants.enderzoo.config.Config;
import crazypants.enderzoo.config.SpawnConfigParser;
import crazypants.enderzoo.spawn.ISpawnEntry;
import crazypants.enderzoo.spawn.impl.SpawnEntry;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class SpawnConfig {
    private static final String RESOURCE_PATH = "/assets/enderzoo/config/";
    public static final String CONFIG_NAME_CORE = "SpawnConfig_Core.xml";
    public static final String CONFIG_NAME_USER = "SpawnConfig_User.xml";

    public static List<SpawnEntry> loadSpawnConfig() {
        List<SpawnEntry> result;
        File coreFile = new File(Config.configDirectory, CONFIG_NAME_CORE);
        String defaultVals = null;
        try {
            defaultVals = SpawnConfig.readConfigFile(coreFile, CONFIG_NAME_CORE, true);
        }
        catch (IOException e) {
            Log.error("Could not load core spawn config file " + coreFile + " from EnderZoo jar: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
        if (!coreFile.exists()) {
            Log.error("Could not load core config from " + coreFile + " as the file does not exist.");
            return null;
        }
        try {
            result = SpawnConfigParser.parseSpawnConfig(defaultVals);
        }
        catch (Exception e) {
            Log.error("Error parsing SpawnConfig_Core.xml:" + e);
            return Collections.emptyList();
        }
        Log.info("Loaded " + result.size() + " entries from core spawn config.");
        File userFile = new File(Config.configDirectory, CONFIG_NAME_USER);
        String userText = null;
        try {
            userText = SpawnConfig.readConfigFile(userFile, CONFIG_NAME_USER, false);
            if (userText == null || userText.trim().length() == 0) {
                Log.error("Empty user config file: " + userFile.getAbsolutePath());
            } else {
                List<SpawnEntry> userEntries = SpawnConfigParser.parseSpawnConfig(userText);
                Log.info("Loaded " + userEntries.size() + " entries from user spawn config.");
                SpawnConfig.merge(userEntries, result);
            }
        }
        catch (Exception e) {
            Log.error("Could not load user defined spawn entries from file: SpawnConfig_User.xml");
            e.printStackTrace();
        }
        return result;
    }

    private static void merge(List<SpawnEntry> userEntries, List<SpawnEntry> result) {
        for (SpawnEntry entry : userEntries) {
            SpawnConfig.removeFrom(entry, result);
            result.add(entry);
        }
    }

    private static void removeFrom(ISpawnEntry useEntry, List<SpawnEntry> result) {
        ISpawnEntry toRemove = null;
        for (ISpawnEntry iSpawnEntry : result) {
            if (!useEntry.getId().equals(iSpawnEntry.getId())) continue;
            toRemove = iSpawnEntry;
            break;
        }
        if (toRemove != null) {
            Log.info("Replace spawn config for " + toRemove.getId() + " with user supplied entry.");
            result.remove(toRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readConfigFile(File copyTo, String fileName, boolean replaceIfExists) throws IOException {
        if (!replaceIfExists && copyTo.exists()) {
            return SpawnConfig.readStream(new FileInputStream(copyTo));
        }
        InputStream in = SpawnConfig.class.getResourceAsStream(RESOURCE_PATH + fileName);
        if (in == null) {
            throw new IOException("Could not load resource /assets/enderzoo/config/" + fileName + " form classpath. ");
        }
        String output = SpawnConfig.readStream(in);
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(copyTo, false));
            writer.write(output.toString());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)writer);
        return output.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readStream(InputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuilder output = new StringBuilder();
        try {
            String line = reader.readLine();
            while (line != null) {
                output.append(line);
                output.append("\n");
                line = reader.readLine();
            }
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        return output.toString();
    }
}

