/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo.enchantment;

import crazypants.enderzoo.Log;
import crazypants.enderzoo.config.Config;
import crazypants.enderzoo.enchantment.EnchantmentWitherArrow;
import crazypants.enderzoo.enchantment.EnchantmentWitherWeapon;
import net.minecraft.enchantment.Enchantment;

public class Enchantments {
    private static Enchantments instance;
    private EnchantmentWitherArrow witherArrow;
    private EnchantmentWitherWeapon witherWeapon;

    public static Enchantments getInstance() {
        if (instance == null) {
            instance = new Enchantments();
            instance.registerEnchantments();
        }
        return instance;
    }

    private void registerEnchantments() {
        int id = Config.enchantmentWitherArrowId;
        if (id < 0) {
            id = this.getEmptyEnchantId();
        }
        if (id < 0) {
            Log.error("Could not find an empty enchantment ID to add enchanments");
            return;
        }
        this.witherArrow = new EnchantmentWitherArrow(id);
        id = Config.enchantmentWitherWeaponId;
        if (id < 0) {
            id = this.getEmptyEnchantId();
        }
        if (id < 0) {
            Log.error("Could not find an empty enchantment ID to add enchanments");
            return;
        }
        this.witherWeapon = new EnchantmentWitherWeapon(id);
    }

    private int getEmptyEnchantId() {
        for (int i = 0; i < 256; ++i) {
            if (Enchantment.func_180306_c((int)i) != null) continue;
            return i;
        }
        return -1;
    }
}

