/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo.entity;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TeleportHelper {
    private static final int DEFAULT_RND_TP_DISTANCE = 16;
    private static Random rand = new Random();

    public static boolean teleportRandomly(EntityLivingBase entity, int distance) {
        double d0 = entity.field_70165_t + (rand.nextDouble() - 0.5) * (double)distance;
        double d1 = entity.field_70163_u + (double)rand.nextInt(distance + 1) - (double)(distance / 2);
        double d2 = entity.field_70161_v + (rand.nextDouble() - 0.5) * (double)distance;
        return TeleportHelper.teleportTo(entity, d0, d1, d2, false);
    }

    public static boolean teleportRandomly(EntityLivingBase entity) {
        return TeleportHelper.teleportRandomly(entity, 16);
    }

    public static boolean teleportToEntity(EntityLivingBase entity, Entity toEntity) {
        Vec3 vec3 = new Vec3(entity.field_70165_t - toEntity.field_70165_t, entity.func_174813_aQ().field_72338_b + (double)(entity.field_70131_O / 2.0f) - toEntity.field_70163_u + (double)toEntity.func_70047_e(), entity.field_70161_v - toEntity.field_70161_v);
        vec3 = vec3.func_72432_b();
        double d0 = 16.0;
        double d1 = entity.field_70165_t + (rand.nextDouble() - 0.5) * 8.0 - vec3.field_72450_a * d0;
        double d2 = entity.field_70163_u + (double)(rand.nextInt(16) - 8) - vec3.field_72448_b * d0;
        double d3 = entity.field_70161_v + (rand.nextDouble() - 0.5) * 8.0 - vec3.field_72449_c * d0;
        return TeleportHelper.teleportTo(entity, d1, d2, d3, false);
    }

    public static boolean teleportTo(EntityLivingBase entity, double x, double y, double z, boolean fireEndermanEvent) {
        EnderTeleportEvent event = new EnderTeleportEvent(entity, x, y, z, 0.0f);
        if (fireEndermanEvent && MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        double d3 = entity.field_70165_t;
        double d4 = entity.field_70163_u;
        double d5 = entity.field_70161_v;
        entity.field_70165_t = event.targetX;
        entity.field_70163_u = event.targetY;
        entity.field_70161_v = event.targetZ;
        int xInt = MathHelper.func_76128_c((double)entity.field_70165_t);
        int yInt = MathHelper.func_76128_c((double)entity.field_70163_u);
        int zInt = MathHelper.func_76128_c((double)entity.field_70161_v);
        boolean flag = false;
        if (entity.field_70170_p.func_175668_a(new BlockPos(xInt, yInt, zInt), true)) {
            boolean foundGround = false;
            while (!foundGround && yInt > 0) {
                IBlockState bs = entity.field_70170_p.func_180495_p(new BlockPos(xInt, yInt - 1, zInt));
                if (bs != null && bs.func_177230_c() != null && bs.func_177230_c().func_149688_o().func_76230_c()) {
                    foundGround = true;
                    continue;
                }
                entity.field_70163_u -= 1.0;
                --yInt;
            }
            if (foundGround) {
                entity.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                if (entity.field_70170_p.func_72945_a((Entity)entity, entity.func_174813_aQ()).isEmpty() && !entity.field_70170_p.func_72953_d(entity.func_174813_aQ())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            entity.func_70107_b(d3, d4, d5);
            return false;
        }
        entity.func_70634_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        int short1 = 128;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float f = (rand.nextFloat() - 0.5f) * 0.2f;
            float f1 = (rand.nextFloat() - 0.5f) * 0.2f;
            float f2 = (rand.nextFloat() - 0.5f) * 0.2f;
            double d7 = d3 + (entity.field_70165_t - d3) * d6 + (rand.nextDouble() - 0.5) * (double)entity.field_70130_N * 2.0;
            double d8 = d4 + (entity.field_70163_u - d4) * d6 + rand.nextDouble() * (double)entity.field_70131_O;
            double d9 = d5 + (entity.field_70161_v - d5) * d6 + (rand.nextDouble() - 0.5) * (double)entity.field_70130_N * 2.0;
            entity.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, d7, d8, d9, (double)f, (double)f1, (double)f2, new int[0]);
        }
        entity.field_70170_p.func_72908_a(d3, d4, d5, "mob.endermen.portal", 1.0f, 1.0f);
        entity.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
        return true;
    }
}

