/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo.potion;

import crazypants.enderzoo.EnderZoo;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionHelper;

public class BrewingUtil {
    private static final ItemStack REDSTONE = new ItemStack(Items.field_151137_ax);
    private static final ItemStack GLOWSTONE = new ItemStack(Items.field_151114_aO);
    private static final ItemStack NETHER_WART = new ItemStack(Items.field_151075_bm);
    private static final ItemStack GUN_POWDER = new ItemStack(Items.field_151016_H);
    private static final ItemStack SPECKLED_MELLON = new ItemStack(Items.field_151060_bw);
    private static final ItemStack GHAST_TEAR = new ItemStack(Items.field_151073_bk);
    private static final ItemStack SPIDER_EYE = new ItemStack(Items.field_151070_bp);
    private static final ItemStack FERMENTED_SPIDER_EYE = new ItemStack(Items.field_151071_bq);

    public static ItemStack createHarmingPotion(boolean isAugmented, boolean isSplash) {
        ItemStack result = BrewingUtil.createAwkwardPotion();
        BrewingUtil.addIngredientToPotion(result, SPIDER_EYE);
        BrewingUtil.addIngredientToPotion(result, FERMENTED_SPIDER_EYE);
        if (isAugmented) {
            BrewingUtil.addIngredientToPotion(result, GLOWSTONE);
        }
        if (isSplash) {
            BrewingUtil.addIngredientToPotion(result, GUN_POWDER);
        }
        return result;
    }

    public static ItemStack createWitherPotion(boolean isProlonged, boolean isSplash) {
        ItemStack result = BrewingUtil.createAwkwardPotion();
        BrewingUtil.addIngredientToPotion(result, new ItemStack((Item)EnderZoo.itemWitheringDust));
        if (isProlonged) {
            BrewingUtil.addIngredientToPotion(result, REDSTONE);
        }
        if (isSplash) {
            BrewingUtil.addIngredientToPotion(result, GUN_POWDER);
        }
        return result;
    }

    public static ItemStack createHealthPotion(boolean isProlonged, boolean isAugmented, boolean isSplash) {
        ItemStack result = BrewingUtil.createAwkwardPotion();
        BrewingUtil.addIngredientToPotion(result, SPECKLED_MELLON);
        if (isProlonged) {
            BrewingUtil.addIngredientToPotion(result, REDSTONE);
        }
        if (isAugmented) {
            BrewingUtil.addIngredientToPotion(result, GLOWSTONE);
        }
        if (isSplash) {
            BrewingUtil.addIngredientToPotion(result, GUN_POWDER);
        }
        return result;
    }

    public static ItemStack createRegenerationPotion(boolean isProlonged, boolean isAugmented, boolean isSplash) {
        ItemStack result = BrewingUtil.createAwkwardPotion();
        BrewingUtil.addIngredientToPotion(result, GHAST_TEAR);
        if (isProlonged) {
            BrewingUtil.addIngredientToPotion(result, REDSTONE);
        }
        if (isAugmented) {
            BrewingUtil.addIngredientToPotion(result, GLOWSTONE);
        }
        if (isSplash) {
            BrewingUtil.addIngredientToPotion(result, GUN_POWDER);
        }
        return result;
    }

    public static ItemStack createAwkwardPotion() {
        ItemStack result = new ItemStack((Item)Items.field_151068_bn);
        BrewingUtil.addIngredientToPotion(result, NETHER_WART);
        return result;
    }

    public static void addIngredientToPotion(ItemStack targetPotion, ItemStack ingredient) {
        int originalMetaData = targetPotion.func_77952_i();
        int metaWithAddedIngredient = BrewingUtil.addPotionEffect(originalMetaData, ingredient);
        List originalEffects = Items.field_151068_bn.func_77834_f(originalMetaData);
        List withAddedEffects = Items.field_151068_bn.func_77834_f(metaWithAddedIngredient);
        if (!(originalMetaData > 0 && originalEffects == withAddedEffects || originalEffects != null && (originalEffects.equals(withAddedEffects) || withAddedEffects == null))) {
            if (originalMetaData != metaWithAddedIngredient) {
                targetPotion.func_77964_b(metaWithAddedIngredient);
            }
        } else if (!ItemPotion.func_77831_g((int)originalMetaData) && ItemPotion.func_77831_g((int)metaWithAddedIngredient)) {
            targetPotion.func_77964_b(metaWithAddedIngredient);
        }
    }

    public static int addPotionEffect(int targetMetaData, ItemStack ingredient) {
        return ingredient == null ? targetMetaData : (ingredient.func_77973_b().func_150892_m(ingredient) ? PotionHelper.func_77913_a((int)targetMetaData, (String)ingredient.func_77973_b().func_150896_i(ingredient)) : targetMetaData);
    }
}

