/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.wirelessredstone.block;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.slimevoid.wirelessredstone.api.IBlockRedstoneWirelessOverride;
import net.slimevoid.wirelessredstone.core.WRCore;
import net.slimevoid.wirelessredstone.data.LoggerRedstoneWireless;
import net.slimevoid.wirelessredstone.tileentity.TileEntityRedstoneWireless;

public abstract class BlockRedstoneWireless
extends BlockContainer {
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private List<IBlockRedstoneWirelessOverride> overrides;

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{POWERED, FACING});
    }

    public int func_176201_c(IBlockState state) {
        boolean powered = (Boolean)state.func_177229_b((IProperty)POWERED);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return this.getMetaFromProps(powered, facing);
    }

    protected int getMetaFromProps(boolean powered, EnumFacing facing) {
        int power = powered ? 1 : 0;
        return power | this.getFacingIndex(facing) << 1;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(this.getPoweredFromMeta(meta) > 0)).func_177226_a((IProperty)FACING, (Comparable)this.getFacing(this.getFacingFromMeta(meta)));
    }

    protected IBlockState getInitialState() {
        return this.field_176227_L.func_177621_b().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH);
    }

    protected int getPoweredFromMeta(int meta) {
        return meta & 1;
    }

    protected int getFacingFromMeta(int meta) {
        return (meta & 7) >> 1;
    }

    protected int getFacingIndex(EnumFacing facing) {
        int index = facing == EnumFacing.SOUTH ? 1 : (facing == EnumFacing.EAST ? 2 : (facing == EnumFacing.WEST ? 3 : 0));
        return index;
    }

    protected EnumFacing getFacing(int index) {
        EnumFacing facing;
        switch (index) {
            case 1: {
                facing = EnumFacing.SOUTH;
                break;
            }
            case 2: {
                facing = EnumFacing.EAST;
                break;
            }
            case 3: {
                facing = EnumFacing.WEST;
                break;
            }
            default: {
                facing = EnumFacing.NORTH;
            }
        }
        return facing;
    }

    protected BlockRedstoneWireless(int x, float hardness, float resistance) {
        super(Material.field_151594_q);
        this.func_149711_c(hardness);
        this.func_149752_b(resistance);
        this.func_149647_a(WRCore.wirelessRedstone);
        this.overrides = new ArrayList<IBlockRedstoneWirelessOverride>();
        this.func_180632_j(this.getInitialState());
    }

    public void addOverride(IBlockRedstoneWirelessOverride override) {
        this.overrides.add(override);
    }

    public synchronized void setState(World world, BlockPos pos, boolean state) {
        LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).write(world.field_72995_K, "setState(world," + pos.func_177958_n() + "," + pos.func_177956_o() + "," + pos.func_177952_p() + "," + state + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
        try {
            world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(state)));
            world.func_175689_h(pos);
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).writeStackTrace(e);
        }
    }

    public synchronized boolean getState(IBlockAccess iblockaccess, BlockPos pos) {
        LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).write(false, "getState(world," + pos.func_177958_n() + "," + pos.func_177956_o() + "," + pos.func_177952_p() + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
        boolean state = false;
        try {
            IBlockState blockState = iblockaccess.func_180495_p(pos);
            return this.getPoweredFromMeta(this.func_176201_c(blockState)) == 1;
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).writeStackTrace(e);
            return state;
        }
    }

    public String getFreq(World world, BlockPos pos) {
        LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).write(world.field_72995_K, "getFreq(world," + pos.func_177958_n() + "," + pos.func_177956_o() + "," + pos.func_177952_p() + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
        try {
            TileEntity tileentity = world.func_175625_s(pos);
            if (tileentity == null) {
                return null;
            }
            if (tileentity instanceof TileEntityRedstoneWireless) {
                return ((TileEntityRedstoneWireless)tileentity).getFreq().toString();
            }
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).writeStackTrace(e);
        }
        return null;
    }

    public abstract void changeFreq(World var1, BlockPos var2, Object var3, Object var4);

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).write(world.field_72995_K, "onBlockAdded(world," + x + "," + y + "," + z + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
        boolean prematureExit = false;
        for (IBlockRedstoneWirelessOverride override : this.overrides) {
            if (!override.beforeBlockRedstoneWirelessAdded(world, x, y, z)) continue;
            prematureExit = true;
        }
        if (prematureExit) {
            return;
        }
        try {
            TileEntityRedstoneWireless entity = (TileEntityRedstoneWireless)this.func_149915_a(world, 0);
            world.func_175690_a(pos, (TileEntity)entity);
            this.onBlockRedstoneWirelessAdded(world, pos, state);
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).writeStackTrace(e);
        }
        for (IBlockRedstoneWirelessOverride override : this.overrides) {
            override.afterBlockRedstoneWirelessAdded(world, x, y, z);
        }
    }

    protected abstract void onBlockRedstoneWirelessAdded(World var1, BlockPos var2, IBlockState var3);

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).write(world.field_72995_K, "onBlockRemoval(world," + x + "," + y + "," + z + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
        boolean prematureExit = false;
        for (IBlockRedstoneWirelessOverride override : this.overrides) {
            if (!override.beforeBlockRedstoneWirelessRemoved(world, x, y, z, state)) continue;
            prematureExit = true;
        }
        if (prematureExit) {
            return;
        }
        try {
            this.onBlockRedstoneWirelessRemoved(world, pos, state);
            world.func_175713_t(pos);
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).writeStackTrace(e);
        }
        for (IBlockRedstoneWirelessOverride override : this.overrides) {
            override.afterBlockRedstoneWirelessRemoved(world, x, y, z);
        }
    }

    protected abstract void onBlockRedstoneWirelessRemoved(World var1, BlockPos var2, IBlockState var3);

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityplayer, EnumFacing side, float a, float b, float c) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).write(world.field_72995_K, "blockActivated(world," + x + "," + y + "," + z + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
        boolean prematureExit = false;
        for (IBlockRedstoneWirelessOverride override : this.overrides) {
            if (!override.beforeBlockRedstoneWirelessActivated(world, pos, state, entityplayer, side)) continue;
            prematureExit = true;
        }
        if (prematureExit) {
            return false;
        }
        boolean output = false;
        if (entityplayer.func_70093_af()) {
            this.rotateBlock(world, pos, EnumFacing.UP);
        } else {
            try {
                output = this.onBlockRedstoneWirelessActivated(world, pos, state, entityplayer, side);
            }
            catch (Exception e) {
                LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).writeStackTrace(e);
                return false;
            }
            for (IBlockRedstoneWirelessOverride override : this.overrides) {
                override.afterBlockRedstoneWirelessActivated(world, x, y, z, entityplayer);
            }
        }
        return output;
    }

    protected abstract boolean onBlockRedstoneWirelessActivated(World var1, BlockPos var2, IBlockState var3, EntityPlayer var4, EnumFacing var5);

    public void func_176204_a(World world, BlockPos pos, IBlockState state, Block neighbor) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).write(world.field_72995_K, "onNeighborBlockChange(world," + x + "," + y + "," + z + "," + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
        boolean prematureExit = false;
        for (IBlockRedstoneWirelessOverride override : this.overrides) {
            if (!override.beforeBlockRedstoneWirelessNeighborChange(world, x, y, z, neighbor)) continue;
            prematureExit = true;
        }
        if (prematureExit) {
            return;
        }
        try {
            this.onBlockRedstoneWirelessNeighborChange((IBlockAccess)world, pos, neighbor);
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).writeStackTrace(e);
        }
        for (IBlockRedstoneWirelessOverride override : this.overrides) {
            override.afterBlockRedstoneWirelessNeighborChange(world, x, y, z, neighbor);
        }
    }

    protected abstract void onBlockRedstoneWirelessNeighborChange(IBlockAccess var1, BlockPos var2, Block var3);

    public boolean func_149662_c() {
        return this.isBlockRedstoneWirelessOpaqueCube();
    }

    public boolean func_149744_f() {
        return true;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return this.getBlockRedstoneWirelessEntity();
    }

    protected abstract TileEntityRedstoneWireless getBlockRedstoneWirelessEntity();

    public static void notifyNeighbors(World world, BlockPos pos, Block block) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        LoggerRedstoneWireless.getInstance("BlockRedstoneWireless").write(world.field_72995_K, "notifyNeighbors(world," + x + "," + y + "," + z + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
        world.func_175685_c(pos, block);
        world.func_175685_c(pos.func_177982_a(-1, 0, 0), block);
        world.func_175685_c(pos.func_177982_a(1, 0, 0), block);
        world.func_175685_c(pos.func_177982_a(0, -1, 0), block);
        world.func_175685_c(pos.func_177982_a(0, 1, 0), block);
        world.func_175685_c(pos.func_177982_a(0, 0, -1), block);
        world.func_175685_c(pos.func_177982_a(0, 0, 1), block);
    }

    public void func_180655_c(World world, BlockPos pos, IBlockState state, Random random) {
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).write(world.field_72995_K, "updateTick(world," + x + "," + y + "," + z + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
        boolean prematureExit = false;
        for (IBlockRedstoneWirelessOverride override : this.overrides) {
            if (!override.beforeUpdateRedstoneWirelessTick(world, x, y, z, random)) continue;
            prematureExit = true;
        }
        if (prematureExit) {
            return;
        }
        try {
            this.updateRedstoneWirelessTick(world, pos, state, random);
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).writeStackTrace(e);
        }
        for (IBlockRedstoneWirelessOverride override : this.overrides) {
            override.afterUpdateRedstoneWirelessTick(world, x, y, z, random);
        }
    }

    protected abstract void updateRedstoneWirelessTick(World var1, BlockPos var2, IBlockState var3, Random var4);

    public int func_176211_b(IBlockAccess iblockaccess, BlockPos pos, IBlockState state, EnumFacing side) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        try {
            if (iblockaccess instanceof World) {
                LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).write(((World)iblockaccess).field_72995_K, "isPoweringTo(iblockaccess," + x + "," + y + "," + z + "," + side.func_176610_l() + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
                return this.isRedstoneWirelessPoweringTo((World)iblockaccess, pos, state, side);
            }
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).writeStackTrace(e);
        }
        return 0;
    }

    protected abstract int isRedstoneWirelessPoweringTo(World var1, BlockPos var2, IBlockState var3, EnumFacing var4);

    public int func_180656_a(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing side) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (world instanceof World) {
            LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).write(((World)world).field_72995_K, "isIndirectlyPoweringTo(world," + x + "," + y + "," + z + "," + side.func_176610_l() + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
            try {
                return this.isRedstoneWirelessIndirectlyPoweringTo((World)world, pos, state, side);
            }
            catch (Exception e) {
                LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).writeStackTrace(e);
            }
        }
        return 0;
    }

    protected abstract int isRedstoneWirelessIndirectlyPoweringTo(World var1, BlockPos var2, IBlockState var3, EnumFacing var4);

    public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.isBlockRedstoneWirelessSolidOnSide(world, pos, side);
    }

    protected abstract boolean isBlockRedstoneWirelessSolidOnSide(IBlockAccess var1, BlockPos var2, EnumFacing var3);

    protected abstract boolean isBlockRedstoneWirelessOpaqueCube();

    public int func_149645_b() {
        return 3;
    }
}

