/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.wirelessredstone.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.slimevoid.wirelessredstone.block.BlockRedstoneWireless;
import net.slimevoid.wirelessredstone.core.WirelessRedstone;
import net.slimevoid.wirelessredstone.ether.RedstoneEther;
import net.slimevoid.wirelessredstone.network.handlers.RedstoneEtherPacketHandler;
import net.slimevoid.wirelessredstone.tileentity.TileEntityRedstoneWireless;
import net.slimevoid.wirelessredstone.tileentity.TileEntityRedstoneWirelessR;

public class BlockRedstoneWirelessR
extends BlockRedstoneWireless {
    private boolean initialSchedule;

    public BlockRedstoneWirelessR(int x, float hardness, float resistance) {
        super(x, hardness, resistance);
        this.func_149672_a(Block.field_149777_j);
        this.func_149675_a(true);
        this.initialSchedule = true;
    }

    public boolean hasTicked() {
        return !this.initialSchedule;
    }

    @Override
    public void changeFreq(World world, BlockPos pos, Object oldFreq, Object freq) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        RedstoneEther.getInstance().remReceiver(world, x, y, z, oldFreq);
        RedstoneEther.getInstance().addReceiver(world, x, y, z, freq);
        this.func_180650_b(world, pos, world.func_180495_p(pos), world.field_73012_v);
    }

    @Override
    protected void onBlockRedstoneWirelessAdded(World world, BlockPos pos, IBlockState state) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        RedstoneEther.getInstance().addReceiver(world, x, y, z, this.getFreq(world, pos));
        BlockRedstoneWirelessR.notifyNeighbors(world, pos, state.func_177230_c());
        this.func_180650_b(world, pos, state, null);
    }

    @Override
    protected void onBlockRedstoneWirelessRemoved(World world, BlockPos pos, IBlockState state) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        RedstoneEther.getInstance().remReceiver(world, x, y, z, this.getFreq(world, pos));
    }

    @Override
    protected boolean onBlockRedstoneWirelessActivated(World world, BlockPos pos, IBlockState state, EntityPlayer entityplayer, EnumFacing side) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity != null && tileentity instanceof TileEntityRedstoneWirelessR) {
            entityplayer.openGui((Object)WirelessRedstone.instance, 0, world, x, y, z);
        }
        return true;
    }

    @Override
    protected void onBlockRedstoneWirelessNeighborChange(IBlockAccess iblockaccess, BlockPos pos, Block neighbor) {
        if (neighbor.equals((Object)this)) {
            return;
        }
        this.func_180650_b((World)iblockaccess, pos, iblockaccess.func_180495_p(pos), null);
    }

    @Override
    protected TileEntityRedstoneWireless getBlockRedstoneWirelessEntity() {
        return new TileEntityRedstoneWirelessR();
    }

    @Override
    protected void updateRedstoneWirelessTick(World world, BlockPos pos, IBlockState state, Random random) {
        if (this.initialSchedule) {
            this.initialSchedule = false;
        }
        if (world == null) {
            return;
        }
        String freq = this.getFreq(world, pos);
        boolean oldState = this.getState((IBlockAccess)world, pos);
        boolean newState = RedstoneEther.getInstance().getFreqState(world, freq);
        if (newState != oldState) {
            TileEntity entity;
            this.setState(world, pos, newState);
            world.func_175689_h(pos);
            BlockRedstoneWirelessR.notifyNeighbors(world, pos, (Block)this);
            if (!world.field_72995_K && (entity = world.func_175625_s(pos)) instanceof TileEntityRedstoneWireless) {
                RedstoneEtherPacketHandler.sendEtherTileToAll((TileEntityRedstoneWireless)entity, world);
            }
        }
    }

    @Override
    protected int isRedstoneWirelessPoweringTo(World world, BlockPos pos, IBlockState state, EnumFacing side) {
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof TileEntityRedstoneWireless) {
            return ((TileEntityRedstoneWireless)entity).isPoweringDirection(side) && this.getState((IBlockAccess)world, pos) ? 16 : 0;
        }
        return 0;
    }

    @Override
    protected int isRedstoneWirelessIndirectlyPoweringTo(World world, BlockPos pos, IBlockState state, EnumFacing side) {
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof TileEntityRedstoneWireless) {
            if (!((TileEntityRedstoneWireless)entity).isPoweringIndirectly(side)) {
                return 0;
            }
            return this.func_176211_b((IBlockAccess)world, pos, state, side);
        }
        return 0;
    }

    @Override
    protected boolean isBlockRedstoneWirelessSolidOnSide(IBlockAccess iblockaccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    protected boolean isBlockRedstoneWirelessOpaqueCube() {
        return true;
    }
}

