/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.wirelessredstone.client.presentation.gui;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.slimevoid.library.network.PacketUpdate;
import net.slimevoid.library.util.helpers.PacketHelper;
import net.slimevoid.wirelessredstone.api.IGuiRedstoneWirelessDeviceOverride;
import net.slimevoid.wirelessredstone.api.IGuiRedstoneWirelessOverride;
import net.slimevoid.wirelessredstone.api.IWirelessDevice;
import net.slimevoid.wirelessredstone.client.presentation.gui.GuiButtonWireless;
import net.slimevoid.wirelessredstone.client.presentation.gui.GuiButtonWirelessExit;
import net.slimevoid.wirelessredstone.client.presentation.gui.GuiRedstoneWirelessContainer;
import net.slimevoid.wirelessredstone.data.LoggerRedstoneWireless;
import net.slimevoid.wirelessredstone.inventory.ContainerRedstoneDevice;
import net.slimevoid.wirelessredstone.network.packets.PacketWirelessDevice;

public abstract class GuiRedstoneWirelessDevice
extends GuiRedstoneWirelessContainer {
    IWirelessDevice wirelessDevice;

    public GuiRedstoneWirelessDevice(World world, EntityPlayer entityplayer, ContainerRedstoneDevice device) {
        super(device);
        this.wirelessDevice = device.getDevice();
        this.entityplayer = entityplayer;
        this.world = world;
        this.field_146999_f = 177;
        this.field_147000_g = 166;
    }

    @Override
    protected void addControls() {
        this.field_146292_n.add(new GuiButtonWireless(0, this.field_146294_l / 2 + 10, this.field_146295_m / 2 - 20, 20, 20, "+"));
        this.field_146292_n.add(new GuiButtonWireless(1, this.field_146294_l / 2 - 30, this.field_146295_m / 2 - 20, 20, 20, "-"));
        this.field_146292_n.add(new GuiButtonWireless(2, this.field_146294_l / 2 + 32, this.field_146295_m / 2 - 20, 20, 20, "+10"));
        this.field_146292_n.add(new GuiButtonWireless(3, this.field_146294_l / 2 - 52, this.field_146295_m / 2 - 20, 20, 20, "-10"));
        this.field_146292_n.add(new GuiButtonWireless(4, this.field_146294_l / 2 + 54, this.field_146295_m / 2 - 20, 26, 20, "+100"));
        this.field_146292_n.add(new GuiButtonWireless(5, this.field_146294_l / 2 - 80, this.field_146295_m / 2 - 20, 26, 20, "-100"));
        this.field_146292_n.add(new GuiButtonWireless(6, this.field_146294_l / 2 + 48, this.field_146295_m / 2 - 42, 32, 20, "+1000"));
        this.field_146292_n.add(new GuiButtonWireless(7, this.field_146294_l / 2 - 80, this.field_146295_m / 2 - 42, 32, 20, "-1000"));
        this.field_146292_n.add(new GuiButtonWirelessExit(100, (this.field_146294_l - this.field_146999_f) / 2 + this.field_146999_f - 13 - 1, (this.field_146295_m - this.field_147000_g) / 2 + 1));
    }

    protected void func_146284_a(GuiButton guibutton) {
        try {
            int oldFreq;
            int freq;
            Object a = this.getFreq();
            Object b = this.getFreq();
            try {
                freq = Integer.parseInt(a.toString());
                oldFreq = Integer.parseInt(b.toString());
            }
            catch (NumberFormatException e) {
                return;
            }
            switch (guibutton.field_146127_k) {
                case 0: {
                    ++freq;
                    break;
                }
                case 1: {
                    --freq;
                    break;
                }
                case 2: {
                    freq += 10;
                    break;
                }
                case 3: {
                    freq -= 10;
                    break;
                }
                case 4: {
                    freq += 100;
                    break;
                }
                case 5: {
                    freq -= 100;
                    break;
                }
                case 6: {
                    freq += 1000;
                    break;
                }
                case 7: {
                    freq -= 1000;
                    break;
                }
                case 100: {
                    this.close();
                }
            }
            if (freq > 9999) {
                freq -= 10000;
            }
            if (freq < 0) {
                freq += 10000;
            }
            boolean prematureExit = false;
            for (IGuiRedstoneWirelessOverride override : this.overrides) {
                if (!((IGuiRedstoneWirelessDeviceOverride)override).beforeFrequencyChange(this.world, this.wirelessDevice, oldFreq, freq)) continue;
                prematureExit = true;
            }
            if (prematureExit) {
                return;
            }
            this.notifyServer(freq - oldFreq);
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance("GuiRedstoneWirelessDevice").writeStackTrace(e);
        }
    }

    protected void notifyServer(Object freq) {
        PacketWirelessDevice packet = new PacketWirelessDevice(this.wirelessDevice);
        packet.setCommand(this.getCommand());
        packet.setFreq(freq);
        PacketHelper.sendToServer((PacketUpdate)packet);
    }

    protected abstract String getCommand();

    protected void drawFrequency(int y) {
        this.field_146289_q.func_78276_b(this.getFreq() + "", this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.getFreq() + "") / 2, this.field_147000_g / 2 + y, 0x404040);
    }

    protected void drawFrequencyAndBox(int y) {
        this.drawStringBorder(this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.getFreq() + "") / 2, this.field_147000_g / 2 + y, this.field_146999_f / 2 + this.field_146289_q.func_78256_a(this.getFreq() + "") / 2);
        this.drawFrequency(y);
    }

    protected void drawFrequencyLabel(int y) {
        this.field_146289_q.func_78276_b("Frequency", this.field_146999_f / 2 - this.field_146289_q.func_78256_a("Frequency") / 2, y, 0x404040);
    }

    protected void drawFrequencyLabelAndBox(int y) {
        this.drawStringBorder(this.field_146999_f / 2 - this.field_146289_q.func_78256_a("Frequency") / 2, y, this.field_146999_f / 2 + this.field_146289_q.func_78256_a("Frequency") / 2);
        this.drawFrequencyLabel(y);
    }

    @Override
    protected void drawForegroundObjects(int i, int j) {
        this.drawFrequencyLabelAndBox(32);
        this.drawFrequencyAndBox(-35);
    }

    @Override
    protected String getGuiName() {
        return this.wirelessDevice.func_70005_c_();
    }

    protected Object getFreq() {
        return this.wirelessDevice.getFreq();
    }

    public void setFreq(Object freq) {
        this.wirelessDevice.setFreq(freq);
    }
}

