/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.wirelessredstone.core;

import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.slimevoid.library.util.helpers.PacketHelper;
import net.slimevoid.wirelessredstone.api.IBlockRedstoneWirelessOverride;
import net.slimevoid.wirelessredstone.block.BlockRedstoneWireless;
import net.slimevoid.wirelessredstone.block.BlockRedstoneWirelessR;
import net.slimevoid.wirelessredstone.block.BlockRedstoneWirelessT;
import net.slimevoid.wirelessredstone.core.WirelessRedstone;
import net.slimevoid.wirelessredstone.data.LoggerRedstoneWireless;
import net.slimevoid.wirelessredstone.network.NetworkEvent;
import net.slimevoid.wirelessredstone.tileentity.TileEntityRedstoneWireless;
import net.slimevoid.wirelessredstone.tileentity.TileEntityRedstoneWirelessR;
import net.slimevoid.wirelessredstone.tileentity.TileEntityRedstoneWirelessT;

public class WRCore {
    public static Block blockWirelessR;
    public static Block blockWirelessT;
    public static int rxID;
    public static int txID;
    public static int spriteTItem;
    public static int spriteRItem;
    public static int maxEtherFrequencies;
    public static boolean isLoaded;
    public static CreativeTabs wirelessRedstone;

    public static boolean preInitialize() {
        PacketHelper.registerHandler();
        WirelessRedstone.proxy.init();
        WRCore.initBlocks();
        WirelessRedstone.proxy.addOverrides();
        WRCore.registerBlocks();
        WRCore.addRecipes();
        NetworkEvent.registerNetworkEvents();
        return true;
    }

    public static void initialize() {
        WirelessRedstone.proxy.registerRenderInformation();
        WirelessRedstone.proxy.registerTileEntitySpecialRenderer(TileEntityRedstoneWireless.class);
    }

    private static void initBlocks() {
        blockWirelessR = new BlockRedstoneWirelessR(rxID, 1.0f, 8.0f).func_149663_c("wirelessredstone.receiver");
        blockWirelessT = new BlockRedstoneWirelessT(txID, 1.0f, 8.0f).func_149663_c("wirelessredstone.transmitter");
    }

    private static void registerBlocks() {
        GameRegistry.registerBlock((Block)blockWirelessR, (String)"wirelessredstone.receiver");
        GameRegistry.registerTileEntityWithAlternatives(TileEntityRedstoneWirelessR.class, (String)"wirelessredstone.receiver", (String[])new String[]{"Wireless Receiver"});
        GameRegistry.registerBlock((Block)blockWirelessT, (String)"wirelessredstone.transmitter");
        GameRegistry.registerTileEntityWithAlternatives(TileEntityRedstoneWirelessT.class, (String)"wirelessredstone.transmitter", (String[])new String[]{"Wireless Transmitter"});
    }

    private static void addRecipes() {
        GameRegistry.addRecipe((ItemStack)new ItemStack(blockWirelessR, 1), (Object[])new Object[]{"IRI", "RLR", "IRI", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('L'), Blocks.field_150442_at});
        GameRegistry.addRecipe((ItemStack)new ItemStack(blockWirelessT, 1), (Object[])new Object[]{"IRI", "RTR", "IRI", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('T'), Blocks.field_150429_aA});
    }

    public static void addOverrideToReceiver(IBlockRedstoneWirelessOverride override) {
        LoggerRedstoneWireless.getInstance("Wireless Redstone").write(true, "Override added to " + LoggerRedstoneWireless.filterClassName(blockWirelessR.getClass().toString()) + " - " + LoggerRedstoneWireless.filterClassName(override.getClass().toString()), LoggerRedstoneWireless.LogLevel.DEBUG);
        ((BlockRedstoneWireless)blockWirelessR).addOverride(override);
    }

    public static void addOverrideToTransmitter(IBlockRedstoneWirelessOverride override) {
        LoggerRedstoneWireless.getInstance("Wireless Redstone").write(true, "Override added to " + LoggerRedstoneWireless.filterClassName(blockWirelessT.getClass().toString()) + " - " + LoggerRedstoneWireless.filterClassName(override.getClass().toString()), LoggerRedstoneWireless.LogLevel.DEBUG);
        ((BlockRedstoneWireless)blockWirelessT).addOverride(override);
    }

    public static boolean mergeItemStack(Container container, ItemStack stackToMerge, int slotStart, int slotEnd, boolean reverseOrder) {
        ItemStack stackInSlot;
        Slot slot;
        boolean stackMerged = false;
        int realSlotStart = slotStart;
        if (reverseOrder) {
            realSlotStart = slotEnd - 1;
        }
        if (stackToMerge.func_77985_e()) {
            while (stackToMerge.field_77994_a > 0 && (!reverseOrder && realSlotStart < slotEnd || reverseOrder && realSlotStart >= slotStart)) {
                slot = (Slot)container.field_75151_b.get(realSlotStart);
                stackInSlot = slot.func_75211_c();
                if (stackInSlot != null && stackInSlot.func_77973_b().equals(stackToMerge.func_77973_b()) && (!stackToMerge.func_77981_g() || stackToMerge.func_77952_i() == stackInSlot.func_77952_i()) && ItemStack.func_77970_a((ItemStack)stackToMerge, (ItemStack)stackInSlot)) {
                    int totalStackSize = stackInSlot.field_77994_a + stackToMerge.field_77994_a;
                    if (totalStackSize <= stackToMerge.func_77976_d() && totalStackSize <= slot.func_75219_a()) {
                        stackToMerge.field_77994_a = 0;
                        stackInSlot.field_77994_a = totalStackSize;
                        slot.func_75218_e();
                        stackMerged = true;
                    } else if (stackInSlot.field_77994_a < stackToMerge.func_77976_d() && stackInSlot.field_77994_a < slot.func_75219_a()) {
                        stackToMerge.field_77994_a -= stackToMerge.func_77976_d() - stackInSlot.field_77994_a;
                        stackInSlot.field_77994_a = stackToMerge.func_77976_d();
                        slot.func_75218_e();
                        stackMerged = true;
                    }
                }
                if (reverseOrder) {
                    --realSlotStart;
                    continue;
                }
                ++realSlotStart;
            }
        }
        if (stackToMerge.field_77994_a > 0) {
            realSlotStart = reverseOrder ? slotEnd - 1 : slotStart;
            while (!reverseOrder && realSlotStart < slotEnd || reverseOrder && realSlotStart >= slotStart) {
                slot = (Slot)container.field_75151_b.get(realSlotStart);
                stackInSlot = slot.func_75211_c();
                if (stackInSlot == null) {
                    slot.func_75215_d(stackToMerge.func_77946_l());
                    if (stackToMerge.field_77994_a > slot.func_75219_a()) {
                        slot.func_75211_c().field_77994_a = slot.func_75219_a();
                        stackToMerge.field_77994_a -= slot.func_75219_a();
                    } else {
                        stackToMerge.field_77994_a = 0;
                        stackMerged = true;
                    }
                    slot.func_75218_e();
                    break;
                }
                if (reverseOrder) {
                    --realSlotStart;
                    continue;
                }
                ++realSlotStart;
            }
        }
        return stackMerged;
    }

    static {
        maxEtherFrequencies = 10000;
        isLoaded = false;
    }
}

