/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.wirelessredstone.device;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.slimevoid.wirelessredstone.core.WRCore;
import net.slimevoid.wirelessredstone.core.lib.NBTHelper;

public abstract class ItemWirelessDevice
extends Item {
    public ItemWirelessDevice(int itemID) {
        this.func_77625_d(1);
        this.func_77637_a(WRCore.wirelessRedstone);
    }

    public int func_77626_a(ItemStack itemstack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack itemstack) {
        return EnumAction.NONE;
    }

    public boolean onDroppedByPlayer(ItemStack itemstack, EntityPlayer entityplayer) {
        this.setState(itemstack, false);
        return this.onDeviceDroppedByPlayer(itemstack, entityplayer);
    }

    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int i, boolean isHeld) {
        if (this.isValidDevice(itemstack)) {
            if (!itemstack.func_77942_o()) {
                itemstack.func_77982_d(new NBTTagCompound());
                this.getFreq(itemstack);
                this.getState(itemstack);
            }
            if (entity != null && entity instanceof EntityLivingBase) {
                EntityLivingBase entitylivingbase = (EntityLivingBase)entity;
                this.onUpdateDevice(itemstack, world, entitylivingbase, i, isHeld);
                if (!isHeld) {
                    this.setState(itemstack, false);
                }
            }
        }
    }

    protected abstract void onUpdateDevice(ItemStack var1, World var2, EntityLivingBase var3, int var4, boolean var5);

    protected abstract boolean isValidDevice(ItemStack var1);

    protected abstract boolean onDeviceDroppedByPlayer(ItemStack var1, EntityPlayer var2);

    public boolean getState(ItemStack itemstack) {
        if (this.isValidDevice(itemstack)) {
            return NBTHelper.getBoolean(itemstack, "State", false);
        }
        return false;
    }

    public Object getFreq(ItemStack itemstack) {
        if (this.isValidDevice(itemstack)) {
            return NBTHelper.getString(itemstack, "Freq", "0");
        }
        return "0";
    }

    public void setState(ItemStack itemstack, boolean state) {
        if (this.isValidDevice(itemstack)) {
            NBTHelper.setBoolean(itemstack, "State", state);
        }
    }

    public void setFreq(ItemStack itemstack, Object freq) {
        if (this.isValidDevice(itemstack)) {
            NBTHelper.setString(itemstack, "Freq", String.valueOf(freq));
        }
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List lines, boolean showAdvancedInfo) {
        lines.add("Frequency [" + this.getFreq(itemstack) + "]");
    }

    public boolean func_77651_p() {
        return true;
    }

    public boolean func_77662_d() {
        return true;
    }
}

