/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.wirelessredstone.device;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.slimevoid.wirelessredstone.api.IWirelessDevice;
import net.slimevoid.wirelessredstone.data.WirelessCoordinates;
import net.slimevoid.wirelessredstone.device.ItemWirelessDevice;

public abstract class WirelessDevice
implements IWirelessDevice {
    protected World world;
    protected EntityLivingBase entityliving;
    protected int xCoord;
    protected int yCoord;
    protected int zCoord;
    protected Object freq;
    protected boolean state;

    protected WirelessDevice(World world, EntityLivingBase entity, ItemStack itemstack) {
        this.world = world;
        this.entityliving = entity;
        this.setCoords((int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v);
        if (itemstack != null && itemstack.func_77942_o()) {
            this.readFromNBT(itemstack.func_77978_p());
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.freq = nbttagcompound.func_74779_i("Freq");
        this.state = nbttagcompound.func_74767_n("State");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74778_a("Freq", String.valueOf(this.freq));
        nbttagcompound.func_74757_a("State", this.state);
    }

    @Override
    public void setFreq(Object freq) {
        this.freq = freq;
    }

    @Override
    public void setState(boolean state) {
        this.state = state;
    }

    @Override
    public void setOwner(EntityLiving entity) {
        this.entityliving = entity;
    }

    @Override
    public void setCoords(WirelessCoordinates coords) {
        int x = coords.getX();
        int y = coords.getY();
        int z = coords.getZ();
        this.setCoords(x, y, z);
    }

    @Override
    public void setCoords(int x, int y, int z) {
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
    }

    @Override
    public WirelessCoordinates getCoords() {
        return new WirelessCoordinates(this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public Object getFreq() {
        return this.freq;
    }

    @Override
    public boolean getState() {
        return this.state;
    }

    @Override
    public EntityLivingBase getOwner() {
        return this.entityliving;
    }

    @Override
    public void activate(World world, Entity entity) {
        this.state = true;
        if (!world.field_72995_K) {
            this.doActivateCommand();
        }
    }

    @Override
    public void deactivate(World world, Entity entity, boolean isForced) {
        this.state = true;
        if (!world.field_72995_K) {
            this.doDeactivateCommand();
        }
    }

    @Override
    public abstract void doActivateCommand();

    @Override
    public abstract void doDeactivateCommand();

    protected abstract String getActivateCommand();

    protected abstract String getDeactivateCommand();

    @Override
    public abstract boolean isBeingHeld(EntityLivingBase var1);

    public int func_70302_i_() {
        return 0;
    }

    public ItemStack func_70301_a(int i) {
        return null;
    }

    public ItemStack func_70298_a(int i, int j) {
        return null;
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
    }

    public int func_70297_j_() {
        return 0;
    }

    public void func_70296_d() {
        ItemStack heldItem = this.entityliving.func_70694_bm();
        if (heldItem != null && heldItem.func_77973_b() != null && heldItem.func_77973_b() instanceof ItemWirelessDevice) {
            if (!heldItem.func_77942_o()) {
                heldItem.func_77982_d(new NBTTagCompound());
            }
            this.writeToNBT(heldItem.func_77978_p());
        }
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void func_174889_b(EntityPlayer entityplayer) {
    }

    public void func_174886_c(EntityPlayer entityplayer) {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    public boolean func_145818_k_() {
        return false;
    }
}

