/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.wirelessredstone.ether;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.slimevoid.wirelessredstone.api.IRedstoneEtherOverride;
import net.slimevoid.wirelessredstone.data.LoggerRedstoneWireless;
import net.slimevoid.wirelessredstone.ether.RedstoneEtherFrequency;
import net.slimevoid.wirelessredstone.ether.RedstoneEtherNode;

public class RedstoneEther {
    private Map<Integer, Map<String, RedstoneEtherFrequency>> ether = new HashMap<Integer, Map<String, RedstoneEtherFrequency>>();
    private List<IRedstoneEtherOverride> overrides = new ArrayList<IRedstoneEtherOverride>();
    private String currentWorldName = "";
    private static RedstoneEther instance;
    private JFrame gui;

    private RedstoneEther() {
    }

    public static RedstoneEther getInstance() {
        if (instance == null) {
            instance = new RedstoneEther();
        }
        return instance;
    }

    private HashMap<String, RedstoneEtherFrequency> getEtherClone(World world) {
        return (HashMap)((HashMap)this.ether.get(world.hashCode())).clone();
    }

    private Map<String, RedstoneEtherFrequency> getEtherSafe(World world) {
        this.checkWorldHash(world);
        return this.ether.get(world.hashCode());
    }

    private Map<String, RedstoneEtherFrequency> getEtherRaw(World world) {
        return this.ether.get(world.hashCode());
    }

    public void addOverride(IRedstoneEtherOverride override) {
        this.overrides.add(override);
    }

    public void assGui(JFrame gui) {
        this.gui = gui;
    }

    public synchronized void addTransmitter(World world, int x, int y, int z, Object object) {
        if (world == null) {
            return;
        }
        LoggerRedstoneWireless.getInstance("RedstoneEther").write(world.field_72995_K, "addTransmitter(world, " + x + ", " + y + ", " + z + ", " + object + ")", LoggerRedstoneWireless.LogLevel.INFO);
        boolean prematureExit = false;
        for (IRedstoneEtherOverride override : this.overrides) {
            if (!override.beforeAddTransmitter(world, x, y, z, object)) continue;
            prematureExit = true;
        }
        if (prematureExit) {
            return;
        }
        try {
            this.checkWorldHash(world);
            if (!this.freqIsset(world, object)) {
                this.createFreq(world, object);
            }
            RedstoneEtherNode node = new RedstoneEtherNode(x, y, z);
            node.freq = object;
            this.getEtherRaw(world).get(object).addTransmitter(world, node);
            if (this.gui != null) {
                this.gui.repaint();
            }
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance("RedstoneEther").writeStackTrace(e);
        }
        for (IRedstoneEtherOverride override : this.overrides) {
            override.afterAddTransmitter(world, x, y, z, object);
        }
    }

    public synchronized void remTransmitter(World world, int x, int y, int z, Object object) {
        if (world == null) {
            return;
        }
        LoggerRedstoneWireless.getInstance("RedstoneEther").write(world.field_72995_K, "remTransmitter(world, " + x + ", " + y + ", " + z + ", " + object + ")", LoggerRedstoneWireless.LogLevel.INFO);
        boolean prematureExit = false;
        for (IRedstoneEtherOverride override : this.overrides) {
            if (!override.beforeRemTransmitter(world, x, y, z, object)) continue;
            prematureExit = true;
        }
        if (prematureExit) {
            return;
        }
        try {
            this.checkWorldHash(world);
            if (this.freqIsset(world, object)) {
                this.getEtherRaw(world).get(object).remTransmitter(world, x, y, z);
                if (this.getEtherRaw(world).get(object).count() == 0) {
                    this.getEtherRaw(world).remove(object);
                }
            }
            if (this.gui != null) {
                this.gui.repaint();
            }
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance("RedstoneEther").writeStackTrace(e);
        }
        for (IRedstoneEtherOverride override : this.overrides) {
            override.afterRemTransmitter(world, x, y, z, object);
        }
    }

    public synchronized void addReceiver(World world, int x, int y, int z, Object freq) {
        if (world == null) {
            return;
        }
        LoggerRedstoneWireless.getInstance("RedstoneEther").write(world.field_72995_K, "addReceiver(world, " + x + ", " + y + ", " + z + ", " + freq + ")", LoggerRedstoneWireless.LogLevel.INFO);
        boolean prematureExit = false;
        for (IRedstoneEtherOverride override : this.overrides) {
            if (!override.beforeAddReceiver(world, x, y, z, freq)) continue;
            prematureExit = true;
        }
        if (prematureExit) {
            return;
        }
        try {
            this.checkWorldHash(world);
            if (!this.freqIsset(world, freq)) {
                this.createFreq(world, freq);
            }
            RedstoneEtherNode node = new RedstoneEtherNode(x, y, z);
            node.freq = freq;
            this.getEtherRaw(world).get(freq).addReceiver(world, node);
            if (this.gui != null) {
                this.gui.repaint();
            }
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance("RedstoneEther").writeStackTrace(e);
        }
        for (IRedstoneEtherOverride override : this.overrides) {
            override.afterAddReceiver(world, x, y, z, freq);
        }
    }

    public synchronized void remReceiver(World world, int x, int y, int z, Object oldFreq) {
        if (world == null) {
            return;
        }
        LoggerRedstoneWireless.getInstance("RedstoneEther").write(world.field_72995_K, "remReceiver(world, " + x + ", " + y + ", " + z + ", " + oldFreq + ")", LoggerRedstoneWireless.LogLevel.INFO);
        boolean prematureExit = false;
        for (IRedstoneEtherOverride override : this.overrides) {
            if (!override.beforeRemReceiver(world, x, y, z, oldFreq)) continue;
            prematureExit = true;
        }
        if (prematureExit) {
            return;
        }
        try {
            this.checkWorldHash(world);
            if (this.freqIsset(world, oldFreq)) {
                this.getEtherRaw(world).get(oldFreq).remReceiver(world, x, y, z);
                if (this.getEtherRaw(world).get(oldFreq).count() == 0) {
                    this.getEtherRaw(world).remove(oldFreq);
                }
            }
            if (this.gui != null) {
                this.gui.repaint();
            }
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance("RedstoneEther").writeStackTrace(e);
        }
        for (IRedstoneEtherOverride override : this.overrides) {
            override.afterRemReceiver(world, x, y, z, oldFreq);
        }
    }

    private synchronized void checkWorldHash(World world) {
        if (!this.currentWorldName.equals(world.func_72912_H().func_76065_j())) {
            this.ether = new HashMap<Integer, Map<String, RedstoneEtherFrequency>>();
            this.currentWorldName = world.func_72912_H().func_76065_j();
        }
        if (!this.ether.containsKey(world.hashCode())) {
            this.ether.put(world.hashCode(), new HashMap());
        }
        if (this.gui != null) {
            this.gui.repaint();
        }
    }

    private synchronized void createFreq(World world, Object freq) {
        this.checkWorldHash(world);
        this.getEtherSafe(world).put(String.valueOf(freq), new RedstoneEtherFrequency());
    }

    private synchronized boolean freqIsset(World world, Object object) {
        this.checkWorldHash(world);
        return this.getEtherRaw(world).containsKey(object);
    }

    public synchronized boolean getFreqState(World world, Object object) {
        LoggerRedstoneWireless.getInstance("RedstoneEther").write(world.field_72995_K, "getFreqState(world, " + object + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
        boolean prematureExit = false;
        for (IRedstoneEtherOverride override : this.overrides) {
            if (!override.beforeGetFreqState(world, object)) continue;
            prematureExit = true;
        }
        boolean returnState = false;
        if (!prematureExit && this.freqIsset(world, object)) {
            returnState = this.getEtherRaw(world).get(object).getState(world);
        }
        boolean out = returnState;
        for (IRedstoneEtherOverride override : this.overrides) {
            out = override.afterGetFreqState(world, object, out);
        }
        return out;
    }

    public synchronized void setTransmitterState(World world, int x, int y, int z, Object freq, boolean state) {
        if (world == null) {
            return;
        }
        LoggerRedstoneWireless.getInstance("RedstoneEther").write(world.field_72995_K, "setTransmitterState(world, " + x + ", " + y + ", " + z + ", " + freq + ", " + state + ")", LoggerRedstoneWireless.LogLevel.INFO);
        boolean prematureExit = false;
        for (IRedstoneEtherOverride override : this.overrides) {
            if (!override.beforeSetTransmitterState(world, x, y, z, freq, state)) continue;
            prematureExit = true;
        }
        if (prematureExit) {
            return;
        }
        try {
            if (this.freqIsset(world, freq)) {
                this.getEtherRaw(world).get(freq).setTransmitterState(world, x, y, z, state);
            }
            if (this.gui != null) {
                this.gui.repaint();
            }
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance("RedstoneEther").writeStackTrace(e);
        }
        for (IRedstoneEtherOverride override : this.overrides) {
            override.afterSetTransmitterState(world, x, y, z, freq, state);
        }
    }

    public synchronized int[] getClosestActiveTransmitter(World world, int x, int y, int z, String freq) {
        int[] coords = null;
        for (IRedstoneEtherOverride override : this.overrides) {
            coords = override.beforeGetClosestActiveTransmitter(x, y, z, freq);
        }
        if (coords == null) {
            try {
                if (this.freqIsset(world, freq)) {
                    coords = this.getEtherRaw(world).get(freq).getClosestActiveTransmitter(world, x, y, z);
                }
            }
            catch (Exception e) {
                LoggerRedstoneWireless.getInstance("RedstoneEther").writeStackTrace(e);
            }
        }
        for (IRedstoneEtherOverride override : this.overrides) {
            coords = override.afterGetClosestActiveTransmitter(x, y, z, freq, coords);
        }
        return coords;
    }

    public synchronized int[] getClosestTransmitter(World world, int x, int y, int z, String freq) {
        if (this.freqIsset(world, freq)) {
            return this.getEtherRaw(world).get(freq).getClosestTransmitter(world, x, y, z);
        }
        return null;
    }

    public synchronized boolean isFrequencyActive(World world, String freq) {
        return this.getEtherRaw(world).get(freq).getState(world);
    }

    public static float pythagoras(int[] a, int[] b) {
        double x = 0.0;
        if (a.length <= b.length) {
            for (int n = 0; n < a.length; ++n) {
                x += Math.pow(a[n] - b[n], 2.0);
            }
        } else {
            for (int n = 0; n < b.length; ++n) {
                x += Math.pow(a[n] - b[n], 2.0);
            }
        }
        return (float)Math.sqrt(x);
    }

    public synchronized List<RedstoneEtherNode> getRXNodes(World world) {
        LinkedList<RedstoneEtherNode> list = new LinkedList<RedstoneEtherNode>();
        try {
            HashMap<String, RedstoneEtherFrequency> etherClone = this.getEtherClone(world);
            for (RedstoneEtherFrequency freq : etherClone.values()) {
                list.addAll(freq.rxs.values());
            }
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance("RedstoneEther").writeStackTrace(e);
        }
        return list;
    }

    public synchronized List<RedstoneEtherNode> getTXNodes(World world) {
        LinkedList<RedstoneEtherNode> list = new LinkedList<RedstoneEtherNode>();
        try {
            HashMap<String, RedstoneEtherFrequency> etherClone = this.getEtherClone(world);
            for (RedstoneEtherFrequency freq : etherClone.values()) {
                list.addAll(freq.txs.values());
            }
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance("RedstoneEther").writeStackTrace(e);
        }
        return list;
    }

    public synchronized Map<String, Integer> getLoadedFrequenciesForWorld(World world) {
        HashMap<String, Integer> list = new HashMap<String, Integer>();
        try {
            HashMap<String, RedstoneEtherFrequency> etherClone = this.getEtherClone(world);
            for (String freq : etherClone.keySet()) {
                if (list.containsKey(freq)) {
                    list.put(freq, (Integer)list.get(freq) + etherClone.get(freq).count());
                    continue;
                }
                list.put(freq, etherClone.get(freq).count());
            }
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance("RedstoneEther").writeStackTrace(e);
        }
        return list;
    }

    public synchronized boolean isLoaded(World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        if (world == null) {
            return false;
        }
        LoggerRedstoneWireless.getInstance("RedstoneEther").write(world.field_72995_K, "isLoaded(world, " + x + ", " + y + ", " + z + ") [" + (world.func_180495_p(pos).func_177230_c() != Blocks.field_150350_a) + "&" + (world.func_175625_s(pos) != null) + "]", LoggerRedstoneWireless.LogLevel.DEBUG);
        boolean prematureExit = false;
        for (IRedstoneEtherOverride override : this.overrides) {
            if (!override.beforeIsLoaded(world, x, y, z)) continue;
            prematureExit = true;
        }
        boolean returnState = false;
        if (!prematureExit) {
            returnState = world.func_180495_p(pos).func_177230_c() != Blocks.field_150350_a && world.func_175625_s(pos) != null;
        }
        boolean out = returnState;
        for (IRedstoneEtherOverride override : this.overrides) {
            out = override.afterIsLoaded(world, x, y, z, out);
        }
        return out;
    }
}

