/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.wirelessredstone.ether;

import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.slimevoid.wirelessredstone.core.WRCore;
import net.slimevoid.wirelessredstone.data.LoggerRedstoneWireless;
import net.slimevoid.wirelessredstone.data.WirelessReadWriteLock;
import net.slimevoid.wirelessredstone.ether.RedstoneEther;
import net.slimevoid.wirelessredstone.ether.RedstoneEtherNode;

public class RedstoneEtherFrequency {
    public Map<RedstoneEtherNode, RedstoneEtherNode> txs = new TreeMap<RedstoneEtherNode, RedstoneEtherNode>();
    private WirelessReadWriteLock txLock = new WirelessReadWriteLock();
    public Map<RedstoneEtherNode, RedstoneEtherNode> rxs = new TreeMap<RedstoneEtherNode, RedstoneEtherNode>();
    private WirelessReadWriteLock rxLock = new WirelessReadWriteLock();

    public boolean getState(World world) {
        boolean state = false;
        try {
            LinkedList<RedstoneEtherNode> rem = new LinkedList<RedstoneEtherNode>();
            LoggerRedstoneWireless.getInstance("RedstoneEtherFrequency").write(world.field_72995_K, "getState(world)", LoggerRedstoneWireless.LogLevel.DEBUG);
            this.txLock.readLock(world);
            for (RedstoneEtherNode tx : this.txs.values()) {
                if (!RedstoneEther.getInstance().isLoaded(world, tx.x, tx.y, tx.z)) {
                    LoggerRedstoneWireless.getInstance("RedstoneEtherFrequency").write(world.field_72995_K, "getState(world) - " + tx.toString() + " not loaded. Removing", LoggerRedstoneWireless.LogLevel.WARNING);
                    rem.add(tx);
                    continue;
                }
                if (state || !tx.state) continue;
                state = true;
                break;
            }
            this.txLock.readUnlock();
            for (RedstoneEtherNode tx : rem) {
                this.remTransmitter(world, tx.x, tx.y, tx.z);
            }
        }
        catch (InterruptedException e) {
            LoggerRedstoneWireless.getInstance("RedstoneEtherFrequency").writeStackTrace(e);
        }
        return state;
    }

    public void setTransmitterState(World world, int x, int y, int z, boolean state) {
        try {
            if (!this.txs.containsKey(new RedstoneEtherNode(x, y, z))) {
                return;
            }
            this.txLock.readLock(world);
            LoggerRedstoneWireless.getInstance("RedstoneEtherFrequency").write(world.field_72995_K, "setTransmitterState(world, " + x + ", " + y + ", " + z + ", " + state + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
            this.txs.get((Object)new RedstoneEtherNode((int)x, (int)y, (int)z)).state = state;
            this.txLock.readUnlock();
            this.updateReceivers(world);
        }
        catch (InterruptedException e) {
            LoggerRedstoneWireless.getInstance("RedstoneEtherFrequency").writeStackTrace(e);
        }
    }

    public void addTransmitter(World world, RedstoneEtherNode tx) {
        try {
            this.txLock.writeLock(world);
            LoggerRedstoneWireless.getInstance("RedstoneEtherFrequency").write(world.field_72995_K, "addTransmitter(" + tx.toString() + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
            this.txs.put(tx, tx);
            this.txLock.writeUnlock();
        }
        catch (InterruptedException e) {
            LoggerRedstoneWireless.getInstance("RedstoneEtherFrequency").writeStackTrace(e);
        }
    }

    public void addReceiver(World world, RedstoneEtherNode rx) {
        try {
            this.rxLock.writeLock(world);
            LoggerRedstoneWireless.getInstance("RedstoneEtherFrequency").write(world.field_72995_K, "addTransmitter(" + rx.toString() + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
            this.rxs.put(rx, rx);
            this.rxLock.writeUnlock();
        }
        catch (InterruptedException e) {
            LoggerRedstoneWireless.getInstance("RedstoneEtherFrequency").writeStackTrace(e);
        }
    }

    public void remTransmitter(World world, int x, int y, int z) {
        try {
            if (!this.txs.containsKey(new RedstoneEtherNode(x, y, z))) {
                return;
            }
            this.txLock.writeLock(world);
            LoggerRedstoneWireless.getInstance("RedstoneEtherFrequency").write(world.field_72995_K, "remTransmitter(world, " + x + ", " + y + ", " + z + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
            this.txs.remove(new RedstoneEtherNode(x, y, z));
            this.txLock.writeUnlock();
            this.updateReceivers(world);
        }
        catch (InterruptedException e) {
            LoggerRedstoneWireless.getInstance("RedstoneEtherFrequency").writeStackTrace(e);
        }
    }

    public void remReceiver(World world, int x, int y, int z) {
        try {
            if (!this.rxs.containsKey(new RedstoneEtherNode(x, y, z))) {
                return;
            }
            this.rxLock.writeLock(world);
            LoggerRedstoneWireless.getInstance("RedstoneEtherFrequency").write(world.field_72995_K, "remReceiver(" + x + ", " + y + ", " + z + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
            this.rxs.remove(new RedstoneEtherNode(x, y, z));
            this.rxLock.writeUnlock();
        }
        catch (InterruptedException e) {
            LoggerRedstoneWireless.getInstance("RedstoneEtherFrequency").writeStackTrace(e);
        }
    }

    private void updateReceivers(World world) {
        try {
            LinkedList<RedstoneEtherNode> rem = new LinkedList<RedstoneEtherNode>();
            LinkedList update = new LinkedList();
            LoggerRedstoneWireless.getInstance("RedstoneEtherFrequency").write(world.field_72995_K, "updateReceivers(world)", LoggerRedstoneWireless.LogLevel.DEBUG);
            this.rxLock.readLock(world);
            for (RedstoneEtherNode rx : this.rxs.values()) {
                if (!RedstoneEther.getInstance().isLoaded(world, rx.x, rx.y, rx.z)) {
                    LoggerRedstoneWireless.getInstance("RedstoneEtherFrequency").write(world.field_72995_K, "updateReceivers(world) " + rx.toString() + " not loaded. Removing", LoggerRedstoneWireless.LogLevel.WARNING);
                    rem.add(rx);
                    continue;
                }
                BlockPos pos = new BlockPos(rx.x, rx.y, rx.z);
                WRCore.blockWirelessR.func_180650_b(world, pos, world.func_180495_p(pos), world.field_73012_v);
            }
            this.rxLock.readUnlock();
            for (RedstoneEtherNode rx : rem) {
                this.remReceiver(world, rx.x, rx.y, rx.z);
            }
        }
        catch (InterruptedException e) {
            LoggerRedstoneWireless.getInstance("RedstoneEtherFrequency").writeStackTrace(e);
        }
    }

    public int count() {
        return this.rxs.size() + this.txs.size();
    }

    public int[] getClosestActiveTransmitter(World world, int x, int y, int z) {
        try {
            int[] pos = new int[3];
            int[] myPos = new int[]{x, y, z};
            int[] tmpPos = new int[3];
            boolean first = true;
            float h = 0.0f;
            this.txLock.readLock(world);
            for (RedstoneEtherNode node : this.txs.values()) {
                if (!node.state) continue;
                if (first) {
                    pos = new int[]{node.x, node.y, node.z};
                    h = RedstoneEther.pythagoras(myPos, pos);
                    first = false;
                    continue;
                }
                tmpPos[0] = node.x;
                tmpPos[1] = node.y;
                tmpPos[2] = node.z;
                if (!(h > RedstoneEther.pythagoras(myPos, tmpPos))) continue;
                pos[0] = node.x;
                pos[1] = node.y;
                pos[2] = node.z;
            }
            this.txLock.readUnlock();
            if (first) {
                return null;
            }
            return pos;
        }
        catch (InterruptedException e) {
            LoggerRedstoneWireless.getInstance("RedstoneEtherFrequency").writeStackTrace(e);
            return null;
        }
    }

    public int[] getClosestTransmitter(World world, int x, int y, int z) {
        try {
            int[] pos = new int[3];
            int[] myPos = new int[]{x, y, z};
            int[] tmpPos = new int[3];
            boolean first = true;
            float h = 0.0f;
            this.txLock.readLock(world);
            for (RedstoneEtherNode node : this.txs.values()) {
                if (first) {
                    pos = new int[]{node.x, node.y, node.z};
                    h = RedstoneEther.pythagoras(myPos, pos);
                    first = false;
                    continue;
                }
                tmpPos[0] = node.x;
                tmpPos[1] = node.y;
                tmpPos[2] = node.z;
                if (!(h > RedstoneEther.pythagoras(myPos, tmpPos))) continue;
                pos[0] = node.x;
                pos[1] = node.y;
                pos[2] = node.z;
            }
            this.txLock.readUnlock();
            if (first) {
                return null;
            }
            return pos;
        }
        catch (InterruptedException e) {
            LoggerRedstoneWireless.getInstance("RedstoneEtherFrequency").writeStackTrace(e);
            return null;
        }
    }
}

