/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.wirelessredstone.network.handlers;

import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.slimevoid.library.network.PacketUpdate;
import net.slimevoid.library.util.helpers.PacketHelper;
import net.slimevoid.wirelessredstone.data.LoggerRedstoneWireless;
import net.slimevoid.wirelessredstone.ether.RedstoneEther;
import net.slimevoid.wirelessredstone.ether.RedstoneEtherNode;
import net.slimevoid.wirelessredstone.network.packets.PacketRedstoneEther;
import net.slimevoid.wirelessredstone.tileentity.TileEntityRedstoneWireless;
import net.slimevoid.wirelessredstone.tileentity.TileEntityRedstoneWirelessR;
import net.slimevoid.wirelessredstone.tileentity.TileEntityRedstoneWirelessT;

public class RedstoneEtherPacketHandler {
    public static void sendEtherTileToAll(TileEntityRedstoneWireless entity, World world) {
        PacketRedstoneEther packet = new PacketRedstoneEther(entity, world);
        LoggerRedstoneWireless.getInstance("ServerRedstoneEtherPacketHandler").write(world.field_72995_K, "sendEtherTileToAll(" + packet.toString() + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
        PacketHelper.broadcastPacket((PacketUpdate)packet);
    }

    public static void sendEtherTileToAllInRange(TileEntityRedstoneWireless entity, World world, int range) {
        PacketRedstoneEther packet = new PacketRedstoneEther(entity, world);
        LoggerRedstoneWireless.getInstance("ServerRedstoneEtherPacketHandler").write(world.field_72995_K, "sendEtherTileToAllInRange(" + packet.toString() + ", " + range + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
        PacketHelper.sendToAllAround((PacketUpdate)packet, (int)entity.func_174877_v().func_177958_n(), (int)entity.func_174877_v().func_177956_o(), (int)entity.func_174877_v().func_177952_p(), (int)range, (int)world.field_73011_w.func_177502_q());
    }

    public static void sendEtherTileTo(EntityPlayerMP entityplayermp, TileEntityRedstoneWireless entity, World world) {
        PacketRedstoneEther packet = new PacketRedstoneEther(entity, world);
        LoggerRedstoneWireless.getInstance("ServerRedstoneEtherPacketHandler").write(world.field_72995_K, "sendEtherTileTo(" + entityplayermp.func_145748_c_() + "," + packet.toString() + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
        PacketHelper.sendToPlayer((PacketUpdate)packet, (EntityPlayerMP)entityplayermp);
    }

    public static void sendEtherNodeTileToAll(RedstoneEtherNode node) {
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0);
        TileEntity entity = world.func_175625_s(node.getPos());
        if (entity instanceof TileEntityRedstoneWireless) {
            RedstoneEtherPacketHandler.sendEtherTileToAll((TileEntityRedstoneWireless)entity, (World)world);
        }
    }

    public static void sendEtherTilesTo(EntityPlayerMP entityplayermp) {
        TileEntity entity;
        LoggerRedstoneWireless.getInstance("ServerRedstoneEtherPacketHandler").write(false, "sendEtherTilesTo(" + entityplayermp.func_145748_c_() + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0);
        List<RedstoneEtherNode> list = RedstoneEther.getInstance().getRXNodes(entityplayermp.func_130014_f_());
        for (RedstoneEtherNode node : list) {
            entity = world.func_175625_s(node.getPos());
            if (!(entity instanceof TileEntityRedstoneWirelessR)) continue;
            RedstoneEtherPacketHandler.sendEtherTileTo(entityplayermp, (TileEntityRedstoneWirelessR)entity, (World)world);
        }
        list = RedstoneEther.getInstance().getTXNodes(entityplayermp.func_130014_f_());
        for (RedstoneEtherNode node : list) {
            entity = world.func_175625_s(node.getPos());
            if (!(entity instanceof TileEntityRedstoneWirelessT)) continue;
            RedstoneEtherPacketHandler.sendEtherTileTo(entityplayermp, (TileEntityRedstoneWirelessT)entity, (World)world);
        }
    }

    public static void sendEtherTilesToAll() {
        LoggerRedstoneWireless.getInstance("ServerRedstoneEtherPacketHandler").write(false, "sendEtherTilesToAll()", LoggerRedstoneWireless.LogLevel.DEBUG);
        for (WorldServer world : DimensionManager.getWorlds()) {
            TileEntity entity;
            List<RedstoneEtherNode> list = RedstoneEther.getInstance().getRXNodes((World)world);
            for (RedstoneEtherNode node : list) {
                entity = world.func_175625_s(node.getPos());
                if (!(entity instanceof TileEntityRedstoneWirelessR)) continue;
                RedstoneEtherPacketHandler.sendEtherTileToAll((TileEntityRedstoneWirelessR)entity, (World)world);
            }
            list = RedstoneEther.getInstance().getTXNodes((World)world);
            for (RedstoneEtherNode node : list) {
                entity = world.func_175625_s(node.getPos());
                if (!(entity instanceof TileEntityRedstoneWirelessT)) continue;
                RedstoneEtherPacketHandler.sendEtherTileToAll((TileEntityRedstoneWirelessT)entity, (World)world);
            }
        }
    }

    public static void sendEtherFrequencyTilesToAll(List<RedstoneEtherNode> txs, List<RedstoneEtherNode> rxs) {
        TileEntity entity;
        LoggerRedstoneWireless.getInstance("ServerRedstoneEtherPacketHandler").write(false, "sendEtherFrequencyTilesToAll()", LoggerRedstoneWireless.LogLevel.DEBUG);
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0);
        for (RedstoneEtherNode node : rxs) {
            entity = world.func_175625_s(node.getPos());
            if (!(entity instanceof TileEntityRedstoneWirelessR)) continue;
            RedstoneEtherPacketHandler.sendEtherTileToAll((TileEntityRedstoneWirelessR)entity, (World)world);
        }
        for (RedstoneEtherNode node : txs) {
            entity = world.func_175625_s(node.getPos());
            if (!(entity instanceof TileEntityRedstoneWirelessT)) continue;
            RedstoneEtherPacketHandler.sendEtherTileToAll((TileEntityRedstoneWirelessT)entity, (World)world);
        }
    }

    public static void sendEtherPacketToServer(String command, int x, int y, int z, Object freq, boolean state) {
        PacketRedstoneEther packet = new PacketRedstoneEther(command);
        packet.setPosition(x, y, z, 0);
        packet.setFreq(freq);
        packet.setState(state);
        LoggerRedstoneWireless.getInstance("ClientRedstoneEtherPacketHandler").write(true, "sendRedstoneEtherPacket(" + packet.toString() + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
        PacketHelper.sendToServer((PacketUpdate)packet);
    }
}

