/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.wirelessredstone.network.packets.core;

import java.util.HashMap;
import java.util.Map;

public class PacketRedstoneWirelessCommands {
    private static Map<Integer, String> commandList = new HashMap<Integer, String>();

    public static String commandToString(int command) {
        for (wirelessCommands value : wirelessCommands.values()) {
            if (!(value != null & value.getCommand() == command)) continue;
            return value.toString();
        }
        String commandString = PacketRedstoneWirelessCommands.getRegisteredCommandString(command);
        if (!commandString.equals("")) {
            return commandString;
        }
        return "No Command Exists with value " + command;
    }

    private static String getRegisteredCommandString(int command) {
        if (commandList.containsKey(command)) {
            return commandList.get(command);
        }
        return "";
    }

    public static void registerCommands() {
        wirelessCommands.addTransmitter.value = 0;
        wirelessCommands.addTransmitter.name = "addTransmitter";
        PacketRedstoneWirelessCommands.registerCommand(wirelessCommands.addTransmitter.name);
        wirelessCommands.remTransmitter.value = 1;
        wirelessCommands.remTransmitter.name = "remTransmitter";
        PacketRedstoneWirelessCommands.registerCommand(wirelessCommands.remTransmitter.name);
        wirelessCommands.addReceiver.value = 2;
        wirelessCommands.addReceiver.name = "addReceiver";
        PacketRedstoneWirelessCommands.registerCommand(wirelessCommands.addReceiver.name);
        wirelessCommands.remReceiver.value = 3;
        wirelessCommands.remReceiver.name = "remReceiver";
        PacketRedstoneWirelessCommands.registerCommand(wirelessCommands.remReceiver.name);
        wirelessCommands.setTransmitterState.value = 4;
        wirelessCommands.setTransmitterState.name = "setTransmitterState";
        PacketRedstoneWirelessCommands.registerCommand(wirelessCommands.setTransmitterState.name);
        wirelessCommands.changeFreq.value = 5;
        wirelessCommands.changeFreq.name = "changeFreq";
        PacketRedstoneWirelessCommands.registerCommand(wirelessCommands.changeFreq.name);
        wirelessCommands.fetchTile.value = 6;
        wirelessCommands.fetchTile.name = "fetchTile";
        PacketRedstoneWirelessCommands.registerCommand(wirelessCommands.fetchTile.name);
        wirelessCommands.fetchEther.value = 7;
        wirelessCommands.fetchEther.name = "fetchEther";
        PacketRedstoneWirelessCommands.registerCommand(wirelessCommands.fetchEther.name);
        wirelessCommands.sendGui.value = 8;
        wirelessCommands.sendGui.name = "sendGui";
        PacketRedstoneWirelessCommands.registerCommand(wirelessCommands.sendGui.name);
        wirelessCommands.sendDeviceGui.value = 9;
        wirelessCommands.sendDeviceGui.name = "sendDeviceGui";
        PacketRedstoneWirelessCommands.registerCommand(wirelessCommands.sendDeviceGui.name);
    }

    private static int getNextAvailableCommand() {
        return commandList.size() - 1;
    }

    public static void registerCommand(String name) {
        int nextID = PacketRedstoneWirelessCommands.getNextAvailableCommand();
        if (!commandList.containsKey(nextID)) {
            commandList.put(nextID, name);
        }
    }

    public static enum wirelessCommands {
        addTransmitter,
        remTransmitter,
        addReceiver,
        remReceiver,
        setTransmitterState,
        changeFreq,
        fetchTile,
        fetchEther,
        sendGui,
        sendDeviceGui;

        private int value;
        private String name;

        public int getCommand() {
            if (this != null) {
                return this.value;
            }
            return -1;
        }

        public String toString() {
            if (this != null && this.name != null && !this.name.isEmpty()) {
                return this.name;
            }
            return "Command[" + (Object)((Object)this) + " is not initialzed";
        }
    }
}

