/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.wirelessredstone.tileentity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.server.gui.IUpdatePlayerListBox;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.slimevoid.wirelessredstone.api.IRedstoneWirelessData;
import net.slimevoid.wirelessredstone.api.ITileEntityRedstoneWirelessOverride;
import net.slimevoid.wirelessredstone.api.IWirelessData;
import net.slimevoid.wirelessredstone.block.BlockRedstoneWireless;
import net.slimevoid.wirelessredstone.data.LoggerRedstoneWireless;

public abstract class TileEntityRedstoneWireless
extends TileEntity
implements IInventory,
IUpdatePlayerListBox {
    protected BlockRedstoneWireless blockRedstoneWireless;
    public boolean firstTick = false;
    public Object oldFreq = "";
    public Object currentFreq = "0";
    protected boolean[] powerRoute;
    protected boolean[] indirPower;
    public HashMap<String, IRedstoneWirelessData> tileData = new HashMap();
    protected static List<ITileEntityRedstoneWirelessOverride> overrides = new ArrayList<ITileEntityRedstoneWirelessOverride>();

    public TileEntityRedstoneWireless(BlockRedstoneWireless block) {
        this.blockRedstoneWireless = block;
        this.flushPowerRoute();
        this.flushIndirPower();
    }

    public static void addOverride(ITileEntityRedstoneWirelessOverride override) {
        overrides.add(override);
    }

    public int func_70302_i_() {
        return 0;
    }

    public ItemStack func_70301_a(int i) {
        return this.getRedstoneWirelessStackInSlot(i);
    }

    protected ItemStack getRedstoneWirelessStackInSlot(int i) {
        ItemStack itemstack = null;
        for (ITileEntityRedstoneWirelessOverride override : overrides) {
            if (!override.handleInventory()) continue;
            itemstack = override.getStackInSlot(this, i, itemstack);
        }
        return itemstack;
    }

    public Object getFreq() {
        return this.currentFreq;
    }

    public void setFreq(Object freq) {
        try {
            this.currentFreq = freq;
            this.func_73660_a();
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance("WirelessRedstone: " + ((Object)((Object)this)).getClass().toString()).writeStackTrace(e);
        }
    }

    public int getBlockCoord(int i) {
        switch (i) {
            case 0: {
                return this.field_174879_c.func_177958_n();
            }
            case 1: {
                return this.field_174879_c.func_177956_o();
            }
            case 2: {
                return this.field_174879_c.func_177952_p();
            }
        }
        return 0;
    }

    public void func_73660_a() {
        boolean prematureExit = false;
        for (ITileEntityRedstoneWirelessOverride override : overrides) {
            if (!override.beforeUpdateEntity(this)) continue;
            prematureExit = true;
        }
        if (!prematureExit) {
            String freq = this.getFreq().toString();
            if (!this.oldFreq.equals(freq) || this.firstTick) {
                this.blockRedstoneWireless.changeFreq(this.field_145850_b, this.field_174879_c, this.oldFreq, freq);
                this.oldFreq = freq;
                if (this.firstTick) {
                    this.firstTick = false;
                }
            }
            this.onUpdateEntity();
        }
        for (ITileEntityRedstoneWirelessOverride override : overrides) {
            override.afterUpdateEntity(this);
        }
    }

    protected abstract void onUpdateEntity();

    public ItemStack func_70298_a(int i, int j) {
        ItemStack itemstack = null;
        for (ITileEntityRedstoneWirelessOverride override : overrides) {
            if (!override.handleInventory()) continue;
            itemstack = override.decrStackSize(this, i, j, itemstack);
        }
        return itemstack;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.setRedstoneWirelessSlotContents(i, itemstack);
    }

    protected void setRedstoneWirelessSlotContents(int slot, ItemStack itemstack) {
        boolean prematureExit = false;
        for (ITileEntityRedstoneWirelessOverride override : overrides) {
            if (!override.handleInventory() || !override.setInventorySlotContents(this, slot, itemstack)) continue;
            prematureExit = true;
        }
    }

    public abstract String func_70005_c_();

    public boolean isPoweringDirection(EnumFacing side) {
        return side.func_176745_a() < 6 && this.powerRoute[side.func_176745_a()];
    }

    public void flipPowerDirection(EnumFacing side) {
        if (this.isPoweringIndirectly(side) && this.powerRoute[side.func_176745_a()]) {
            this.flipIndirectPower(side);
        }
        this.powerRoute[side.func_176745_a()] = !this.powerRoute[side.func_176745_a()];
        this.func_70296_d();
        this.notifyNeighbors();
    }

    public void flushPowerRoute() {
        this.powerRoute = new boolean[6];
        for (int i = 0; i < this.powerRoute.length; ++i) {
            this.powerRoute[i] = true;
        }
    }

    public boolean[] getPowerDirections() {
        return this.powerRoute;
    }

    public boolean[] getInDirectlyPowering() {
        return this.indirPower;
    }

    public void setPowerDirections(boolean[] dir) {
        try {
            this.powerRoute = dir;
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance("TileEntityRedstoneWireless").writeStackTrace(e);
        }
    }

    public void setInDirectlyPowering(boolean[] indir) {
        try {
            this.indirPower = indir;
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance("TileEntityRedstoneWireless").writeStackTrace(e);
        }
    }

    public void flipIndirectPower(EnumFacing side) {
        if (!this.isPoweringDirection(side) && !this.indirPower[side.func_176745_a()]) {
            this.flipPowerDirection(side);
        }
        this.indirPower[side.func_176745_a()] = !this.indirPower[side.func_176745_a()];
        this.func_70296_d();
        this.notifyNeighbors();
    }

    public boolean isPoweringIndirectly(EnumFacing side) {
        return side.func_176745_a() < 6 && this.indirPower[side.func_176745_a()];
    }

    public void flushIndirPower() {
        this.indirPower = new boolean[6];
        for (int i = 0; i < this.indirPower.length; ++i) {
            this.indirPower[i] = true;
        }
    }

    private void notifyNeighbors() {
        BlockRedstoneWireless.notifyNeighbors(this.field_145850_b, this.field_174879_c, this.func_145838_q());
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        try {
            super.func_145839_a(nbttagcompound);
            NBTTagList nbttaglist3 = nbttagcompound.func_150295_c("Frequency", 10);
            NBTTagCompound nbttagcompound3 = nbttaglist3.func_150305_b(0);
            this.currentFreq = nbttagcompound3.func_74779_i("freq");
            NBTTagList nbttaglist1 = nbttagcompound.func_150295_c("PowerRoute", 10);
            if (nbttaglist1.func_74745_c() == 6) {
                for (int i = 0; i < nbttaglist1.func_74745_c(); ++i) {
                    NBTTagCompound nbttagcompound1 = nbttaglist1.func_150305_b(i);
                    this.powerRoute[i] = nbttagcompound1.func_74767_n("b");
                }
            } else {
                this.flushPowerRoute();
                this.func_145841_b(nbttagcompound);
            }
            NBTTagList nbttaglist4 = nbttagcompound.func_150295_c("IndirPower", 10);
            if (nbttaglist4.func_74745_c() == 6) {
                for (int i = 0; i < nbttaglist4.func_74745_c(); ++i) {
                    NBTTagCompound nbttagcompound1 = nbttaglist4.func_150305_b(i);
                    this.indirPower[i] = nbttagcompound1.func_74767_n("b");
                }
            } else {
                this.flushIndirPower();
                this.func_145841_b(nbttagcompound);
            }
            for (ITileEntityRedstoneWirelessOverride override : overrides) {
                if (!override.handlesExtraNBTTags()) continue;
                override.readFromNBT(this, nbttagcompound);
            }
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance("TileEntityRedstoneWireless").writeStackTrace(e);
        }
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        try {
            super.func_145841_b(nbttagcompound);
            NBTTagList nbttaglist3 = new NBTTagList();
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74778_a("freq", this.currentFreq.toString());
            nbttaglist3.func_74742_a((NBTBase)nbttagcompound1);
            nbttagcompound.func_74782_a("Frequency", (NBTBase)nbttaglist3);
            NBTTagList nbttaglist2 = new NBTTagList();
            for (boolean route : this.powerRoute) {
                NBTTagCompound nbttagcompound2 = new NBTTagCompound();
                nbttagcompound2.func_74757_a("b", route);
                nbttaglist2.func_74742_a((NBTBase)nbttagcompound2);
            }
            nbttagcompound.func_74782_a("PowerRoute", (NBTBase)nbttaglist2);
            NBTTagList nbttaglist4 = new NBTTagList();
            for (boolean power : this.indirPower) {
                NBTTagCompound nbttagcompound2 = new NBTTagCompound();
                nbttagcompound2.func_74757_a("b", power);
                nbttaglist4.func_74742_a((NBTBase)nbttagcompound2);
            }
            nbttagcompound.func_74782_a("IndirPower", (NBTBase)nbttaglist4);
            Object object = overrides.iterator();
            while (object.hasNext()) {
                ITileEntityRedstoneWirelessOverride override = (ITileEntityRedstoneWirelessOverride)object.next();
                if (!override.handlesExtraNBTTags()) continue;
                override.writeToNBT(this, nbttagcompound);
            }
        }
        catch (Exception e) {
            LoggerRedstoneWireless.getInstance("TileEntityRedstoneWireless").writeStackTrace(e);
        }
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).write(this.field_145850_b.field_72995_K, "isUseableByPlayer(" + entityplayer.func_145748_c_() + ")", LoggerRedstoneWireless.LogLevel.DEBUG);
        boolean prematureExit = false;
        for (ITileEntityRedstoneWirelessOverride override : overrides) {
            if (!override.beforeIsUseableByPlayer(this, entityplayer)) continue;
            prematureExit = true;
        }
        boolean returnState = false;
        if (!prematureExit) {
            try {
                returnState = this.isTileRedstoneWirelessUseable(entityplayer);
            }
            catch (Exception e) {
                LoggerRedstoneWireless.getInstance(LoggerRedstoneWireless.filterClassName(((Object)((Object)this)).getClass().toString())).writeStackTrace(e);
                return false;
            }
        }
        boolean output = returnState;
        for (ITileEntityRedstoneWirelessOverride override : overrides) {
            output = override.afterIsUseableByPlayer(this, entityplayer, output);
        }
        return output;
    }

    private boolean isTileRedstoneWirelessUseable(EntityPlayer entityplayer) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && entityplayer.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer entityplayer) {
    }

    public void func_174886_c(EntityPlayer entityplayer) {
    }

    public ItemStack func_70304_b(int i) {
        ItemStack itemstack = null;
        for (ITileEntityRedstoneWirelessOverride override : overrides) {
            if (!override.handleInventory()) continue;
            itemstack = override.getStackInSlotOnClosing(this, i, itemstack);
        }
        return itemstack;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.func_70296_d();
        this.func_145831_w().func_175689_h(this.field_174879_c);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_174879_c, 0, nbttagcompound);
    }

    public void handleData(IWirelessData data) {
        boolean prematureExit = false;
        for (ITileEntityRedstoneWirelessOverride override : overrides) {
            if (!override.beforeHandleData(this, data)) continue;
            prematureExit = true;
        }
    }

    public boolean func_145818_k_() {
        return false;
    }

    protected boolean isRedstoneWirelessStackValidForSlot(int slot, ItemStack itemstack) {
        boolean result = false;
        for (ITileEntityRedstoneWirelessOverride override : overrides) {
            if (!override.handleInventory()) continue;
            result = override.isStackValidForSlot(this, slot, itemstack, result);
        }
        return false;
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return this.isRedstoneWirelessStackValidForSlot(slot, itemstack);
    }

    public void onBlockRemoval(Block block, int metadata) {
        for (ITileEntityRedstoneWirelessOverride override : overrides) {
            override.onBlockRemoval(this, block, metadata);
        }
    }

    public void setAdditionalData(String dataID, IRedstoneWirelessData data) {
        this.tileData.put(dataID, data);
    }

    public IRedstoneWirelessData getAdditionalData(String dataID) {
        if (this.tileData.containsKey(dataID)) {
            return this.tileData.get(dataID);
        }
        return null;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return !oldState.func_177230_c().func_149667_c(oldState.func_177230_c());
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public IChatComponent func_145748_c_() {
        return this.func_145818_k_() ? new ChatComponentText(this.func_70005_c_()) : new ChatComponentTranslation(this.func_70005_c_(), new Object[0]);
    }
}

