/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.server.component.traits;

import li.cil.oc.Settings$;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.server.component.package$;
import li.cil.oc.server.component.traits.TankInventoryControl;
import li.cil.oc.util.ExtendedArguments$;
import li.cil.oc.util.InventoryUtils$;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidTank;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Unit$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class TankInventoryControl$class {
    @Callback(doc="function([slot:number]):number -- Get the amount of fluid in the tank item in the specified slot or the selected slot.")
    public static Object[] getTankLevelInSlot(TankInventoryControl $this, Context context, Arguments args) {
        return TankInventoryControl$class.withFluidInfo($this, $this.optSlot(args, 0), (Function2)new Serializable($this){

            public final Object[] apply(FluidStack fluid, int x$1) {
                return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)fluid.amount)}));
            }
        });
    }

    @Callback(doc="function([slot:number]):number -- Get the capacity of the tank item in the specified slot of the robot or the selected slot.")
    public static Object[] getTankCapacityInSlot(TankInventoryControl $this, Context context, Arguments args) {
        return TankInventoryControl$class.withFluidInfo($this, $this.optSlot(args, 0), (Function2)new Serializable($this){

            public final Object[] apply(FluidStack x$2, int capacity) {
                return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)capacity)}));
            }
        });
    }

    @Callback(doc="function([slot:number]):table -- Get a description of the fluid in the tank item in the specified slot or the selected slot.")
    public static Object[] getFluidInTankInSlot(TankInventoryControl $this, Context context, Arguments args) {
        return Settings$.MODULE$.get().allowItemStackInspection() ? TankInventoryControl$class.withFluidInfo($this, $this.optSlot(args, 0), (Function2)new Serializable($this){

            public final Object[] apply(FluidStack fluid, int x$3) {
                return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fluid}));
            }
        }) : package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "not enabled in config"}));
    }

    @Callback(doc="function([tank:number]):table -- Get a description of the fluid in the tank in the specified slot or the selected slot.")
    public static Object[] getFluidInInternalTank(TankInventoryControl $this, Context context, Arguments args) {
        return Settings$.MODULE$.get().allowItemStackInspection() ? package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Option$.MODULE$.apply((Object)$this.tank().getFluidTank($this.optTank(args, 0))).map((Function1)new Serializable($this){

            public final FluidStack apply(IFluidTank x$4) {
                return x$4.getFluid();
            }
        }).orNull(Predef$.MODULE$.$conforms())})) : package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "not enabled in config"}));
    }

    @Callback(doc="function([amount:number]):boolean -- Transfers fluid from a tank in the selected inventory slot to the selected tank.")
    public static Object[] drain(TankInventoryControl $this, Context context, Arguments args) {
        Object[] objectArray;
        int amount = ExtendedArguments$.MODULE$.extendedArguments(args).optionalFluidCount(0);
        Option option = Option$.MODULE$.apply((Object)$this.tank().getFluidTank($this.selectedTank()));
        if (option instanceof Some) {
            Object[] objectArray2;
            Some some = (Some)option;
            IFluidTank into = (IFluidTank)some.x();
            ItemStack itemStack = $this.inventory().func_70301_a($this.selectedSlot());
            if (itemStack != null) {
                Object[] objectArray3;
                ItemStack itemStack2 = itemStack;
                if (FluidContainerRegistry.isFilledContainer((ItemStack)itemStack2)) {
                    FluidStack contents = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack2);
                    ItemStack container = itemStack2.func_77973_b().getContainerItem(itemStack2);
                    if (into.getCapacity() - into.getFluidAmount() < contents.amount) {
                        objectArray3 = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "tank is full"}));
                    } else if (into.fill(contents, false) < contents.amount) {
                        objectArray3 = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "incompatible fluid"}));
                    } else {
                        into.fill(contents, true);
                        $this.inventory().func_70298_a($this.selectedSlot(), 1);
                        ItemStack x$5 = container;
                        IInventory x$6 = $this.inventory();
                        Option x$7 = Option$.MODULE$.apply($this.insertionSlots());
                        Option<ForgeDirection> x$8 = InventoryUtils$.MODULE$.insertIntoInventory$default$3();
                        int x$9 = InventoryUtils$.MODULE$.insertIntoInventory$default$4();
                        boolean x$10 = InventoryUtils$.MODULE$.insertIntoInventory$default$5();
                        InventoryUtils$.MODULE$.insertIntoInventory(x$5, x$6, x$8, x$9, x$10, (Option<Iterable<Object>>)x$7);
                        Object object = container.field_77994_a > 0 ? InventoryUtils$.MODULE$.spawnStackInWorld($this.position(), container, InventoryUtils$.MODULE$.spawnStackInWorld$default$3()) : BoxedUnit.UNIT;
                        objectArray3 = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToInteger((int)contents.amount)}));
                    }
                } else {
                    Object[] objectArray4;
                    Item item = itemStack2.func_77973_b();
                    if (item instanceof IFluidContainerItem) {
                        Object[] objectArray5;
                        Item item2 = item;
                        FluidStack drained = ((IFluidContainerItem)item2).drain(itemStack2, amount, false);
                        int transferred = into.fill(drained, true);
                        if (transferred > 0) {
                            ((IFluidContainerItem)item2).drain(itemStack2, transferred, true);
                            objectArray5 = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToInteger((int)transferred)}));
                        } else {
                            objectArray5 = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "incompatible or no fluid"}));
                        }
                        objectArray4 = objectArray5;
                    } else {
                        objectArray4 = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "item is empty or not a fluid container"}));
                    }
                    objectArray3 = objectArray4;
                }
                objectArray2 = objectArray3;
            } else {
                objectArray2 = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "nothing selected"}));
            }
            objectArray = objectArray2;
        } else {
            objectArray = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "no tank"}));
        }
        return objectArray;
    }

    @Callback(doc="function([amount:number]):boolean -- Transfers fluid from the selected tank to a tank in the selected inventory slot.")
    public static Object[] fill(TankInventoryControl $this, Context context, Arguments args) {
        Object[] objectArray;
        int amount = ExtendedArguments$.MODULE$.extendedArguments(args).optionalFluidCount(0);
        Option option = Option$.MODULE$.apply((Object)$this.tank().getFluidTank($this.selectedTank()));
        if (option instanceof Some) {
            Object[] objectArray2;
            Some some = (Some)option;
            IFluidTank from = (IFluidTank)some.x();
            ItemStack itemStack = $this.inventory().func_70301_a($this.selectedSlot());
            if (itemStack != null) {
                Object[] objectArray3;
                ItemStack itemStack2 = itemStack;
                if (FluidContainerRegistry.isEmptyContainer((ItemStack)itemStack2)) {
                    FluidStack drained = from.drain(amount, false);
                    ItemStack filled = FluidContainerRegistry.fillFluidContainer((FluidStack)drained, (ItemStack)itemStack2);
                    if (filled == null) {
                        objectArray3 = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "tank is empty"}));
                    } else {
                        int amount2 = FluidContainerRegistry.getFluidForFilledItem((ItemStack)filled).amount;
                        from.drain(amount2, true);
                        $this.inventory().func_70298_a($this.selectedSlot(), 1);
                        ItemStack x$11 = filled;
                        IInventory x$12 = $this.inventory();
                        Option x$13 = Option$.MODULE$.apply($this.insertionSlots());
                        Option<ForgeDirection> x$14 = InventoryUtils$.MODULE$.insertIntoInventory$default$3();
                        int x$15 = InventoryUtils$.MODULE$.insertIntoInventory$default$4();
                        boolean x$16 = InventoryUtils$.MODULE$.insertIntoInventory$default$5();
                        InventoryUtils$.MODULE$.insertIntoInventory(x$11, x$12, x$14, x$15, x$16, (Option<Iterable<Object>>)x$13);
                        Object object = filled.field_77994_a > 0 ? InventoryUtils$.MODULE$.spawnStackInWorld($this.position(), filled, InventoryUtils$.MODULE$.spawnStackInWorld$default$3()) : BoxedUnit.UNIT;
                        objectArray3 = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToInteger((int)amount2)}));
                    }
                } else {
                    Object[] objectArray4;
                    Item item = itemStack2.func_77973_b();
                    if (item instanceof IFluidContainerItem) {
                        Object[] objectArray5;
                        Item item2 = item;
                        FluidStack drained = from.drain(amount, false);
                        int transferred = ((IFluidContainerItem)item2).fill(itemStack2, drained, true);
                        if (transferred > 0) {
                            from.drain(transferred, true);
                            objectArray5 = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToInteger((int)transferred)}));
                        } else {
                            objectArray5 = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "incompatible or no fluid"}));
                        }
                        objectArray4 = objectArray5;
                    } else {
                        objectArray4 = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "item is full or not a fluid container"}));
                    }
                    objectArray3 = objectArray4;
                }
                objectArray2 = objectArray3;
            } else {
                objectArray2 = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "nothing selected"}));
            }
            objectArray = objectArray2;
        } else {
            objectArray = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "no tank"}));
        }
        return objectArray;
    }

    private static Object[] withFluidInfo(TankInventoryControl $this, int slot, Function2 f) {
        ItemStack itemStack = $this.inventory().func_70301_a(slot);
        if (itemStack != null) {
            Object[] objectArray;
            Some some;
            Tuple2 tuple2;
            ItemStack itemStack2 = itemStack;
            Option option = TankInventoryControl$class.fluidInfo$1($this, itemStack2);
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).x()) != null) {
                FluidStack fluid = (FluidStack)tuple2._1();
                int capacity = tuple2._2$mcI$sp();
                objectArray = (Object[])f.apply((Object)fluid, (Object)BoxesRunTime.boxToInteger((int)capacity));
            } else {
                objectArray = package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Unit$.MODULE$, "item is not a fluid container"}));
            }
            Object[] objectArray2 = objectArray;
            return objectArray2;
        }
        throw new MatchError((Object)itemStack);
    }

    private static final Option fluidInfo$1(TankInventoryControl $this, ItemStack stack) {
        Option option;
        if (FluidContainerRegistry.isFilledContainer((ItemStack)stack)) {
            option = Option$.MODULE$.apply((Object)new Tuple2((Object)FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack), (Object)BoxesRunTime.boxToInteger((int)FluidContainerRegistry.getContainerCapacity((ItemStack)stack))));
        } else if (FluidContainerRegistry.isEmptyContainer((ItemStack)stack)) {
            option = Option$.MODULE$.apply((Object)new Tuple2((Object)new FluidStack(0, 0), (Object)BoxesRunTime.boxToInteger((int)FluidContainerRegistry.getContainerCapacity((ItemStack)stack))));
        } else {
            None$ none$;
            Item item = stack.func_77973_b();
            if (item instanceof IFluidContainerItem) {
                Item item2 = item;
                none$ = Option$.MODULE$.apply((Object)new Tuple2((Object)((IFluidContainerItem)item2).getFluid(stack), (Object)BoxesRunTime.boxToInteger((int)((IFluidContainerItem)item2).getCapacity(stack))));
            } else {
                none$ = None$.MODULE$;
            }
            option = none$;
        }
        return option;
    }

    public static void $init$(TankInventoryControl $this) {
    }
}

