/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.server.fs;

import java.io.File;
import java.net.URL;
import java.util.UUID;
import li.cil.oc.OpenComputers$;
import li.cil.oc.Settings$;
import li.cil.oc.api.detail.FileSystemAPI;
import li.cil.oc.api.driver.EnvironmentHost;
import li.cil.oc.api.fs.FileSystem;
import li.cil.oc.api.fs.Label;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.integration.Mods$;
import li.cil.oc.integration.computercraft.DriverComputerCraftMedia$;
import li.cil.oc.server.fs.FileSystem;
import li.cil.oc.server.fs.FileSystem$;
import li.cil.oc.server.fs.InputStreamFileSystem;
import li.cil.oc.server.fs.ZipFileInputStreamFileSystem$;
import net.minecraftforge.common.DimensionManager;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class FileSystem$
implements FileSystemAPI {
    public static final FileSystem$ MODULE$;
    private boolean isCaseInsensitive;
    private volatile boolean bitmap$0;

    static {
        new FileSystem$();
    }

    private boolean isCaseInsensitive$lzycompute() {
        FileSystem$ fileSystem$ = this;
        synchronized (fileSystem$) {
            if (!this.bitmap$0) {
                this.isCaseInsensitive = Settings$.MODULE$.get().forceCaseInsensitive() || this.liftedTree1$1();
                this.bitmap$0 = true;
            }
            return this.isCaseInsensitive;
        }
    }

    public boolean isCaseInsensitive() {
        return this.bitmap$0 ? this.isCaseInsensitive : this.isCaseInsensitive$lzycompute();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public FileSystem fromClass(Class<?> clazz, String domain, String root) {
        InputStreamFileSystem inputStreamFileSystem;
        File file;
        File file2;
        Tuple2 tuple23;
        String innerPath = new StringBuilder().append((Object)"/assets/").append((Object)domain).append((Object)"/").append((Object)new StringBuilder().append((Object)root.trim()).append((Object)"/").toString()).toString().replace("//", "/");
        String codeSource = clazz.getProtectionDomain().getCodeSource().getLocation().getPath();
        Tuple2 tuple2 = codeSource.contains(".zip!") || codeSource.contains(".jar!") ? new Tuple2((Object)codeSource.substring(0, codeSource.lastIndexOf(33)), (Object)BoxesRunTime.boxToBoolean((boolean)true)) : new Tuple2((Object)codeSource, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String codeUrl = (String)tuple2._1();
        boolean isArchive2 = tuple2._2$mcZ$sp();
        Tuple2 tuple24 = tuple23 = new Tuple2((Object)codeUrl, (Object)BoxesRunTime.boxToBoolean((boolean)isArchive2));
        String codeUrl2 = (String)tuple24._1();
        boolean isArchive = tuple24._2$mcZ$sp();
        URL url = new URL(codeUrl2);
        try {
            file2 = new File(url.toURI());
        }
        catch (Throwable throwable) {
            try {
                file2 = new File(url.getPath());
            }
            catch (Throwable throwable2) {
                file2 = file = new File(codeSource);
            }
        }
        if (isArchive) {
            inputStreamFileSystem = ZipFileInputStreamFileSystem$.MODULE$.fromFile(file, innerPath.substring(1));
            return inputStreamFileSystem;
        } else {
            FileSystem.ReadOnlyFileSystem readOnlyFileSystem;
            if (!file.exists()) return null;
            if (file.isDirectory()) return null;
            File file3 = new File(new File(file.getParent()), innerPath);
            if (file3.exists() && file3.isDirectory()) {
                readOnlyFileSystem = new FileSystem.ReadOnlyFileSystem(file3);
            } else {
                Option option = Predef$.MODULE$.refArrayOps((Object[])System.getProperty("java.class.path").split(System.getProperty("path.separator"))).find((Function1)new anonfun.1(innerPath));
                if (None$.MODULE$.equals(option)) {
                    return null;
                }
                if (!(option instanceof Some)) throw new MatchError((Object)option);
                Some some = (Some)option;
                String dir = (String)some.x();
                FileSystem.ReadOnlyFileSystem readOnlyFileSystem2 = new FileSystem.ReadOnlyFileSystem(new File(new File(dir), innerPath));
                readOnlyFileSystem = readOnlyFileSystem2;
            }
            inputStreamFileSystem = readOnlyFileSystem;
        }
        return inputStreamFileSystem;
    }

    @Override
    public FileSystem fromSaveDirectory(String root, long capacity, boolean buffered) {
        File path = new File(DimensionManager.getCurrentSaveRootDirectory(), new StringBuilder().append((Object)Settings$.MODULE$.savePath()).append((Object)root).toString());
        Object object = path.isDirectory() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)path.delete());
        path.mkdirs();
        return path.exists() && path.isDirectory() ? (buffered ? new FileSystem.BufferedFileSystem(path, capacity) : new FileSystem.ReadWriteFileSystem(path, capacity)) : null;
    }

    @Override
    public FileSystem fromMemory(long capacity) {
        return new FileSystem.RamFileSystem(capacity);
    }

    @Override
    public FileSystem fromComputerCraft(Object mount) {
        return Mods$.MODULE$.ComputerCraft().isAvailable() ? (FileSystem)DriverComputerCraftMedia$.MODULE$.createFileSystem(mount).orNull(Predef$.MODULE$.$conforms()) : null;
    }

    @Override
    public ManagedEnvironment asManagedEnvironment(FileSystem fileSystem, Label label, EnvironmentHost host, String sound) {
        return (ManagedEnvironment)Option$.MODULE$.apply((Object)fileSystem).flatMap((Function1)new Serializable(label, host, sound){
            private final Label label$1;
            private final EnvironmentHost host$1;
            private final String sound$1;

            public final Some<li.cil.oc.server.component.FileSystem> apply(FileSystem fs) {
                return new Some((Object)new li.cil.oc.server.component.FileSystem(fs, this.label$1, (Option<EnvironmentHost>)Option$.MODULE$.apply((Object)this.host$1), (Option<String>)Option$.MODULE$.apply((Object)this.sound$1)));
            }
            {
                this.label$1 = label$1;
                this.host$1 = host$1;
                this.sound$1 = sound$1;
            }
        }).orNull(Predef$.MODULE$.$conforms());
    }

    @Override
    public ManagedEnvironment asManagedEnvironment(FileSystem fileSystem, String label, EnvironmentHost host, String sound) {
        return this.asManagedEnvironment(fileSystem, new FileSystem.ReadOnlyLabel(label), host, sound);
    }

    @Override
    public ManagedEnvironment asManagedEnvironment(FileSystem fileSystem, Label label) {
        return (ManagedEnvironment)Option$.MODULE$.apply((Object)fileSystem).flatMap((Function1)new Serializable(label){
            private final Label label$2;

            public final Some<li.cil.oc.server.component.FileSystem> apply(FileSystem fs) {
                return new Some((Object)new li.cil.oc.server.component.FileSystem(fs, this.label$2, li.cil.oc.server.component.FileSystem$.MODULE$.$lessinit$greater$default$3(), li.cil.oc.server.component.FileSystem$.MODULE$.$lessinit$greater$default$4()));
            }
            {
                this.label$2 = label$2;
            }
        }).orNull(Predef$.MODULE$.$conforms());
    }

    @Override
    public ManagedEnvironment asManagedEnvironment(FileSystem fileSystem, String label) {
        return this.asManagedEnvironment(fileSystem, new FileSystem.ReadOnlyLabel(label));
    }

    @Override
    public ManagedEnvironment asManagedEnvironment(FileSystem fileSystem) {
        return this.asManagedEnvironment(fileSystem, (Label)null);
    }

    private final boolean liftedTree1$1() {
        boolean bl;
        try {
            String uuid = UUID.randomUUID().toString();
            File lowerCase = new File(DimensionManager.getCurrentSaveRootDirectory(), new StringBuilder().append((Object)uuid).append((Object)"oc_rox").toString());
            File upperCase = new File(DimensionManager.getCurrentSaveRootDirectory(), new StringBuilder().append((Object)uuid).append((Object)"OC_ROX").toString());
            boolean bl2 = lowerCase.exists() && lowerCase.delete();
            boolean bl3 = upperCase.exists() && upperCase.delete();
            lowerCase.createNewFile();
            boolean insensitive = upperCase.exists();
            lowerCase.delete();
            bl = insensitive;
        }
        catch (Throwable throwable) {
            OpenComputers$.MODULE$.log().warn("Couldn't determine if file system is case sensitive, falling back to insensitive.", throwable);
            bl = true;
        }
        return bl;
    }

    private FileSystem$() {
        MODULE$ = this;
    }
}

