/*
 * Decompiled with CFR 0.152.
 */
package com.grack.nanojson;

import com.grack.nanojson.JsonArray;
import com.grack.nanojson.JsonLazyNumber;
import com.grack.nanojson.JsonObject;
import com.grack.nanojson.JsonParserException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;

public final class JsonParser {
    private static final int BUFFER_ROOM = 20;
    static final int BUFFER_SIZE = 32768;
    private int linePos = 1;
    private int rowPos;
    private int charOffset;
    private int utf8adjust;
    private int tokenLinePos;
    private int tokenCharPos;
    private int tokenCharOffset;
    private Object value;
    private Token token;
    private StringBuilder reusableBuffer = new StringBuilder();
    private boolean eof;
    private int index;
    private final Reader reader;
    private final char[] buffer;
    private int bufferLength;
    private static final char[] TRUE = new char[]{'r', 'u', 'e'};
    private static final char[] FALSE = new char[]{'a', 'l', 's', 'e'};
    private static final char[] NULL = new char[]{'u', 'l', 'l'};
    private final boolean utf8;
    private boolean lazyNumbers;

    JsonParser(boolean utf8, boolean lazyNumbers, Reader reader) throws JsonParserException {
        this.utf8 = utf8;
        this.lazyNumbers = lazyNumbers;
        this.reader = reader;
        this.buffer = new char[32768];
        this.eof = this.refillBuffer();
    }

    public static JsonParserContext<JsonObject> object() {
        return new JsonParserContext<JsonObject>(JsonObject.class);
    }

    public static JsonParserContext<JsonArray> array() {
        return new JsonParserContext<JsonArray>(JsonArray.class);
    }

    public static JsonParserContext<Object> any() {
        return new JsonParserContext<Object>(Object.class);
    }

    <T> T parse(Class<T> clazz) throws JsonParserException {
        this.advanceToken();
        Object parsed = this.currentValue();
        if (this.advanceToken() != Token.EOF) {
            throw this.createParseException(null, "Expected end of input, got " + (Object)((Object)this.token), true);
        }
        if (!(clazz == Object.class || parsed != null && clazz.isAssignableFrom(parsed.getClass()))) {
            throw this.createParseException(null, "JSON did not contain the correct type, expected " + clazz.getSimpleName() + ".", true);
        }
        return clazz.cast(parsed);
    }

    private Object currentValue() throws JsonParserException {
        if (this.token.isValue) {
            return this.value;
        }
        throw this.createParseException(null, "Expected JSON value, got " + (Object)((Object)this.token), true);
    }

    /*
     * Unable to fully structure code
     */
    private Token advanceToken() throws JsonParserException {
        c = this.advanceChar();
        while (this.isWhitespace(c)) {
            c = this.advanceChar();
        }
        this.tokenLinePos = this.linePos;
        this.tokenCharPos = this.index + this.charOffset - this.rowPos - this.utf8adjust;
        this.tokenCharOffset = this.charOffset + this.index;
        switch (c) {
            case -1: {
                this.token = Token.EOF;
                return this.token;
            }
            case 91: {
                list = new JsonArray();
                if (this.advanceToken() == Token.ARRAY_END) ** GOTO lbl23
                do {
                    list.add(this.currentValue());
                    if (this.advanceToken() == Token.ARRAY_END) ** GOTO lbl23
                    if (this.token == Token.COMMA) continue;
                    throw this.createParseException(null, "Expected a comma or end of the array instead of " + (Object)this.token, true);
                } while (this.advanceToken() != Token.ARRAY_END);
                throw this.createParseException(null, "Trailing comma found in array", true);
lbl23:
                // 2 sources

                this.value = list;
                this.token = Token.ARRAY_START;
                return this.token;
            }
            case 93: {
                this.token = Token.ARRAY_END;
                return this.token;
            }
            case 44: {
                this.token = Token.COMMA;
                return this.token;
            }
            case 58: {
                this.token = Token.COLON;
                return this.token;
            }
            case 123: {
                map = new JsonObject();
                if (this.advanceToken() == Token.OBJECT_END) ** GOTO lbl53
                do {
                    if (this.token != Token.STRING) {
                        throw this.createParseException(null, "Expected STRING, got " + (Object)this.token, true);
                    }
                    key = (String)this.value;
                    if (this.advanceToken() != Token.COLON) {
                        throw this.createParseException(null, "Expected COLON, got " + (Object)this.token, true);
                    }
                    this.advanceToken();
                    map.put(key, this.currentValue());
                    if (this.advanceToken() == Token.OBJECT_END) ** GOTO lbl53
                    if (this.token == Token.COMMA) continue;
                    throw this.createParseException(null, "Expected a comma or end of the object instead of " + (Object)this.token, true);
                } while (this.advanceToken() != Token.OBJECT_END);
                throw this.createParseException(null, "Trailing object found in array", true);
lbl53:
                // 2 sources

                this.value = map;
                this.token = Token.OBJECT_START;
                return this.token;
            }
            case 125: {
                this.token = Token.OBJECT_END;
                return this.token;
            }
            case 116: {
                this.consumeKeyword((char)c, JsonParser.TRUE);
                this.value = Boolean.TRUE;
                this.token = Token.TRUE;
                return this.token;
            }
            case 102: {
                this.consumeKeyword((char)c, JsonParser.FALSE);
                this.value = Boolean.FALSE;
                this.token = Token.FALSE;
                return this.token;
            }
            case 110: {
                this.consumeKeyword((char)c, JsonParser.NULL);
                this.value = null;
                this.token = Token.NULL;
                return this.token;
            }
            case 34: {
                this.value = this.consumeTokenString();
                this.token = Token.STRING;
                return this.token;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.value = this.consumeTokenNumber((char)c);
                this.token = Token.NUMBER;
                return this.token;
            }
            case 43: 
            case 46: {
                throw this.createParseException(null, "Numbers may not start with '" + (char)c + "'", true);
            }
        }
        if (this.isAsciiLetter(c)) {
            throw this.createHelpfulException((char)c, null, 0);
        }
        throw this.createParseException(null, "Unexpected character: " + (char)c, true);
    }

    private void consumeKeyword(char first, char[] expected) throws JsonParserException {
        if (this.ensureBuffer(expected.length) < expected.length) {
            throw this.createHelpfulException(first, expected, 0);
        }
        for (int i = 0; i < expected.length; ++i) {
            if (this.buffer[this.index++] == expected[i]) continue;
            throw this.createHelpfulException(first, expected, i);
        }
        this.fixupAfterRawBufferRead();
        if (this.isAsciiLetter(this.peekChar())) {
            throw this.createHelpfulException(first, expected, expected.length);
        }
    }

    private Number consumeTokenNumber(char c) throws JsonParserException {
        int n;
        this.reusableBuffer.setLength(0);
        this.reusableBuffer.append(c);
        boolean isDouble = false;
        block2: while ((n = this.ensureBuffer(20)) != 0) {
            for (int i = 0; i < n; ++i) {
                char next = this.buffer[this.index];
                if (!this.isDigitCharacter(next)) break block2;
                isDouble |= next == '.' || next == 'e' || next == 'E';
                this.reusableBuffer.append(next);
                ++this.index;
            }
        }
        this.fixupAfterRawBufferRead();
        String number = this.reusableBuffer.toString();
        try {
            int length;
            if (isDouble) {
                if (number.charAt(0) == '0' && (number.charAt(1) == '.' ? number.length() == 2 : number.charAt(1) != 'e' && number.charAt(1) != 'E')) {
                    throw this.createParseException(null, "Malformed number: " + number, true);
                }
                if (number.charAt(0) == '-' && (number.charAt(1) == '0' ? (number.charAt(2) == '.' ? number.length() == 3 : number.charAt(2) != 'e' && number.charAt(2) != 'E') : number.charAt(1) == '.')) {
                    throw this.createParseException(null, "Malformed number: " + number, true);
                }
                return this.lazyNumbers ? new JsonLazyNumber(number) : Double.valueOf(Double.parseDouble(number));
            }
            if (number.charAt(0) == '0') {
                if (number.length() == 1) {
                    return 0;
                }
                throw this.createParseException(null, "Malformed number: " + number, true);
            }
            if (number.length() > 1 && number.charAt(0) == '-' && number.charAt(1) == '0') {
                if (number.length() == 2) {
                    return -0.0;
                }
                throw this.createParseException(null, "Malformed number: " + number, true);
            }
            if (this.lazyNumbers) {
                return new JsonLazyNumber(number);
            }
            boolean firstMinus = number.charAt(0) == '-';
            int n2 = length = firstMinus ? number.length() - 1 : number.length();
            if (length < 10 || length == 10 && number.charAt(firstMinus ? 1 : 0) < '2') {
                return Integer.parseInt(number);
            }
            if (length < 19 || length == 19 && number.charAt(firstMinus ? 1 : 0) < '9') {
                return Long.parseLong(number);
            }
            return new BigInteger(number);
        }
        catch (NumberFormatException e) {
            throw this.createParseException(e, "Malformed number: " + number, true);
        }
    }

    private String consumeTokenString() throws JsonParserException {
        this.reusableBuffer.setLength(0);
        while (true) {
            if (this.ensureBuffer(20) == 0) {
                throw this.createParseException(null, "String was not terminated before end of input", true);
            }
            char c = this.stringChar();
            if (this.utf8 && (c & 0x80) != 0) {
                this.consumeTokenStringUtf8Char(c);
                continue;
            }
            block0 : switch (c) {
                case '\"': {
                    this.fixupAfterRawBufferRead();
                    return this.reusableBuffer.toString();
                }
                case '\\': {
                    char escape = this.buffer[this.index++];
                    switch (escape) {
                        case 'b': {
                            this.reusableBuffer.append('\b');
                            break block0;
                        }
                        case 'f': {
                            this.reusableBuffer.append('\f');
                            break block0;
                        }
                        case 'n': {
                            this.reusableBuffer.append('\n');
                            break block0;
                        }
                        case 'r': {
                            this.reusableBuffer.append('\r');
                            break block0;
                        }
                        case 't': {
                            this.reusableBuffer.append('\t');
                            break block0;
                        }
                        case '\"': 
                        case '/': 
                        case '\\': {
                            this.reusableBuffer.append(escape);
                            break block0;
                        }
                        case 'u': {
                            int escaped = 0;
                            for (int i = 0; i < 4; ++i) {
                                char digit;
                                escaped <<= 4;
                                if ((digit = this.buffer[this.index++]) >= '0' && digit <= '9') {
                                    escaped |= digit - 48;
                                    continue;
                                }
                                if (digit >= 'A' && digit <= 'F') {
                                    escaped |= digit - 65 + 10;
                                    continue;
                                }
                                if (digit >= 'a' && digit <= 'f') {
                                    escaped |= digit - 97 + 10;
                                    continue;
                                }
                                throw this.createParseException(null, "Expected unicode hex escape character: " + (char)digit + " (" + digit + ")", false);
                            }
                            this.reusableBuffer.append((char)escaped);
                            break block0;
                        }
                    }
                    throw this.createParseException(null, "Invalid escape: \\" + escape, false);
                }
                default: {
                    this.reusableBuffer.append(c);
                }
            }
            if (this.index > this.bufferLength) break;
        }
        this.index = this.bufferLength;
        throw this.createParseException(null, "EOF encountered in the middle of a string escape", false);
    }

    private void consumeTokenStringUtf8Char(char c) throws JsonParserException {
        this.ensureBuffer(5);
        block0 : switch (c & 0xF0) {
            case 128: 
            case 144: 
            case 160: 
            case 176: {
                throw this.createParseException(null, "Illegal UTF-8 continuation byte: 0x" + Integer.toHexString(c & 0xFF), false);
            }
            case 192: {
                if ((c & 0xE) == 0) {
                    throw this.createParseException(null, "Illegal UTF-8 byte: 0x" + Integer.toHexString(c & 0xFF), false);
                }
            }
            case 208: {
                c = (char)((c & 0x1F) << 6 | this.buffer[this.index++] & 0x3F);
                this.reusableBuffer.append(c);
                ++this.utf8adjust;
                break;
            }
            case 224: {
                c = (char)((c & 0xF) << 12 | (this.buffer[this.index++] & 0x3F) << 6 | this.buffer[this.index++] & 0x3F);
                this.reusableBuffer.append(c);
                this.utf8adjust += 2;
                break;
            }
            case 240: {
                if ((c & 0xF) >= 5) {
                    throw this.createParseException(null, "Illegal UTF-8 byte: 0x" + Integer.toHexString(c & 0xFF), false);
                }
                switch ((c & 0xC) >> 2) {
                    case 0: 
                    case 1: {
                        this.reusableBuffer.appendCodePoint((c & 7) << 18 | (this.buffer[this.index++] & 0x3F) << 12 | (this.buffer[this.index++] & 0x3F) << 6 | this.buffer[this.index++] & 0x3F);
                        this.utf8adjust += 3;
                        break block0;
                    }
                    case 2: {
                        int codepoint = (c & 3) << 24 | (this.buffer[this.index++] & 0x3F) << 18 | (this.buffer[this.index++] & 0x3F) << 12 | (this.buffer[this.index++] & 0x3F) << 6 | this.buffer[this.index++] & 0x3F;
                        throw this.createParseException(null, "Unable to represent codepoint 0x" + Integer.toHexString(codepoint) + " in a Java string", false);
                    }
                    case 3: {
                        int codepoint = (c & '\u0001') << 30 | (this.buffer[this.index++] & 0x3F) << 24 | (this.buffer[this.index++] & 0x3F) << 18 | (this.buffer[this.index++] & 0x3F) << 12 | (this.buffer[this.index++] & 0x3F) << 6 | this.buffer[this.index++] & 0x3F;
                        throw this.createParseException(null, "Unable to represent codepoint 0x" + Integer.toHexString(codepoint) + " in a Java string", false);
                    }
                }
                assert (false) : "Impossible";
                break;
            }
        }
        if (this.index > this.bufferLength) {
            throw this.createParseException(null, "UTF-8 codepoint was truncated", false);
        }
    }

    private char stringChar() throws JsonParserException {
        char c;
        if ((c = this.buffer[this.index++]) < ' ') {
            if (c == '\n') {
                ++this.linePos;
                this.rowPos = this.index + 1 + this.charOffset;
                this.utf8adjust = 0;
            }
            throw this.createParseException(null, "Strings may not contain control characters: 0x" + Integer.toString(c, 16), false);
        }
        return c;
    }

    private boolean isDigitCharacter(int c) {
        return c >= 48 && c <= 57 || c == 101 || c == 69 || c == 46 || c == 43 || c == 45;
    }

    private boolean isWhitespace(int c) {
        return c == 32 || c == 10 || c == 13 || c == 9;
    }

    private boolean isAsciiLetter(int c) {
        return c >= 65 && c <= 90 || c >= 97 && c <= 122;
    }

    private boolean refillBuffer() throws JsonParserException {
        try {
            int r = this.reader.read(this.buffer, 0, this.buffer.length);
            if (r <= 0) {
                return true;
            }
            this.charOffset += this.bufferLength;
            this.index = 0;
            this.bufferLength = r;
            return false;
        }
        catch (IOException e) {
            throw this.createParseException(e, "IOException", true);
        }
    }

    private int peekChar() {
        return this.eof ? -1 : this.buffer[this.index];
    }

    private int ensureBuffer(int n) throws JsonParserException {
        if (this.bufferLength - n >= this.index) {
            return n;
        }
        this.charOffset += this.index;
        this.bufferLength -= this.index;
        System.arraycopy(this.buffer, this.index, this.buffer, 0, this.bufferLength);
        this.index = 0;
        try {
            while (this.buffer.length > this.bufferLength) {
                int r = this.reader.read(this.buffer, this.bufferLength, this.buffer.length - this.bufferLength);
                if (r <= 0) {
                    return this.bufferLength - this.index;
                }
                this.bufferLength += r;
                if (this.bufferLength <= n) continue;
                return this.bufferLength - this.index;
            }
            assert (false) : "Unexpected internal error";
            throw new IOException("Unexpected internal error");
        }
        catch (IOException e) {
            throw this.createParseException(e, "IOException", true);
        }
    }

    private int advanceChar() throws JsonParserException {
        if (this.eof) {
            return -1;
        }
        char c = this.buffer[this.index];
        if (c == '\n') {
            ++this.linePos;
            this.rowPos = this.index + 1 + this.charOffset;
            this.utf8adjust = 0;
        }
        ++this.index;
        if (this.index >= this.bufferLength) {
            this.eof = this.refillBuffer();
        }
        return c;
    }

    private void fixupAfterRawBufferRead() throws JsonParserException {
        if (this.index >= this.bufferLength) {
            this.eof = this.refillBuffer();
        }
    }

    private JsonParserException createHelpfulException(char first, char[] expected, int failurePosition) throws JsonParserException {
        StringBuilder errorToken = new StringBuilder(first + (expected == null ? "" : new String(expected, 0, failurePosition)));
        while (this.isAsciiLetter(this.peekChar()) && errorToken.length() < 15) {
            errorToken.append((char)this.advanceChar());
        }
        return this.createParseException(null, "Unexpected token '" + errorToken + "'" + (expected == null ? "" : ". Did you mean '" + first + new String(expected) + "'?"), true);
    }

    private JsonParserException createParseException(Exception e, String message, boolean tokenPos) {
        if (tokenPos) {
            return new JsonParserException(e, message + " on line " + this.tokenLinePos + ", char " + this.tokenCharPos, this.tokenLinePos, this.tokenCharPos, this.tokenCharOffset);
        }
        int charPos = Math.max(1, this.index + this.charOffset - this.rowPos - this.utf8adjust);
        return new JsonParserException(e, message + " on line " + this.linePos + ", char " + charPos, this.linePos, charPos, this.index + this.charOffset);
    }

    public static final class JsonParserContext<T> {
        private final Class<T> clazz;
        private boolean lazyNumbers;

        JsonParserContext(Class<T> clazz) {
            this.clazz = clazz;
        }

        public JsonParserContext<T> withLazyNumbers() {
            this.lazyNumbers = true;
            return this;
        }

        public T from(String s) throws JsonParserException {
            return new JsonParser(false, this.lazyNumbers, new StringReader(s)).parse(this.clazz);
        }

        public T from(Reader r) throws JsonParserException {
            return new JsonParser(false, this.lazyNumbers, r).parse(this.clazz);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public T from(URL url) throws JsonParserException {
            try {
                InputStream stm = url.openStream();
                try {
                    T t = this.from(stm);
                    return t;
                }
                finally {
                    stm.close();
                }
            }
            catch (IOException e) {
                throw new JsonParserException(e, "IOException opening URL", 1, 1, 0);
            }
        }

        public T from(InputStream stm) throws JsonParserException {
            BufferedInputStream buffered = stm instanceof BufferedInputStream ? (BufferedInputStream)stm : new BufferedInputStream(stm);
            buffered.mark(4);
            try {
                Charset charset;
                int[] sig = new int[]{buffered.read(), buffered.read(), buffered.read(), buffered.read()};
                if (sig[0] == 239 && sig[1] == 187 && sig[2] == 191) {
                    buffered.reset();
                    buffered.read();
                    buffered.read();
                    buffered.read();
                    return new JsonParser(true, this.lazyNumbers, new PseudoUtf8Reader(buffered)).parse(this.clazz);
                }
                if (sig[0] == 0 && sig[1] == 0 && sig[2] == 254 && sig[3] == 255) {
                    charset = Charset.forName("UTF-32BE");
                } else if (sig[0] == 255 && sig[1] == 254 && sig[2] == 0 && sig[3] == 0) {
                    charset = Charset.forName("UTF-32LE");
                } else if (sig[0] == 254 && sig[1] == 255) {
                    charset = Charset.forName("UTF-16BE");
                    buffered.reset();
                    buffered.read();
                    buffered.read();
                } else if (sig[0] == 255 && sig[1] == 254) {
                    charset = Charset.forName("UTF-16LE");
                    buffered.reset();
                    buffered.read();
                    buffered.read();
                } else if (sig[0] == 0 && sig[1] == 0 && sig[2] == 0 && sig[3] != 0) {
                    charset = Charset.forName("UTF-32BE");
                    buffered.reset();
                } else if (sig[0] != 0 && sig[1] == 0 && sig[2] == 0 && sig[3] == 0) {
                    charset = Charset.forName("UTF-32LE");
                    buffered.reset();
                } else if (sig[0] == 0 && sig[1] != 0 && sig[2] == 0 && sig[3] != 0) {
                    charset = Charset.forName("UTF-16BE");
                    buffered.reset();
                } else if (sig[0] != 0 && sig[1] == 0 && sig[2] != 0 && sig[3] == 0) {
                    charset = Charset.forName("UTF-16LE");
                    buffered.reset();
                } else {
                    buffered.reset();
                    return new JsonParser(true, this.lazyNumbers, new PseudoUtf8Reader(buffered)).parse(this.clazz);
                }
                return new JsonParser(false, this.lazyNumbers, new InputStreamReader((InputStream)buffered, charset)).parse(this.clazz);
            }
            catch (IOException e) {
                throw new JsonParserException(e, "IOException while detecting charset", 1, 1, 0);
            }
        }
    }

    private static final class PseudoUtf8Reader
    extends Reader {
        private final BufferedInputStream buffered;
        private byte[] buf = new byte[32768];

        PseudoUtf8Reader(BufferedInputStream buffered) {
            this.buffered = buffered;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int r = this.buffered.read(this.buf, off, len);
            for (int i = off; i < off + r; ++i) {
                cbuf[i] = (char)this.buf[i];
            }
            return r;
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static enum Token {
        EOF(false),
        NULL(true),
        TRUE(true),
        FALSE(true),
        STRING(true),
        NUMBER(true),
        COMMA(false),
        COLON(false),
        OBJECT_START(true),
        OBJECT_END(false),
        ARRAY_START(true),
        ARRAY_END(false);

        public boolean isValue;

        private Token(boolean isValue) {
            this.isValue = isValue;
        }
    }
}

