/*
 * Decompiled with CFR 0.152.
 */
package com.grack.nanojson;

import com.grack.nanojson.JsonSink;
import com.grack.nanojson.JsonWriterException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.Stack;

class JsonWriterBase<SELF extends JsonWriterBase<SELF>>
implements JsonSink<SELF> {
    protected final Appendable appendable;
    private Stack<Boolean> states = new Stack();
    private boolean first = true;
    private boolean inObject;
    private String indentString;
    private int indent = 0;

    JsonWriterBase(Appendable appendable, String indent) {
        this.appendable = appendable;
        this.indentString = indent;
    }

    private SELF castThis() {
        return (SELF)this;
    }

    @Override
    public SELF array(Collection<?> c) {
        return (SELF)this.array((String)null, (Collection)c);
    }

    @Override
    public SELF array(String key, Collection<?> c) {
        if (key == null) {
            this.array();
        } else {
            this.array(key);
        }
        for (Object o : c) {
            this.value(o);
        }
        return (SELF)this.end();
    }

    @Override
    public SELF object(Map<?, ?> map) {
        return (SELF)this.object((String)null, (Map)map);
    }

    @Override
    public SELF object(String key, Map<?, ?> map) {
        if (key == null) {
            this.object();
        } else {
            this.object(key);
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object o = entry.getValue();
            if (!(entry.getKey() instanceof String)) {
                throw new JsonWriterException("Invalid key type for map: " + (entry.getKey() == null ? "null" : entry.getKey().getClass()));
            }
            String k = (String)entry.getKey();
            this.value(k, o);
        }
        return (SELF)this.end();
    }

    @Override
    public SELF nul() {
        this.preValue();
        this.raw("null");
        return this.castThis();
    }

    @Override
    public SELF nul(String key) {
        this.preValue(key);
        this.raw("null");
        return this.castThis();
    }

    @Override
    public SELF value(Object o) {
        if (o == null) {
            return (SELF)this.nul();
        }
        if (o instanceof String) {
            return (SELF)this.value((String)o);
        }
        if (o instanceof Number) {
            return (SELF)this.value((Number)o);
        }
        if (o instanceof Boolean) {
            return (SELF)this.value((Boolean)o);
        }
        if (o instanceof Collection) {
            return (SELF)this.array((Collection)o);
        }
        if (o instanceof Map) {
            return (SELF)this.object((Map)o);
        }
        if (o.getClass().isArray()) {
            int length = Array.getLength(o);
            this.array();
            for (int i = 0; i < length; ++i) {
                this.value(Array.get(o, i));
            }
            return (SELF)this.end();
        }
        throw new JsonWriterException("Unable to handle type: " + o.getClass());
    }

    @Override
    public SELF value(String key, Object o) {
        if (o == null) {
            return (SELF)this.nul(key);
        }
        if (o instanceof String) {
            return (SELF)this.value(key, (String)o);
        }
        if (o instanceof Number) {
            return (SELF)this.value(key, (Number)o);
        }
        if (o instanceof Boolean) {
            return (SELF)this.value(key, (Boolean)o);
        }
        if (o instanceof Collection) {
            return (SELF)this.array(key, (Collection)o);
        }
        if (o instanceof Map) {
            return (SELF)this.object(key, (Map)o);
        }
        if (o.getClass().isArray()) {
            int length = Array.getLength(o);
            this.array(key);
            for (int i = 0; i < length; ++i) {
                this.value(Array.get(o, i));
            }
            return (SELF)this.end();
        }
        throw new JsonWriterException("Unable to handle type: " + o.getClass());
    }

    @Override
    public SELF value(String s) {
        if (s == null) {
            return (SELF)this.nul();
        }
        this.preValue();
        this.emitStringValue(s);
        return this.castThis();
    }

    @Override
    public SELF value(int i) {
        this.preValue();
        this.raw(Integer.toString(i));
        return this.castThis();
    }

    @Override
    public SELF value(long l) {
        this.preValue();
        this.raw(Long.toString(l));
        return this.castThis();
    }

    @Override
    public SELF value(boolean b) {
        this.preValue();
        this.raw(Boolean.toString(b));
        return this.castThis();
    }

    @Override
    public SELF value(double d) {
        this.preValue();
        this.raw(Double.toString(d));
        return this.castThis();
    }

    @Override
    public SELF value(float d) {
        this.preValue();
        this.raw(Float.toString(d));
        return this.castThis();
    }

    @Override
    public SELF value(Number n) {
        this.preValue();
        if (n == null) {
            this.raw("null");
        } else {
            this.raw(n.toString());
        }
        return this.castThis();
    }

    @Override
    public SELF value(String key, String s) {
        if (s == null) {
            return (SELF)this.nul(key);
        }
        this.preValue(key);
        this.emitStringValue(s);
        return this.castThis();
    }

    @Override
    public SELF value(String key, int i) {
        this.preValue(key);
        this.raw(Integer.toString(i));
        return this.castThis();
    }

    @Override
    public SELF value(String key, long l) {
        this.preValue(key);
        this.raw(Long.toString(l));
        return this.castThis();
    }

    @Override
    public SELF value(String key, boolean b) {
        this.preValue(key);
        this.raw(Boolean.toString(b));
        return this.castThis();
    }

    @Override
    public SELF value(String key, double d) {
        this.preValue(key);
        this.raw(Double.toString(d));
        return this.castThis();
    }

    @Override
    public SELF value(String key, float d) {
        this.preValue(key);
        this.raw(Float.toString(d));
        return this.castThis();
    }

    @Override
    public SELF value(String key, Number n) {
        if (n == null) {
            return (SELF)this.nul(key);
        }
        this.preValue(key);
        this.raw(n.toString());
        return this.castThis();
    }

    @Override
    public SELF array() {
        this.preValue();
        this.states.push(this.inObject);
        this.inObject = false;
        this.first = true;
        this.raw('[');
        return this.castThis();
    }

    @Override
    public SELF object() {
        this.preValue();
        this.states.push(this.inObject);
        this.inObject = true;
        this.first = true;
        this.raw('{');
        if (this.indentString != null) {
            ++this.indent;
            this.appendNewLine();
        }
        return this.castThis();
    }

    @Override
    public SELF array(String key) {
        this.preValue(key);
        this.states.push(this.inObject);
        this.inObject = false;
        this.first = true;
        this.raw('[');
        return this.castThis();
    }

    @Override
    public SELF object(String key) {
        this.preValue(key);
        this.states.push(this.inObject);
        this.inObject = true;
        this.first = true;
        this.raw('{');
        if (this.indentString != null) {
            ++this.indent;
            this.appendNewLine();
        }
        return this.castThis();
    }

    @Override
    public SELF end() {
        if (this.states.size() == 0) {
            throw new JsonWriterException("Invalid call to end()");
        }
        if (this.inObject) {
            if (this.indentString != null) {
                --this.indent;
                this.appendNewLine();
                this.appendIndent();
            }
            this.raw('}');
        } else {
            this.raw(']');
        }
        this.first = false;
        this.inObject = this.states.pop();
        return this.castThis();
    }

    protected void doneInternal() {
        if (this.states.size() > 0) {
            throw new JsonWriterException("Unclosed JSON objects and/or arrays when closing writer");
        }
        if (this.first) {
            throw new JsonWriterException("Nothing was written to the JSON writer");
        }
    }

    private void appendIndent() {
        for (int i = 0; i < this.indent; ++i) {
            this.raw(this.indentString);
        }
    }

    private void appendNewLine() {
        this.raw('\n');
    }

    private void raw(String s) {
        try {
            this.appendable.append(s);
        }
        catch (IOException e) {
            throw new JsonWriterException(e);
        }
    }

    private void raw(char c) {
        try {
            this.appendable.append(c);
        }
        catch (IOException e) {
            throw new JsonWriterException(e);
        }
    }

    private void pre() {
        if (this.first) {
            this.first = false;
        } else {
            if (this.states.size() == 0) {
                throw new JsonWriterException("Invalid call to emit a value in a finished JSON writer");
            }
            this.raw(',');
            if (this.indentString != null && this.inObject) {
                this.appendNewLine();
            }
        }
    }

    private void preValue() {
        if (this.inObject) {
            throw new JsonWriterException("Invalid call to emit a keyless value while writing an object");
        }
        this.pre();
    }

    private void preValue(String key) {
        if (!this.inObject) {
            throw new JsonWriterException("Invalid call to emit a key value while not writing an object");
        }
        this.pre();
        if (this.indentString != null) {
            this.appendIndent();
        }
        this.emitStringValue(key);
        this.raw(':');
    }

    private void emitStringValue(String s) {
        this.raw('\"');
        char b = '\u0000';
        char c = '\u0000';
        block9: for (int i = 0; i < s.length(); ++i) {
            b = c;
            c = s.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    this.raw('\\');
                    this.raw(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        this.raw('\\');
                    }
                    this.raw(c);
                    continue block9;
                }
                case '\b': {
                    this.raw("\\b");
                    continue block9;
                }
                case '\t': {
                    this.raw("\\t");
                    continue block9;
                }
                case '\n': {
                    this.raw("\\n");
                    continue block9;
                }
                case '\f': {
                    this.raw("\\f");
                    continue block9;
                }
                case '\r': {
                    this.raw("\\r");
                    continue block9;
                }
                default: {
                    if (this.shouldBeEscaped(c)) {
                        String t = "000" + Integer.toHexString(c);
                        this.raw("\\u" + t.substring(t.length() - "0000".length()));
                        continue block9;
                    }
                    this.raw(c);
                }
            }
        }
        this.raw('\"');
    }

    private boolean shouldBeEscaped(char c) {
        return c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100';
    }
}

