/*
 * Decompiled with CFR 0.152.
 */
package cyano.mineralogy.worldgen.math;

import cyano.mineralogy.worldgen.math.CubicInterpolator;

public class NoiseLayer2D {
    private final long seed;
    private static final long rand_multiplier = 25214903917L;
    private static final long rand_addend = 11L;
    private static final long rand_mask = 0xFFFFFFFFFFFFL;
    private final float multiplier;
    private final float magnitude;
    private final int precisionMask = 1048575;
    private final float intConversionMultiplier = 1.9073505E-6f;

    public NoiseLayer2D(long seed, float size, float magnitude) {
        this.seed = seed;
        this.multiplier = 1.0f / size;
        this.magnitude = magnitude;
    }

    public float getValueAt(double x, double y) {
        int gridX = (int)(x *= (double)this.multiplier);
        int gridY = (int)(y *= (double)this.multiplier);
        float[][] local16 = new float[4][4];
        for (int dx = 0; dx < 4; ++dx) {
            for (int dy = 0; dy < 4; ++dy) {
                local16[dx][dy] = this.randAt(gridX + dx, gridY + dy);
            }
        }
        return CubicInterpolator.interpolate2d(x, y, local16);
    }

    protected float randAt(int x, int y) {
        long h = NoiseLayer2D.hash(x, y, this.seed);
        float value = this.magnitude * ((float)(h & 0xFFFFFL) * 1.9073505E-6f - 1.0f);
        return value;
    }

    static long hash(int x, int y, long seed) {
        long l = (seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
        l = (l * 25214903917L + 11L ^ (long)x) & 0xFFFFFFFFFFFFL;
        l = (l * 25214903917L + 11L ^ (long)y) & 0xFFFFFFFFFFFFL;
        l = l * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return l;
    }
}

