/*
 * Decompiled with CFR 0.152.
 */
package cyano.mineralogy.worldgen.math;

import cyano.mineralogy.worldgen.math.NoiseLayer2D;

public class PerlinNoise2D {
    private final NoiseLayer2D[] layers;
    private static final long rand_multiplier = 25214903917L;
    private static final long rand_addend = 11L;
    private static final long rand_mask = 0xFFFFFFFFFFFFL;

    public PerlinNoise2D(long seed, float initialRange, float initialSize, int numOvertoneLayers) {
        this.layers = new NoiseLayer2D[numOvertoneLayers];
        for (int i = 0; i < this.layers.length; ++i) {
            seed = PerlinNoise2D.scramble(seed);
            this.layers[i] = new NoiseLayer2D(seed, initialSize, initialRange);
            initialSize = (float)((double)initialSize * 0.5);
            initialRange = (float)((double)initialRange * 0.5);
        }
    }

    public float valueAt(double x, double y) {
        float sum = 0.0f;
        for (int i = 0; i < this.layers.length; ++i) {
            sum += this.layers[i].getValueAt(x, y);
        }
        return sum;
    }

    private static long scramble(long l) {
        return l * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
    }
}

