/*
 * Decompiled with CFR 0.152.
 */
package com.grack.nanojson;

import com.grack.nanojson.JsonArray;
import com.grack.nanojson.JsonObject;
import com.grack.nanojson.JsonSink;
import com.grack.nanojson.JsonWriterException;
import java.util.Collection;
import java.util.Map;
import java.util.Stack;

public final class JsonBuilder<T>
implements JsonSink<JsonBuilder<T>> {
    private Stack<Object> json = new Stack();
    private T root;

    JsonBuilder(T root) {
        this.root = root;
        this.json.push(root);
    }

    public T done() {
        return this.root;
    }

    @Override
    public JsonBuilder<T> array(Collection<?> c) {
        return this.value(c);
    }

    @Override
    public JsonBuilder<T> array(String key, Collection<?> c) {
        return this.value(key, c);
    }

    @Override
    public JsonBuilder<T> object(Map<?, ?> map) {
        return this.value(map);
    }

    @Override
    public JsonBuilder<T> object(String key, Map<?, ?> map) {
        return this.value(key, map);
    }

    @Override
    public JsonBuilder<T> nul() {
        return this.value((Object)null);
    }

    @Override
    public JsonBuilder<T> nul(String key) {
        return this.value(key, (Object)null);
    }

    @Override
    public JsonBuilder<T> value(Object o) {
        this.arr().add(o);
        return this;
    }

    @Override
    public JsonBuilder<T> value(String key, Object o) {
        this.obj().put(key, o);
        return this;
    }

    @Override
    public JsonBuilder<T> value(String s) {
        return this.value((Object)s);
    }

    @Override
    public JsonBuilder<T> value(int i) {
        return this.value((Object)i);
    }

    @Override
    public JsonBuilder<T> value(long l) {
        return this.value((Object)l);
    }

    @Override
    public JsonBuilder<T> value(boolean b) {
        return this.value((Object)b);
    }

    @Override
    public JsonBuilder<T> value(double d) {
        return this.value((Object)d);
    }

    @Override
    public JsonBuilder<T> value(float f) {
        return this.value((Object)Float.valueOf(f));
    }

    @Override
    public JsonBuilder<T> value(Number n) {
        return this.value((Object)n);
    }

    @Override
    public JsonBuilder<T> value(String key, String s) {
        return this.value(key, (Object)s);
    }

    @Override
    public JsonBuilder<T> value(String key, int i) {
        return this.value(key, (Object)i);
    }

    @Override
    public JsonBuilder<T> value(String key, long l) {
        return this.value(key, (Object)l);
    }

    @Override
    public JsonBuilder<T> value(String key, boolean b) {
        return this.value(key, (Object)b);
    }

    @Override
    public JsonBuilder<T> value(String key, double d) {
        return this.value(key, (Object)d);
    }

    @Override
    public JsonBuilder<T> value(String key, float f) {
        return this.value(key, (Object)Float.valueOf(f));
    }

    @Override
    public JsonBuilder<T> value(String key, Number n) {
        return this.value(key, (Object)n);
    }

    @Override
    public JsonBuilder<T> array() {
        JsonArray a = new JsonArray();
        this.value(a);
        this.json.push(a);
        return this;
    }

    @Override
    public JsonBuilder<T> object() {
        JsonObject o = new JsonObject();
        this.value(o);
        this.json.push(o);
        return this;
    }

    @Override
    public JsonBuilder<T> array(String key) {
        JsonArray a = new JsonArray();
        this.value(key, a);
        this.json.push(a);
        return this;
    }

    @Override
    public JsonBuilder<T> object(String key) {
        JsonObject o = new JsonObject();
        this.value(key, o);
        this.json.push(o);
        return this;
    }

    @Override
    public JsonBuilder<T> end() {
        if (this.json.size() == 1) {
            throw new JsonWriterException("Cannot end the root object or array");
        }
        this.json.pop();
        return this;
    }

    private JsonObject obj() {
        try {
            return (JsonObject)this.json.peek();
        }
        catch (ClassCastException e) {
            throw new JsonWriterException("Attempted to write a keyed value to a JsonArray");
        }
    }

    private JsonArray arr() {
        try {
            return (JsonArray)this.json.peek();
        }
        catch (ClassCastException e) {
            throw new JsonWriterException("Attempted to write a non-keyed value to a JsonObject");
        }
    }
}

