/*
 * Decompiled with CFR 0.152.
 */
package cyano.mineralogy;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cyano.mineralogy.RockType;
import cyano.mineralogy.blocks.Chert;
import cyano.mineralogy.blocks.DryWall;
import cyano.mineralogy.blocks.Gypsum;
import cyano.mineralogy.blocks.Ore;
import cyano.mineralogy.blocks.Rock;
import cyano.mineralogy.items.GypsumDust;
import cyano.mineralogy.items.MineralFertilizer;
import cyano.mineralogy.items.NitrateDust;
import cyano.mineralogy.items.PhosphoriteDust;
import cyano.mineralogy.items.SulfurDust;
import cyano.mineralogy.worldgen.MineralogyWorldProvider;
import cyano.mineralogy.worldgen.OreSpawner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

@Mod(modid="mineralogy", name="Mineralogy", version="1.0")
public class Mineralogy {
    public static final String MODID = "mineralogy";
    public static final String NAME = "Mineralogy";
    public static final String VERSION = "1.0";
    public static final List<Block> sedimentaryStones = new ArrayList<Block>();
    public static final List<Block> metamorphicStones = new ArrayList<Block>();
    public static final List<Block> igneousStones = new ArrayList<Block>();
    public static final Map<String, Block> mineralogyBlockRegistry = new HashMap<String, Block>();
    public static double ROCK_LAYER_SIZE = 32.0;
    public static int GEOME_SIZE = 100;
    public static Block blockChert;
    public static Block blockGypsum;
    public static Item gypsumPowder;
    public static Item sulphurPowder;
    public static Item phosphorousPowder;
    public static Item nitratePowder;
    public static Item mineralFertilizer;
    public static Block[] drywall;
    public static final String CONFIG_CATAGORY_ORES = "ores";
    private Set<Map.Entry<String, Property>> oreProperties = null;
    private static int oreWeightCount;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        Mineralogy.addStoneType(RockType.IGNEOUS, "andesite", 1.5, 10.0, 0, true, true, true, false);
        Mineralogy.addStoneType(RockType.IGNEOUS, "basalt", 5.0, 100.0, 2, true, true, true, false);
        Mineralogy.addStoneType(RockType.IGNEOUS, "diorite", 1.5, 10.0, 0, true, true, true, false);
        Mineralogy.addStoneType(RockType.IGNEOUS, "granite", 3.0, 15.0, 1, true, true, true, false);
        Mineralogy.addStoneType(RockType.IGNEOUS, "pumice", 0.75, 1.0, 0, false, true, true, false);
        Mineralogy.addStoneType(RockType.IGNEOUS, "rhyolite", 1.5, 10.0, 0, true, true, true, false);
        Mineralogy.addStoneType(RockType.IGNEOUS, "pegmatite", 1.5, 10.0, 0, true, true, true, false);
        Mineralogy.addStoneType(RockType.SEDIMENTARY, "shale", 1.5, 10.0, 0, true, true, true, true);
        Mineralogy.addStoneType(RockType.SEDIMENTARY, "conglomerate", 1.5, 10.0, 0, false, true, true, false);
        Mineralogy.addStoneType(RockType.SEDIMENTARY, "dolomite", 3.0, 15.0, 1, true, true, true, false);
        Mineralogy.addStoneType(RockType.SEDIMENTARY, "limestone", 1.5, 10.0, 0, true, true, true, true);
        sedimentaryStones.add(Blocks.field_150322_A);
        sedimentaryStones.add((Block)Blocks.field_150354_m);
        sedimentaryStones.add(Blocks.field_150351_n);
        blockGypsum = new Gypsum();
        GameRegistry.registerBlock((Block)blockGypsum, (String)"gypsum");
        mineralogyBlockRegistry.put("gypsum", blockGypsum);
        blockChert = new Chert();
        GameRegistry.registerBlock((Block)blockChert, (String)"chert");
        mineralogyBlockRegistry.put("chert", blockChert);
        sedimentaryStones.add(blockChert);
        Mineralogy.addStoneType(RockType.METAMORPHIC, "slate", 1.5, 10.0, 0, true, true, true, true);
        Mineralogy.addStoneType(RockType.METAMORPHIC, "schist", 3.0, 15.0, 1, true, true, true, false);
        Mineralogy.addStoneType(RockType.METAMORPHIC, "gneiss", 3.0, 15.0, 1, true, true, true, false);
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Blocks.field_150347_e, 4), new Object[]{"stone", "stone", Blocks.field_150351_n, Blocks.field_150351_n}));
        GameRegistry.addSmelting((Block)Blocks.field_150351_n, (ItemStack)new ItemStack(Blocks.field_150348_b, 1), (float)0.1f);
        gypsumPowder = new GypsumDust();
        GameRegistry.registerItem((Item)gypsumPowder, (String)"gypsum_dust");
        OreDictionary.registerOre((String)"dustGypsum", (Item)gypsumPowder);
        sulphurPowder = new SulfurDust();
        GameRegistry.registerItem((Item)sulphurPowder, (String)"sulfur_dust");
        OreDictionary.registerOre((String)"dustSulfur", (Item)sulphurPowder);
        phosphorousPowder = new PhosphoriteDust();
        GameRegistry.registerItem((Item)phosphorousPowder, (String)"phosphorous_dust");
        OreDictionary.registerOre((String)"dustPhosphorous", (Item)phosphorousPowder);
        nitratePowder = new NitrateDust();
        GameRegistry.registerItem((Item)nitratePowder, (String)"nitrate_dust");
        OreDictionary.registerOre((String)"dustNitrate", (Item)nitratePowder);
        mineralFertilizer = new MineralFertilizer();
        GameRegistry.registerItem((Item)mineralFertilizer, (String)"mineral_fertilizer");
        OreDictionary.registerOre((String)"fertilizer", (Item)mineralFertilizer);
        Mineralogy.addOre("sulfur_ore", "oreSulfur", sulphurPowder, 1, 4, 0, config.getInt("sulphur_ore.minY", "Mineralogy Ores", 16, 1, 255, "Minimum ore spawn height"), config.getInt("sulphur_ore.maxY", "Mineralogy Ores", 64, 1, 255, "Maximum ore spawn height"), config.getInt("sulphur_ore.frequency", "Mineralogy Ores", 1, 0, 63, "Number of ore deposits per chunk"), config.getInt("sulphur_ore.quantity", "Mineralogy Ores", 16, 0, 63, "Size of ore deposit"));
        Mineralogy.addOre("phosphorous_ore", "orePhosphorous", phosphorousPowder, 1, 4, 0, config.getInt("phosphorous_ore.minY", "Mineralogy Ores", 16, 1, 255, "Minimum ore spawn height"), config.getInt("phosphorous_ore.maxY", "Mineralogy Ores", 64, 1, 255, "Maximum ore spawn height"), config.getInt("phosphorous_ore.frequency", "Mineralogy Ores", 1, 0, 63, "Number of ore deposits per chunk"), config.getInt("phosphorous_ore.quantity", "Mineralogy Ores", 16, 0, 63, "Size of ore deposit"));
        Mineralogy.addOre("nitrate_ore", "oreNitrate", nitratePowder, 1, 4, 0, config.getInt("nitrate_ore.minY", "Mineralogy Ores", 16, 1, 255, "Minimum ore spawn height"), config.getInt("nitrate_ore.maxY", "Mineralogy Ores", 64, 1, 255, "Maximum ore spawn height"), config.getInt("nitrate_ore.frequency", "Mineralogy Ores", 1, 0, 63, "Number of ore deposits per chunk"), config.getInt("nitrate_ore.quantity", "Mineralogy Ores", 16, 0, 63, "Size of ore deposit"));
        String[] colorSuffixes = new String[]{"black", "red", "green", "brown", "blue", "purple", "cyan", "silver", "gray", "pink", "lime", "yellow", "light_blue", "magenta", "orange", "white"};
        for (int i = 0; i < 16; ++i) {
            Mineralogy.drywall[i] = new DryWall(colorSuffixes[i]);
            GameRegistry.registerBlock((Block)drywall[i], (String)("drywall_" + colorSuffixes[i]));
            OreDictionary.registerOre((String)"drywall", (Block)drywall[i]);
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(drywall[7], 3), new Object[]{"pgp", "pgp", "pgp", Character.valueOf('p'), Items.field_151121_aF, Character.valueOf('g'), "dustGypsum"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(drywall[0], 1), new Object[]{"drywall", "dyeBlack"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(drywall[1], 1), new Object[]{"drywall", "dyeRed"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(drywall[2], 1), new Object[]{"drywall", "dyeGreen"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(drywall[3], 1), new Object[]{"drywall", "dyeBrown"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(drywall[4], 1), new Object[]{"drywall", "dyeBlue"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(drywall[5], 1), new Object[]{"drywall", "dyePurple"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(drywall[6], 1), new Object[]{"drywall", "dyeCyan"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(drywall[7], 1), new Object[]{"drywall", "dyeLightGray"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(drywall[8], 1), new Object[]{"drywall", "dyeGray"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(drywall[9], 1), new Object[]{"drywall", "dyePink"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(drywall[10], 1), new Object[]{"drywall", "dyeLime"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(drywall[11], 1), new Object[]{"drywall", "dyeYellow"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(drywall[12], 1), new Object[]{"drywall", "dyeLightBlue"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(drywall[13], 1), new Object[]{"drywall", "dyeMagenta"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(drywall[14], 1), new Object[]{"drywall", "dyeOrange"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(drywall[15], 1), new Object[]{"drywall", "dyeWhite"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Items.field_151016_H, 4), new Object[]{new ItemStack(Items.field_151044_h, 1, 1), "dustNitrate", "dustSulfur"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Items.field_151016_H, 4), new Object[]{Items.field_151102_aT, "dustNitrate", "dustSulfur"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(mineralFertilizer, 1), new Object[]{"dustNitrate", "dustPhosphorous"}));
        config.save();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        DimensionManager.unregisterProviderType((int)0);
        DimensionManager.registerProviderType((int)0, MineralogyWorldProvider.class, (boolean)true);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    private static void addOre(String oreName, String oreDictionaryName, Item oreDropItem, int numMin, int numMax, int pickLevel, int minY, int maxY, int spawnFrequency, int spawnQuantity) {
        String oreBlockName = "mineralogy_" + oreName;
        Ore oreBlock = new Ore(oreName, oreDropItem, numMin, numMax, pickLevel);
        GameRegistry.registerBlock((Block)oreBlock, (String)oreName);
        mineralogyBlockRegistry.put(oreName, oreBlock);
        OreDictionary.registerOre((String)oreDictionaryName, (Block)oreBlock);
        OreSpawner oreSpawner = new OreSpawner(oreBlock, minY, maxY, spawnFrequency, spawnQuantity, (long)oreWeightCount * 25214903917L + 11L);
        GameRegistry.registerWorldGenerator((IWorldGenerator)oreSpawner, (int)oreWeightCount++);
    }

    private static void addStoneType(RockType type, String name, double hardness, double blastResistance, int toolHardnessLevel, boolean isStoneEquivalent, boolean isCobblestoneEquivalent, boolean hasSmooth, boolean hasBricks) {
        Rock b = new Rock();
        b.func_149663_c("mineralogy_" + name);
        b.func_149658_d("mineralogy:" + name);
        b.func_149647_a(CreativeTabs.field_78030_b);
        b.func_149711_c((float)hardness);
        b.func_149752_b((float)blastResistance);
        b.func_149672_a(Block.field_149780_i);
        b.setHarvestLevel("pickaxe", toolHardnessLevel);
        GameRegistry.registerBlock((Block)b, (String)name);
        mineralogyBlockRegistry.put(name, b);
        switch (type) {
            case IGNEOUS: {
                igneousStones.add(b);
                break;
            }
            case METAMORPHIC: {
                metamorphicStones.add(b);
                break;
            }
            case SEDIMENTARY: {
                sedimentaryStones.add(b);
                break;
            }
            case ANY: {
                sedimentaryStones.add(b);
                metamorphicStones.add(b);
                igneousStones.add(b);
            }
        }
        if (isStoneEquivalent) {
            OreDictionary.registerOre((String)"stone", (Block)b);
        }
        if (isStoneEquivalent) {
            OreDictionary.registerOre((String)"cobblestone", (Block)b);
        }
        if (hasSmooth) {
            String smoothName = name + "_smooth";
            Rock b2 = new Rock();
            b2.func_149663_c("mineralogy_" + smoothName);
            b2.func_149658_d("mineralogy:" + smoothName);
            b2.func_149647_a(CreativeTabs.field_78030_b);
            b2.func_149711_c((float)hardness);
            b2.func_149752_b((float)blastResistance);
            b2.func_149672_a(Block.field_149780_i);
            b2.setHarvestLevel("pickaxe", toolHardnessLevel);
            GameRegistry.registerBlock((Block)b2, (String)smoothName);
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)b2, 4), (Object[])new Object[]{"xx", "xx", Character.valueOf('x'), new ItemStack((Block)b)});
            mineralogyBlockRegistry.put(smoothName, b2);
            if (hasBricks) {
                String brickName = name + "_brick";
                Rock b3 = new Rock();
                b3.func_149663_c("mineralogy_" + brickName);
                b3.func_149658_d("mineralogy:" + brickName);
                b3.func_149647_a(CreativeTabs.field_78030_b);
                b3.func_149711_c((float)hardness * 2.0f);
                b3.func_149752_b((float)blastResistance * 1.5f);
                b3.func_149672_a(Block.field_149780_i);
                b3.setHarvestLevel("pickaxe", toolHardnessLevel);
                GameRegistry.registerBlock((Block)b3, (String)brickName);
                GameRegistry.addRecipe((ItemStack)new ItemStack((Block)b3, 4), (Object[])new Object[]{"xx", "xx", Character.valueOf('x'), new ItemStack((Block)b2)});
                mineralogyBlockRegistry.put(brickName, b3);
            }
        }
    }

    static {
        drywall = new Block[16];
        oreWeightCount = 20;
    }
}

