/*
 * Decompiled with CFR 0.152.
 */
package cyano.mineralogy.worldgen;

import cyano.mineralogy.Mineralogy;
import cyano.mineralogy.worldgen.math.PerlinNoise2D;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class Geology {
    private final PerlinNoise2D geomeNoiseLayer;
    private final PerlinNoise2D rockNoiseLayer;
    private final long seed;
    private final double geomeSize;
    private static final int multiplier = 1103515245;
    private static final int addend = 12345;
    private static final int mask = Integer.MAX_VALUE;
    private final short[] whiteNoiseArray;

    public Geology(long seed, double geomeSize, double rockLayerSize) {
        this.seed = seed;
        int rockLayerUndertones = 4;
        int undertoneMultiplier = 1 << rockLayerUndertones - 1;
        this.geomeNoiseLayer = new PerlinNoise2D(seed ^ 0xFFFFFFFFFFFFFFFFL, 128.0f, (float)geomeSize, 2);
        this.rockNoiseLayer = new PerlinNoise2D(seed, 4 * undertoneMultiplier, (float)(rockLayerSize * (double)undertoneMultiplier), rockLayerUndertones);
        this.geomeSize = geomeSize;
        Random r = new Random(seed);
        this.whiteNoiseArray = new short[256];
        for (int i = 0; i < this.whiteNoiseArray.length; ++i) {
            this.whiteNoiseArray[i] = (short)r.nextInt(Short.MAX_VALUE);
        }
    }

    public Block getStoneAt(int x, int y, int z) {
        float geome = this.geomeNoiseLayer.valueAt(x, z) + (float)y;
        int rv = (int)this.rockNoiseLayer.valueAt(x, z) + y;
        if (geome < -64.0f) {
            return this.pickBlockFromList(rv, Mineralogy.igneousStones);
        }
        if (geome < 64.0f) {
            return this.pickBlockFromList(rv, Mineralogy.metamorphicStones);
        }
        return this.pickBlockFromList(rv, Mineralogy.sedimentaryStones);
    }

    public void replaceStoneInChunk(int chunkX, int chunkZ, Block[] blockBuffer) {
        int height = blockBuffer.length / 256;
        int xOffset = chunkX << 4;
        int zOffset = chunkZ << 4;
        for (int dx = 0; dx < 16; ++dx) {
            int x = xOffset | dx;
            for (int dz = 0; dz < 16; ++dz) {
                int y;
                int z = zOffset | dz;
                int indexBase = (dx * 16 + dz) * height;
                for (y = height - 1; y > 0 && blockBuffer[indexBase + y] == Blocks.field_150350_a; --y) {
                }
                int baseRockVal = (int)this.rockNoiseLayer.valueAt(x, z);
                int gbase = (int)this.geomeNoiseLayer.valueAt(x, z);
                while (y > 0) {
                    int i = indexBase + y;
                    if (blockBuffer[i] == Blocks.field_150348_b) {
                        int geome = gbase + y;
                        blockBuffer[i] = geome < -32 ? this.pickBlockFromList(baseRockVal + y, Mineralogy.igneousStones) : (geome < 32 ? this.pickBlockFromList(baseRockVal + y + 3, Mineralogy.metamorphicStones) : this.pickBlockFromList(baseRockVal + y + 5, Mineralogy.sedimentaryStones));
                    }
                    --y;
                }
            }
        }
    }

    public Block[] getStoneColumn(int x, int z, int height) {
        Block[] col = new Block[height];
        int baseRockVal = (int)this.rockNoiseLayer.valueAt(x, z);
        double gbase = this.geomeNoiseLayer.valueAt(x, z);
        for (int y = 0; y < col.length; ++y) {
            double geome = gbase + (double)y;
            col[y] = geome < -32.0 ? this.pickBlockFromList(baseRockVal + y, Mineralogy.igneousStones) : (geome < 32.0 ? this.pickBlockFromList(baseRockVal + y + 3, Mineralogy.metamorphicStones) : this.pickBlockFromList(baseRockVal + y + 5, Mineralogy.sedimentaryStones));
        }
        return col;
    }

    private Block pickBlockFromList(int value, List<Block> list) {
        return list.get(this.whiteNoiseArray[value >> 3 & 0xFF] % list.size());
    }
}

