/*
 * Decompiled with CFR 0.152.
 */
package cyano.mineralogy.worldgen;

import cyano.mineralogy.Mineralogy;
import cyano.mineralogy.worldgen.Geology;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.MapGenRavine;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class MineralogyChunkGenerator
extends ChunkProviderGenerate {
    final String generatorOptionsString;
    final WorldType worldType;
    final World field_73230_p;
    final Geology geome;
    final boolean field_73229_q;
    final Random field_73220_k;
    private MapGenBase caveGenerator = new MapGenCaves();
    private MapGenStronghold strongholdGenerator = new MapGenStronghold();
    private MapGenVillage villageGenerator = new MapGenVillage();
    private MapGenMineshaft mineshaftGenerator = new MapGenMineshaft();
    private MapGenScatteredFeature scatteredFeatureGenerator = new MapGenScatteredFeature();
    private MapGenBase ravineGenerator = new MapGenRavine();
    private BiomeGenBase[] biomesForGeneration;

    public MineralogyChunkGenerator(World world, long seed, boolean mapFeaturesEnabled, String generatorOptionsString, WorldType worldType) {
        super(world, seed, mapFeaturesEnabled);
        this.caveGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.caveGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
        this.strongholdGenerator = (MapGenStronghold)TerrainGen.getModdedMapGen((MapGenBase)this.strongholdGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.STRONGHOLD);
        this.villageGenerator = (MapGenVillage)TerrainGen.getModdedMapGen((MapGenBase)this.villageGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.VILLAGE);
        this.mineshaftGenerator = (MapGenMineshaft)TerrainGen.getModdedMapGen((MapGenBase)this.mineshaftGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.MINESHAFT);
        this.scatteredFeatureGenerator = (MapGenScatteredFeature)TerrainGen.getModdedMapGen((MapGenBase)this.scatteredFeatureGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.SCATTERED_FEATURE);
        this.ravineGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.ravineGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.RAVINE);
        this.worldType = worldType;
        this.field_73230_p = world;
        this.generatorOptionsString = generatorOptionsString;
        this.field_73229_q = mapFeaturesEnabled;
        this.field_73220_k = new Random(seed);
        this.geome = new Geology(seed, Mineralogy.GEOME_SIZE, Mineralogy.ROCK_LAYER_SIZE);
    }

    public Chunk func_73154_d(int chunkX, int chunkY) {
        this.field_73220_k.setSeed((long)chunkX * 341873128712L + (long)chunkY * 132897987541L);
        Block[] ablock = new Block[65536];
        byte[] abyte = new byte[65536];
        this.func_147424_a(chunkX, chunkY, ablock);
        this.biomesForGeneration = this.field_73230_p.func_72959_q().func_76933_b(this.biomesForGeneration, chunkX * 16, chunkY * 16, 16, 16);
        this.func_147422_a(chunkX, chunkY, ablock, abyte, this.biomesForGeneration);
        this.caveGenerator.func_151539_a((IChunkProvider)this, this.field_73230_p, chunkX, chunkY, ablock);
        this.ravineGenerator.func_151539_a((IChunkProvider)this, this.field_73230_p, chunkX, chunkY, ablock);
        this.geome.replaceStoneInChunk(chunkX, chunkY, ablock);
        if (this.field_73229_q) {
            this.mineshaftGenerator.func_151539_a((IChunkProvider)this, this.field_73230_p, chunkX, chunkY, ablock);
            this.villageGenerator.func_151539_a((IChunkProvider)this, this.field_73230_p, chunkX, chunkY, ablock);
            this.strongholdGenerator.func_151539_a((IChunkProvider)this, this.field_73230_p, chunkX, chunkY, ablock);
            this.scatteredFeatureGenerator.func_151539_a((IChunkProvider)this, this.field_73230_p, chunkX, chunkY, ablock);
        }
        Chunk chunk = new Chunk(this.field_73230_p, ablock, abyte, chunkX, chunkY);
        byte[] abyte1 = chunk.func_76605_m();
        for (int k = 0; k < abyte1.length; ++k) {
            abyte1[k] = (byte)this.biomesForGeneration[k].field_76756_M;
        }
        chunk.func_76603_b();
        return chunk;
    }

    static Block pickBlockFromList(float value, List<Block> list) {
        float w = value - (float)MineralogyChunkGenerator.floor(value);
        int index = (int)(w * (float)list.size());
        return list.get(index);
    }

    private static int floor(float x) {
        if (x < 0.0f) {
            return (int)x - 1;
        }
        return (int)x;
    }
}

