/*
 * Decompiled with CFR 0.152.
 */
package cyano.mineralogy.worldgen.math;

public abstract class CubicInterpolator {
    public static double interpolate(double x, double yn2, double yn1, double yp1, double yp2) {
        return CubicInterpolator.interpolate1d(x, yn2, yn1, yp1, yp2);
    }

    public static double interpolate1d(double x, double yn2, double yn1, double yp1, double yp2) {
        double w = x - Math.floor(x);
        if (w == 0.0 && x != 0.0) {
            return yp1;
        }
        if (w < 1.0E-8) {
            return yn1;
        }
        if (w > 0.9999999) {
            return yp1;
        }
        double A = -0.5 * yn2 + 1.5 * yn1 - 1.5 * yp1 + 0.5 * yp2;
        double B = yn2 - 2.5 * yn1 + 2.0 * yp1 - 0.5 * yp2;
        double C = -0.5 * yn2 + 0.5 * yp1;
        double D = yn1;
        return A * w * w * w + B * w * w + C * w + D;
    }

    public static double interpolate2d(double x, double y, double[][] local16) {
        double[] section = new double[4];
        for (int i = 0; i < 4; ++i) {
            section[i] = CubicInterpolator.interpolate1d(y, local16[i][0], local16[i][1], local16[i][2], local16[i][3]);
        }
        return CubicInterpolator.interpolate1d(x, section[0], section[1], section[2], section[3]);
    }

    public static double interpolate3d(double x, double y, double z, double[][][] local64) {
        double[] section = new double[4];
        for (int i = 0; i < 4; ++i) {
            section[i] = CubicInterpolator.interpolate2d(y, z, local64[i]);
        }
        return CubicInterpolator.interpolate1d(x, section[0], section[1], section[2], section[3]);
    }

    public static float interpolate(double x, float yn2, float yn1, float yp1, float yp2) {
        return CubicInterpolator.interpolate1d(x, yn2, yn1, yp1, yp2);
    }

    public static float interpolate1d(double x, float yn2, float yn1, float yp1, float yp2) {
        float w = (float)(x - Math.floor(x));
        if (w == 0.0f && x != 0.0) {
            return yp1;
        }
        if ((double)w < 1.0E-4) {
            return yn1;
        }
        if ((double)w > 0.999) {
            return yp1;
        }
        float A = -0.5f * yn2 + 1.5f * yn1 - 1.5f * yp1 + 0.5f * yp2;
        float B = yn2 - 2.5f * yn1 + 2.0f * yp1 - 0.5f * yp2;
        float C = -0.5f * yn2 + 0.5f * yp1;
        float D = yn1;
        return A * w * w * w + B * w * w + C * w + D;
    }

    public static float interpolate2d(double x, double y, float[][] local16) {
        float[] section = new float[4];
        for (int i = 0; i < 4; ++i) {
            section[i] = CubicInterpolator.interpolate1d(y, local16[i][0], local16[i][1], local16[i][2], local16[i][3]);
        }
        return CubicInterpolator.interpolate1d(x, section[0], section[1], section[2], section[3]);
    }

    public static float interpolate3d(double x, double y, double z, float[][][] local64) {
        float[] section = new float[4];
        for (int i = 0; i < 4; ++i) {
            section[i] = CubicInterpolator.interpolate2d(y, z, local64[i]);
        }
        return CubicInterpolator.interpolate1d(x, section[0], section[1], section[2], section[3]);
    }
}

