/*
 * Decompiled with CFR 0.152.
 */
package com.chef.mod.generate;

import com.chef.mod.generate.features.WorldGenAspBush;
import com.chef.mod.generate.features.WorldGenBellAndTomBush;
import com.chef.mod.generate.features.WorldGenCorn;
import com.chef.mod.generate.features.WorldGenOniBush;
import com.chef.mod.generate.features.WorldGenStrawAndBlueBush;
import com.chef.mod.init.MyBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fml.common.IWorldGenerator;

public class BushGeneration
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.func_177502_q()) {
            case 1: {
                this.generateEnd(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case 0: {
                this.generateOverworld(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case -1: {
                this.generateNether(world, random, chunkX * 16, chunkZ * 16);
            }
        }
    }

    public void generateEnd(World world, Random rand, int x, int z) {
    }

    public void generateOverworld(World world, Random random, int x, int z) {
        this.addStrawAndBlueBushSpawn(MyBlocks.strawberry_bush, world, random, x, z, 16, 16, 30, 50, 100);
        this.addStrawAndBlueBushSpawn(MyBlocks.blueberry_bush, world, random, x, z, 16, 16, 3, 50, 100);
        this.addBellAndTomBushSpawn(MyBlocks.bell_pepper_bush, world, random, x, z, 16, 16, 1, 50, 100);
        this.addBellAndTomBushSpawn(MyBlocks.tomato_bush, world, random, x, z, 16, 16, 3, 50, 100);
        this.addAspBushSpawn(MyBlocks.asparagus_bush, world, random, x, z, 16, 16, 2, 50, 100);
        this.addOniBushSpawn(MyBlocks.onion_bush, world, random, x, z, 16, 16, 2, 50, 100);
        this.addCornSpawn(world, random, x, z, 16, 16, 1, 50, 100);
    }

    public void generateNether(World world, Random rand, int x, int z) {
    }

    public void addStrawAndBlueBushSpawn(Block block, World world, Random random, int blockXpos, int blockZpos, int maxX, int maxZ, int chanceToSpawn, int minY, int maxY) {
        for (int i = 0; i < chanceToSpawn; ++i) {
            int posX = blockXpos + random.nextInt(maxX);
            int posY = minY + random.nextInt(maxY - minY);
            int posZ = blockZpos + random.nextInt(maxZ);
            new WorldGenStrawAndBlueBush(block).func_180709_b(world, random, new BlockPos(posX, posY, posZ));
        }
    }

    public void addBellAndTomBushSpawn(Block block, World world, Random random, int blockXpos, int blockZpos, int maxX, int maxZ, int chanceToSpawn, int minY, int maxY) {
        for (int i = 0; i < chanceToSpawn; ++i) {
            int posX = blockXpos + random.nextInt(maxX);
            int posY = minY + random.nextInt(maxY - minY);
            int posZ = blockZpos + random.nextInt(maxZ);
            new WorldGenBellAndTomBush(block).func_180709_b(world, random, new BlockPos(posX, posY, posZ));
        }
    }

    public void addAspBushSpawn(Block block, World world, Random random, int blockXpos, int blockZpos, int maxX, int maxZ, int chanceToSpawn, int minY, int maxY) {
        for (int i = 0; i < chanceToSpawn; ++i) {
            int posX = blockXpos + random.nextInt(maxX);
            int posY = minY + random.nextInt(maxY - minY);
            int posZ = blockZpos + random.nextInt(maxZ);
            new WorldGenAspBush(block).func_180709_b(world, random, new BlockPos(posX, posY, posZ));
        }
    }

    public void addOniBushSpawn(Block block, World world, Random random, int blockXpos, int blockZpos, int maxX, int maxZ, int chanceToSpawn, int minY, int maxY) {
        for (int i = 0; i < chanceToSpawn; ++i) {
            int posX = blockXpos + random.nextInt(maxX);
            int posY = minY + random.nextInt(maxY - minY);
            int posZ = blockZpos + random.nextInt(maxZ);
            new WorldGenOniBush(block).func_180709_b(world, random, new BlockPos(posX, posY, posZ));
        }
    }

    public void addCornSpawn(World world, Random random, int blockXpos, int blockZpos, int maxX, int maxZ, int chanceToSpawn, int minY, int maxY) {
        for (int i = 0; i < chanceToSpawn; ++i) {
            int posX = blockXpos + random.nextInt(maxX);
            int posY = minY + random.nextInt(maxY - minY);
            int posZ = blockZpos + random.nextInt(maxZ);
            new WorldGenCorn().func_180709_b(world, random, new BlockPos(posX, posY, posZ));
        }
    }
}

