/*
 * Decompiled with CFR 0.152.
 */
package com.chef.mod.tileentity;

import com.chef.mod.blocks.IceCreamMaker;
import com.chef.mod.container.ContainerIceCreamMaker;
import com.chef.mod.crafting.IceCreamMakerRecipes;
import com.chef.mod.init.MyItems;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.SlotFurnaceFuel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.gui.IUpdatePlayerListBox;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityIceCreamMaker
extends TileEntityLockable
implements IUpdatePlayerListBox,
ISidedInventory {
    private static final int[] slotsTop = new int[]{0, 1};
    private static final int[] slotsBottom = new int[]{3};
    private static final int[] slotsSides = new int[]{2};
    private ItemStack[] slots = new ItemStack[4];
    public int dualPower;
    public int dualCookTime;
    public static final int maxPower = 10000;
    public static final int iceCreamMakerSpeed = 100;
    private String iceMakerCustomName;

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int index) {
        return this.slots[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.slots[index] != null) {
            if (this.slots[index].field_77994_a <= count) {
                ItemStack itemstack = this.slots[index];
                this.slots[index] = null;
                return itemstack;
            }
            ItemStack itemstack = this.slots[index].func_77979_a(count);
            if (this.slots[index].field_77994_a == 0) {
                this.slots[index] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int index) {
        if (this.slots[index] != null) {
            ItemStack itemstack = this.slots[index];
            this.slots[index] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.slots[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.iceMakerCustomName : "container.iceCreamMaker";
    }

    public boolean func_145818_k_() {
        return this.iceMakerCustomName != null && this.iceMakerCustomName.length() > 0;
    }

    public void setCustomInventoryName(String string) {
        this.iceMakerCustomName = string;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.dualPower = compound.func_74765_d("PowerTime");
        this.dualCookTime = compound.func_74765_d("CookTime");
        if (compound.func_150297_b("CustomName", 8)) {
            this.iceMakerCustomName = compound.func_74779_i("CustomName");
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74777_a("PowerTime", (short)this.dualPower);
        compound.func_74777_a("CookTime", (short)this.dualCookTime);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.slots[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        compound.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.iceMakerCustomName);
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean hasPower() {
        return this.dualPower > 0;
    }

    public boolean isIcing() {
        return this.dualCookTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isActive(IInventory iinventory) {
        return iinventory.func_174887_a_(0) > 0;
    }

    public void func_73660_a() {
        boolean flag = this.hasPower();
        boolean flag1 = false;
        if (this.hasPower() && this.isIcing()) {
            --this.dualPower;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (TileEntityIceCreamMaker.hasItemPower(this.slots[2])) {
                if (this.dualPower <= 10000 - TileEntityIceCreamMaker.getItemPower(this.slots[2])) {
                    this.dualPower += TileEntityIceCreamMaker.getItemPower(this.slots[2]);
                    if (this.slots[2] != null) {
                        flag1 = true;
                        --this.slots[2].field_77994_a;
                        if (this.slots[2].field_77994_a == 0) {
                            this.slots[2] = this.slots[2].func_77973_b().getContainerItem(this.slots[2]);
                        }
                    }
                }
            }
        }
        if (this.hasPower() && this.canIce()) {
            ++this.dualCookTime;
            if (this.dualCookTime == 100) {
                this.dualCookTime = 0;
                this.iceItem();
                flag1 = true;
            }
        } else {
            this.dualCookTime = 0;
        }
        if (flag != this.isIcing()) {
            flag1 = true;
            IceCreamMaker.setState(this.hasPower(), this.field_145850_b, this.field_174879_c);
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    private boolean canIce() {
        if (this.slots[0] == null || this.slots[1] == null) {
            return false;
        }
        ItemStack itemstack = IceCreamMakerRecipes.getIceCreamResult(this.slots[0].func_77973_b(), this.slots[1].func_77973_b());
        if (itemstack == null) {
            return false;
        }
        if (this.slots[3] == null) {
            return true;
        }
        if (!this.slots[3].func_77969_a(itemstack)) {
            return false;
        }
        int result = this.slots[3].field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= itemstack.func_77976_d();
    }

    public void iceItem() {
        if (this.canIce()) {
            ItemStack itemstack = IceCreamMakerRecipes.getIceCreamResult(this.slots[0].func_77973_b(), this.slots[1].func_77973_b());
            if (this.slots[3] == null) {
                this.slots[3] = itemstack.func_77946_l();
            } else if (this.slots[3].func_77973_b() == itemstack.func_77973_b()) {
                this.slots[3].field_77994_a += itemstack.field_77994_a;
            }
            for (int i = 0; i < 2; ++i) {
                if (this.slots[i].field_77994_a <= 0) {
                    this.slots[i] = new ItemStack(this.slots[i].func_77973_b().func_77664_n());
                } else {
                    --this.slots[i].field_77994_a;
                }
                if (this.slots[i].field_77994_a > 0) continue;
                this.slots[i] = null;
            }
        }
    }

    public static int getItemPower(ItemStack itemstack) {
        if (itemstack == null) {
            return 0;
        }
        Item item = itemstack.func_77973_b();
        if (item == MyItems.ice_shard) {
            return 50;
        }
        return 0;
    }

    public static boolean hasItemPower(ItemStack itemstack) {
        return TileEntityIceCreamMaker.getItemPower(itemstack) > 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 2 ? false : (index != 1 ? true : TileEntityIceCreamMaker.hasItemPower(stack) || SlotFurnaceFuel.func_178173_c_((ItemStack)stack));
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? slotsBottom : (side == EnumFacing.UP ? slotsTop : slotsSides);
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        Item item;
        return direction != EnumFacing.DOWN || index != 1 || (item = stack.func_77973_b()) == Items.field_151131_as || item == Items.field_151133_ar;
    }

    public int getIceMakerProgressScaled(int i) {
        return this.dualCookTime * i / 100;
    }

    public int getPowerRemainingScaled(int i) {
        return this.dualPower * i / 10000;
    }

    public String func_174875_k() {
        return "chef:iceCreamMaker";
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerIceCreamMaker(playerInventory, this);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.dualPower;
            }
            case 1: {
                return this.dualCookTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.dualPower = value;
                break;
            }
            case 1: {
                this.dualCookTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 3;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = null;
        }
    }
}

