/*
 * Decompiled with CFR 0.152.
 */
package com.chef.mod.generate;

import com.chef.mod.generate.features.WorldGenMinableSand;
import com.chef.mod.init.MyBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenBeach;
import net.minecraft.world.biome.BiomeGenHills;
import net.minecraft.world.biome.BiomeGenOcean;
import net.minecraft.world.biome.BiomeGenRiver;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;

public class OreGeneration
implements IWorldGenerator {
    Block block;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.func_177502_q()) {
            case 1: {
                this.generateEnd(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case 0: {
                this.generateOverworld(world, random, chunkX * 16, chunkZ * 16);
                break;
            }
            case -1: {
                this.generateNether(world, random, chunkX * 16, chunkZ * 16);
            }
        }
    }

    public void generateEnd(World world, Random rand, int x, int z) {
    }

    public void generateOverworld(World world, Random random, int x, int z) {
        this.addOreSpawnRockSalt(MyBlocks.rock_salt_ore, world, random, x, z, 16, 16, 2 + random.nextInt(8), 25, 60, 85);
        this.addOreSpawnSeaSalt(MyBlocks.sea_salt_ore, world, random, x, z, 16, 16, 2 + random.nextInt(5), 50, 30, 100);
    }

    public void generateNether(World world, Random rand, int x, int z) {
    }

    public void addOreSpawn(IBlockState state, BlockPos pos, World world, Random random, int maxX, int maxZ, int maxVeinSize, int chanceToSpawn, int minY, int maxY) {
        for (int i = 0; i < chanceToSpawn; ++i) {
            new WorldGenMinable(state, maxVeinSize).func_180709_b(world, random, pos);
        }
    }

    public void addOreSpawnRockSalt(Block block, World world, Random random, int blockXpos, int blockZpos, int maxX, int maxZ, int maxVeinSize, int chanceToSpawn, int minY, int maxY) {
        for (int i = 0; i < chanceToSpawn; ++i) {
            int posZ;
            int posY;
            int posX = blockXpos + random.nextInt(maxX);
            BiomeGenBase biome = world.func_180494_b(new BlockPos(posX, posY = minY + random.nextInt(maxY - minY), posZ = blockZpos + random.nextInt(maxZ)));
            if (!(biome instanceof BiomeGenHills)) continue;
            new WorldGenMinable(block.func_176223_P(), maxVeinSize).func_180709_b(world, random, new BlockPos(posX, posY, posZ));
        }
    }

    public void addOreSpawnSeaSalt(Block block, World world, Random random, int blockXpos, int blockZpos, int maxX, int maxZ, int maxVeinSize, int chanceToSpawn, int minY, int maxY) {
        for (int i = 0; i < chanceToSpawn; ++i) {
            int posZ;
            int posY;
            int posX = blockXpos + random.nextInt(maxX);
            BiomeGenBase biome = world.func_180494_b(new BlockPos(posX, posY = minY + random.nextInt(maxY - minY), posZ = blockZpos + random.nextInt(maxZ)));
            if (!(biome instanceof BiomeGenOcean) && !(biome instanceof BiomeGenBeach) && !(biome instanceof BiomeGenRiver)) continue;
            new WorldGenMinableSand(block.func_176223_P(), maxVeinSize).func_180709_b(world, random, new BlockPos(posX, posY, posZ));
        }
    }
}

