/*
 * Decompiled with CFR 0.152.
 */
package com.chef.mod.tileentity;

import com.chef.mod.blocks.SauceMaker;
import com.chef.mod.container.ContainerSauceMaker;
import com.chef.mod.crafting.SauceMakerRecipes;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.SlotFurnaceFuel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.gui.IUpdatePlayerListBox;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySauceMaker
extends TileEntityLockable
implements IUpdatePlayerListBox,
ISidedInventory {
    private static final int[] slotsTop = new int[]{0, 1};
    private static final int[] slotsBottom = new int[]{3};
    private static final int[] slotsSides = new int[]{2};
    private ItemStack[] slots = new ItemStack[4];
    private int burnTime;
    private int currentItemBurnTime;
    private int cookTime;
    public static final int sauceMakerSpeed = 250;
    private String furnaceCustomName;

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int index) {
        return this.slots[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.slots[index] != null) {
            if (this.slots[index].field_77994_a <= count) {
                ItemStack itemstack = this.slots[index];
                this.slots[index] = null;
                return itemstack;
            }
            ItemStack itemstack = this.slots[index].func_77979_a(count);
            if (this.slots[index].field_77994_a == 0) {
                this.slots[index] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int index) {
        if (this.slots[index] != null) {
            ItemStack itemstack = this.slots[index];
            this.slots[index] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.slots[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.furnaceCustomName : "container.sauceMaker";
    }

    public boolean func_145818_k_() {
        return this.furnaceCustomName != null && this.furnaceCustomName.length() > 0;
    }

    public void setCustomInventoryName(String string) {
        this.furnaceCustomName = string;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.burnTime = compound.func_74765_d("BurnTime");
        this.cookTime = compound.func_74765_d("CookTime");
        this.currentItemBurnTime = TileEntitySauceMaker.getItemBurnTime(this.slots[1]);
        if (compound.func_150297_b("CustomName", 8)) {
            this.furnaceCustomName = compound.func_74779_i("CustomName");
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74777_a("BurnTime", (short)this.burnTime);
        compound.func_74777_a("CookTime", (short)this.cookTime);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.slots[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        compound.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.furnaceCustomName);
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isBurning(IInventory iinventory) {
        return iinventory.func_174887_a_(0) > 0;
    }

    public void func_73660_a() {
        boolean flag = this.burnTime > 0;
        boolean flag1 = false;
        if (this.isBurning()) {
            --this.burnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.burnTime == 0 && this.canJuice()) {
                this.currentItemBurnTime = this.burnTime = TileEntitySauceMaker.getItemBurnTime(this.slots[2]);
                if (this.isBurning()) {
                    flag1 = true;
                    if (this.slots[2] != null) {
                        --this.slots[2].field_77994_a;
                    }
                }
            }
            if (this.isBurning() && this.canJuice()) {
                ++this.cookTime;
                if (this.cookTime == 250) {
                    this.cookTime = 0;
                    this.juiceItem();
                    flag1 = true;
                }
            } else {
                this.cookTime = 0;
            }
            if (flag != this.isBurning()) {
                flag1 = true;
                SauceMaker.setState(this.isBurning(), this.field_145850_b, this.field_174879_c);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public int furnaceSpeed(ItemStack itemstack) {
        return 250;
    }

    private boolean canJuice() {
        if (this.slots[0] == null || this.slots[1] == null) {
            return false;
        }
        ItemStack itemstack = SauceMakerRecipes.getJuicingResult(this.slots[0].func_77973_b(), this.slots[1].func_77973_b());
        if (itemstack == null) {
            return false;
        }
        if (this.slots[3] == null) {
            return true;
        }
        if (!this.slots[3].func_77969_a(itemstack)) {
            return false;
        }
        int result = this.slots[3].field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= itemstack.func_77976_d();
    }

    public void juiceItem() {
        if (this.canJuice()) {
            ItemStack itemstack = SauceMakerRecipes.getJuicingResult(this.slots[0].func_77973_b(), this.slots[1].func_77973_b());
            if (this.slots[3] == null) {
                this.slots[3] = itemstack.func_77946_l();
            } else if (this.slots[3].func_77973_b() == itemstack.func_77973_b()) {
                this.slots[3].field_77994_a += itemstack.field_77994_a;
            }
            for (int i = 0; i < 2; ++i) {
                if (this.slots[i].field_77994_a <= 0) {
                    this.slots[i] = new ItemStack(this.slots[i].func_77973_b().func_77664_n());
                } else {
                    --this.slots[i].field_77994_a;
                }
                if (this.slots[i].field_77994_a > 0) continue;
                this.slots[i] = null;
            }
        }
    }

    public static int getItemBurnTime(ItemStack itemstack) {
        if (itemstack == null) {
            return 0;
        }
        Item item = itemstack.func_77973_b();
        if (item instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
            if (block == Blocks.field_150376_bx) {
                return 150;
            }
            if (block.func_149688_o() == Material.field_151575_d) {
                return 300;
            }
            if (block == Blocks.field_150402_ci) {
                return 16000;
            }
        }
        if (item instanceof ItemTool && ((ItemTool)item).func_77861_e().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemSword && ((ItemSword)item).func_150932_j().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemHoe && ((ItemHoe)item).func_77842_f().equals("WOOD")) {
            return 200;
        }
        if (item == Items.field_151055_y) {
            return 100;
        }
        if (item == Items.field_151044_h) {
            return 1600;
        }
        if (item == Items.field_151129_at) {
            return 20000;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150345_g)) {
            return 100;
        }
        if (item == Items.field_151072_bj) {
            return 2400;
        }
        return GameRegistry.getFuelValue((ItemStack)itemstack);
    }

    public static boolean isItemFuel(ItemStack itemstack) {
        return TileEntitySauceMaker.getItemBurnTime(itemstack) > 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 2 ? false : (index != 1 ? true : TileEntitySauceMaker.isItemFuel(stack) || SlotFurnaceFuel.func_178173_c_((ItemStack)stack));
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? slotsBottom : (side == EnumFacing.UP ? slotsTop : slotsSides);
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        Item item;
        return direction != EnumFacing.DOWN || index != 1 || (item = stack.func_77973_b()) == Items.field_151131_as || item == Items.field_151133_ar;
    }

    public int getBurnTimeRemainingScaled(int i) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 250;
        }
        return this.burnTime * i / this.currentItemBurnTime;
    }

    public int getCookProgressScaled(int i) {
        return this.cookTime * i / 250;
    }

    public String func_174875_k() {
        return "chef:sauceMaker";
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerSauceMaker(playerInventory, this);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.burnTime;
            }
            case 1: {
                return this.currentItemBurnTime;
            }
            case 2: {
                return this.cookTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.burnTime = value;
                break;
            }
            case 1: {
                this.currentItemBurnTime = value;
                break;
            }
            case 2: {
                this.cookTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 3;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = null;
        }
    }
}

