/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.coremods.avoidexplodingcreepers.explosions;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class ExplosionSource {
    private static List<ExplosionSource> sources = new ArrayList<ExplosionSource>();
    private final List<EntityCreature> affectedEntites = new ArrayList<EntityCreature>();
    private final Entity source;
    private final World world;
    private final int power;
    private int ticksLeft;

    public static void update(ExplosionSource source) {
        if (source.source.field_70128_L) {
            sources.remove(source);
        }
        if (sources.contains(source)) {
            source.update();
        }
    }

    public static void cleanNullValues() {
        for (ExplosionSource source : sources) {
            if (source != null && source.source != null && !source.source.field_70128_L) continue;
            sources.remove(source);
        }
    }

    public static ExplosionSource get(Entity entity) {
        for (ExplosionSource source : sources) {
            if (source.source != entity) continue;
            return source;
        }
        return null;
    }

    public ExplosionSource(Entity entity, int epower, int delay) {
        this.source = entity;
        this.world = entity.field_70170_p;
        this.power = epower;
        this.ticksLeft = delay;
        sources.add(this);
        System.out.println("New explosion source by " + entity + " in " + delay);
    }

    public void update() {
        --this.ticksLeft;
        AxisAlignedBB box = new AxisAlignedBB(this.source.field_70165_t - (double)this.power * 1.5, this.source.field_70163_u - (double)this.power * 1.5, this.source.field_70161_v - (double)this.power * 1.5, this.source.field_70165_t + (double)this.power * 1.5, this.source.field_70163_u + (double)this.power * 1.5, this.source.field_70161_v + (double)this.power * 1.5);
        for (Object object : this.world.func_72872_a(EntityLivingBase.class, box)) {
            EntityCreature entity;
            if (object instanceof EntityPlayer || object == this.source || !(object instanceof EntityCreature) || (entity = (EntityCreature)object) == null || entity.field_70128_L || this.affectedEntites.contains(entity)) continue;
            try {
                Vec3 vec3 = RandomPositionGenerator.func_75461_b((EntityCreature)entity, (int)(this.power * 5), (int)(this.power * 3), (Vec3)new Vec3(this.source.field_70161_v, this.source.field_70163_u, this.source.field_70161_v));
                double eb = entity.func_70092_e(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c);
                double speed = eb / (double)this.ticksLeft;
                PathNavigate navigator = entity.func_70661_as();
                navigator.func_75499_g();
                navigator.func_75492_a(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c, speed);
                this.affectedEntites.add(entity);
            }
            catch (Exception e) {
                System.out.println("Problems occured while checking next entity (" + entity + "):");
                e.printStackTrace();
            }
        }
    }

    public static class OnWorldTickEvent {
        @SubscribeEvent
        public void worldTick(TickEvent.WorldTickEvent event) {
            if (event.side == Side.SERVER && event.phase == TickEvent.Phase.START) {
                try {
                    ExplosionSource.cleanNullValues();
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    // empty catch block
                }
            }
        }
    }
}

