/*
 * Decompiled with CFR 0.152.
 */
package org.freeforums.geforce.beacon.main;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.freeforums.geforce.beacon.handlers.ForgeEventHandler;
import org.freeforums.geforce.beacon.main.HelpfulMethods;
import org.freeforums.geforce.beacon.network.ConfigurationHandler;
import org.freeforums.geforce.beacon.network.Links;

@Mod(modid="beacon", name="Beacon", version="v1.0.5", guiFactory="org.freeforums.geforce.beacon.gui.BeaconGuiFactory", dependencies="required-after:Forge@[11.14.0.1252,)")
public class mod_Beacon {
    public static final String MODID = "beacon";
    public static final String NAME = "Beacon";
    private static final String MOTU = "First!";
    protected static final String VERSION = "v1.0.5";
    protected static final String FORGEVERSION = "required-after:Forge@[11.14.0.1252,)";
    public static final String MCVERSION = "1.8";
    @Mod.Instance(value="beacon")
    public static mod_Beacon instance = new mod_Beacon();
    public static ForgeEventHandler eventHandler = new ForgeEventHandler();
    public static ConfigurationHandler configHandler = new ConfigurationHandler();
    public ArrayList<String> missingMods = new ArrayList();
    public ArrayList<String> addedMods = new ArrayList();
    public static Configuration configFile;
    public static String mcDirectory;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        configFile = new Configuration(event.getSuggestedConfigurationFile());
        configHandler.loadConfig(configFile);
        try {
            Links.setupLinks();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("*** [Beacon] Beacon has encountered a problem while attempting to download the latest modlist from www.github.com. ***");
        }
        Links.setupLocalMods();
        Links.setupAliases();
        FMLCommonHandler.instance().bus().register((Object)eventHandler);
        ModMetadata modMeta = event.getModMetadata();
        modMeta.authorList = Arrays.asList("Geforce");
        modMeta.autogenerated = false;
        modMeta.credits = "Thanks to Stack Overflow for help with code.";
        modMeta.description = "Beacon adds the ability to download mods in-game. \nJoin your favorite servers without having to download every mod in your browser! \n \nMessage of the update: \nFirst!";
        modMeta.url = "http://www.github.com/Geforce132/Beacon";
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
    }

    @NetworkCheckHandler
    public boolean onConnectionReceived(Map<String, String> modList, Side side) {
        for (int i = 0; i < modList.size(); ++i) {
            String modid = (String)modList.keySet().toArray()[i];
            String version = (String)modList.values().toArray()[i];
            if (version.toLowerCase().startsWith("v")) {
                version = version.replaceFirst("v", "");
            }
            if (modList.containsKey("Forge") && !HelpfulMethods.getVersionOfForge(modList.get("Forge")).matches(MCVERSION) || modid.matches("mcp") || modid.matches("FML") || modid.matches("Forge") || mod_Beacon.instance.missingMods.contains(modid + " v" + version) || mod_Beacon.instance.addedMods.contains(modid + " v" + version) || HelpfulMethods.hasMod(modid, version)) continue;
            mod_Beacon.instance.missingMods.add(modid + " v" + version);
        }
        return true;
    }
}

