/*
 * Decompiled with CFR 0.152.
 */
package org.freeforums.geforce.beacon.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraftforge.fml.client.config.GuiUnicodeGlyphButton;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.freeforums.geforce.beacon.gui.GuiRestart;
import org.freeforums.geforce.beacon.main.HelpfulMethods;
import org.freeforums.geforce.beacon.main.mod_Beacon;
import org.freeforums.geforce.beacon.network.Links;

public class GuiCheckForMods
extends GuiScreen {
    private List missingModsList;
    private GuiScreen prevScreen;
    private ArrayList<String> modsToRemove = new ArrayList();
    private boolean hasDownloadedMod;
    private boolean downloadedAllMods = false;
    private boolean hasInternetConnection = true;
    public HashMap<String, Integer> downloads = new HashMap();

    public GuiCheckForMods(GuiScreen par1) {
        this.prevScreen = par1;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.hasInternetConnection = HelpfulMethods.hasInternetConnection();
        this.missingModsList = new List();
        this.missingModsList.func_148134_d(7, 8);
        this.field_146292_n.add(new GuiUnicodeGlyphButton(0, 20, this.field_146295_m - 25, 130, 20, "  Download all mods", "\u21a1\u21a1", 2.0f));
        this.field_146292_n.add(new GuiUnicodeGlyphButton(1, this.field_146294_l - 60, this.field_146295_m - 25, 40, 20, "Back", "\u21b6", 2.0f));
        this.field_146292_n.add(new GuiUnicodeGlyphButton(2, 20, this.field_146295_m - 55, 100, 20, "  Download mod", "\u21d9", 2.5f));
        ((GuiButton)this.field_146292_n.get((int)2)).field_146124_l = false;
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        this.missingModsList.func_148128_a(par1, par2, par3);
        this.func_73732_a(this.field_146289_q, "Beacon", this.field_146294_l / 2, 20, 0xFFFFFF);
        if (!this.hasInternetConnection) {
            this.func_73731_b(this.field_146289_q, "No internet connection detected!", 12, 5, 0xFF3377);
            this.func_73731_b(this.field_146289_q, "Downloads are disabled.", 37, 20, 0xFF3377);
        }
        super.func_73863_a(par1, par2, par3);
    }

    public void closeGui() {
        if (!this.downloadedAllMods) {
            for (String mod : this.modsToRemove) {
                mod_Beacon.instance.missingMods.remove(mod);
            }
        } else {
            mod_Beacon.instance.missingMods.clear();
        }
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiRestart());
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.missingModsList.func_178039_p();
    }

    protected void func_146284_a(GuiButton par1) {
        if (par1.field_146127_k == 0) {
            int i;
            java.util.List<String> downloadedMods = HelpfulMethods.downloadMissingMods(mod_Beacon.instance.missingMods, this);
            for (i = 0; i < downloadedMods.size(); ++i) {
                mod_Beacon.instance.addedMods.add(downloadedMods.get(i));
                this.modsToRemove.add(downloadedMods.get(i));
            }
            for (i = 4; i < this.field_146292_n.size(); ++i) {
                if (!((GuiButton)this.field_146292_n.get((int)i)).field_146124_l) continue;
                ((GuiButton)this.field_146292_n.get((int)i)).field_146124_l = false;
            }
            this.downloadedAllMods = true;
            par1.field_146124_l = false;
        } else if (par1.field_146127_k == 1) {
            if (this.hasDownloadedMod || this.downloadedAllMods) {
                this.closeGui();
            } else {
                this.field_146297_k.func_147108_a(this.prevScreen);
            }
        } else if (par1.field_146127_k == 2) {
            try {
                if (HelpfulMethods.downloadMod(mod_Beacon.instance.missingMods.get(this.missingModsList.selectedEntry), this)) {
                    this.modsToRemove.add(mod_Beacon.instance.missingMods.get(this.missingModsList.selectedEntry));
                    mod_Beacon.instance.addedMods.add(mod_Beacon.instance.missingMods.get(this.missingModsList.selectedEntry));
                    par1.field_146124_l = false;
                    this.hasDownloadedMod = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void setModDownloading(String modid, double percentage) {
        this.downloads.put(modid, (int)percentage);
        if (this.downloads.get(modid) >= 100) {
            this.downloads.remove(modid);
        }
    }

    @SideOnly(value=Side.CLIENT)
    class List
    extends GuiSlot {
        private final java.util.List list;
        private final Map<Integer, String> numberToLink;
        private final Map<Integer, String> downloadType;
        protected int selectedEntry;

        public List() {
            super(GuiCheckForMods.this.field_146297_k, GuiCheckForMods.this.field_146294_l, GuiCheckForMods.this.field_146295_m, 32, GuiCheckForMods.this.field_146295_m - 65 + 4, 18);
            this.list = Lists.newArrayList();
            this.numberToLink = new HashMap<Integer, String>();
            this.downloadType = new HashMap<Integer, String>();
            this.selectedEntry = -1;
            Iterator<String> iterator = mod_Beacon.instance.missingMods.iterator();
            int counter = -1;
            while (iterator.hasNext()) {
                ++counter;
                String mod = iterator.next();
                if (Links.hasLocalMod(mod)) {
                    this.numberToLink.put(counter, Links.getLocalModPath(mod));
                    this.downloadType.put(counter, "local");
                } else if (Links.hasWebLink(mod)) {
                    this.numberToLink.put(counter, Links.getLink(mod));
                    this.downloadType.put(counter, "web");
                } else {
                    this.downloadType.put(counter, "none");
                }
                this.list.add(Links.hasAlias(mod) ? Links.getAlias(mod) : mod);
            }
        }

        protected int func_148127_b() {
            return this.list.size();
        }

        protected void func_148144_a(int par1, boolean p_148144_2_, int p_148144_3_, int p_148144_4_) {
            this.selectedEntry = par1;
            if (this.downloadType.get(par1).matches("local")) {
                ((GuiUnicodeGlyphButton)((GuiCheckForMods)GuiCheckForMods.this).field_146292_n.get((int)2)).field_146126_j = " Transfer mod";
                ((GuiUnicodeGlyphButton)((GuiCheckForMods)GuiCheckForMods.this).field_146292_n.get((int)2)).glyph = "\u21c4";
                ((GuiUnicodeGlyphButton)((GuiCheckForMods)GuiCheckForMods.this).field_146292_n.get((int)2)).glyphScale = 2.0f;
            } else if (this.downloadType.get(par1).matches("web")) {
                ((GuiUnicodeGlyphButton)((GuiCheckForMods)GuiCheckForMods.this).field_146292_n.get((int)2)).field_146126_j = "Download mod";
                ((GuiUnicodeGlyphButton)((GuiCheckForMods)GuiCheckForMods.this).field_146292_n.get((int)2)).glyph = "\u21d9";
                ((GuiUnicodeGlyphButton)((GuiCheckForMods)GuiCheckForMods.this).field_146292_n.get((int)2)).glyphScale = 2.5f;
            }
            if (this.downloadType.get(par1).matches("none")) {
                ((GuiButton)((GuiCheckForMods)GuiCheckForMods.this).field_146292_n.get((int)2)).field_146124_l = false;
            } else {
                ((GuiButton)((GuiCheckForMods)GuiCheckForMods.this).field_146292_n.get((int)2)).field_146124_l = true;
            }
        }

        protected boolean func_148131_a(int par1) {
            return par1 == this.selectedEntry;
        }

        protected int func_148138_e() {
            return this.func_148127_b() * 18;
        }

        protected void func_148123_a() {
            GuiCheckForMods.this.func_146276_q_();
        }

        protected void func_180791_a(int par1, int p_148126_2_, int p_148126_3_, int p_148126_4_, int p_148126_5_, int p_148126_6_) {
            if (this.downloadType.get(par1).matches("none")) {
                GuiCheckForMods.this.func_73732_a(GuiCheckForMods.this.field_146289_q, this.list.get(par1).toString(), this.field_148155_a / 2, p_148126_3_ + 1, 0xFF3377);
            } else if (GuiCheckForMods.this.downloads.containsKey(this.list.get(par1))) {
                GuiCheckForMods.this.func_73732_a(GuiCheckForMods.this.field_146289_q, this.list.get(par1).toString() + " (" + GuiCheckForMods.this.downloads.get(this.list.get(par1)) + "%)", this.field_148155_a / 2, p_148126_3_ + 1, 0xFFFFFF);
            } else {
                GuiCheckForMods.this.func_73732_a(GuiCheckForMods.this.field_146289_q, this.list.get(par1).toString(), this.field_148155_a / 2, p_148126_3_ + 1, 0xFFFFFF);
            }
        }
    }
}

