/*
 * Decompiled with CFR 0.152.
 */
package org.freeforums.geforce.beacon.handlers;

import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.freeforums.geforce.beacon.gui.GuiCheckForMods;
import org.freeforums.geforce.beacon.gui.GuiMessage;
import org.freeforums.geforce.beacon.main.mod_Beacon;

public class ForgeEventHandler {
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onGuiInitialized(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.gui instanceof GuiMultiplayer) {
            event.buttonList.add(new GuiButton(9, event.gui.field_146294_l / 2 - 200, event.gui.field_146295_m - 52, 45, 20, "Beacon"));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onScreenDrawn(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (event.gui instanceof GuiMultiplayer && !mod_Beacon.instance.missingMods.isEmpty()) {
            event.gui.func_73731_b(event.gui.field_146297_k.field_71466_p, "(" + String.valueOf(mod_Beacon.instance.missingMods.size()) + " mod" + (mod_Beacon.instance.missingMods.size() >= 2 ? "s" : "") + " missing!)", event.gui.field_146294_l / 2 + 45, 20, 0xFF3377);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onButtonClicked(GuiScreenEvent.ActionPerformedEvent.Pre event) {
        if (event.gui instanceof GuiMultiplayer && event.button.field_146127_k == 9) {
            event.setCanceled(true);
            if (!mod_Beacon.instance.missingMods.isEmpty()) {
                event.gui.field_146297_k.func_147108_a((GuiScreen)new GuiCheckForMods(event.gui));
            } else {
                event.gui.field_146297_k.func_147108_a((GuiScreen)new GuiMessage(event.gui, "Beacon has found no missing mods in your Minecraft installation.", "Back"));
            }
            event.gui.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.matches("beacon")) {
            mod_Beacon.configFile.save();
            mod_Beacon.configHandler.loadConfig(mod_Beacon.configFile);
        }
    }
}

