/*
 * Decompiled with CFR 0.152.
 */
package org.freeforums.geforce.beacon.network;

import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.freeforums.geforce.beacon.gui.GuiCheckForMods;

public class ThreadDownloadFile
implements Runnable {
    private BufferedInputStream in;
    private FileOutputStream out;
    private int fileSize;
    private String modid;
    private GuiCheckForMods screen;

    public ThreadDownloadFile(BufferedInputStream in, FileOutputStream out, int fileSize, String modid, GuiCheckForMods screen) {
        this.in = in;
        this.out = out;
        this.fileSize = fileSize;
        this.modid = modid;
        this.screen = screen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int count;
            byte[] data = new byte[4094];
            double sumCount = 0.0;
            while ((count = this.in.read(data, 0, 4094)) != -1) {
                this.out.write(data, 0, count);
                sumCount += (double)count;
                if (this.fileSize > 0 && this.screen != null) {
                    this.screen.setModDownloading(this.modid, sumCount / (double)this.fileSize * 100.0);
                    continue;
                }
                if (this.fileSize <= 0 || this.screen != null) continue;
                System.out.println("[Beacon] Downloading '" + this.modid + "'. " + sumCount / (double)this.fileSize * 100.0 + "% complete.");
            }
            if (this.screen.downloads.containsKey(this.modid)) {
                this.screen.downloads.remove(this.modid);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

