/*
 * Decompiled with CFR 0.152.
 */
package zsawyer.mods.mumblelink;

import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Logger;
import zsawyer.mods.mumblelink.MumbleLinkAPIImpl;
import zsawyer.mods.mumblelink.MumbleLinkBase;
import zsawyer.mods.mumblelink.UpdateTicker;
import zsawyer.mods.mumblelink.api.MumbleLink;
import zsawyer.mods.mumblelink.api.MumbleLinkAPI;
import zsawyer.mods.mumblelink.mumble.ExtendedUpdateData;
import zsawyer.mods.mumblelink.util.ConfigHelper;

@Mod(modid="MumbleLink", useMetadata=true)
@SideOnly(value=Side.CLIENT)
public class MumbleLinkImpl
extends MumbleLinkBase
implements MumbleLink {
    public static Logger LOG;
    @Mod.Instance(value="MumbleLink")
    public static MumbleLinkImpl instance;
    private UpdateTicker updateTicker;
    private MumbleLinkAPIImpl api;
    private boolean enabled = true;
    private boolean debug = false;
    private String name = "MumbleLink";
    private String version = "unknown";

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LOG = event.getModLog();
        this.name = event.getModMetadata().name;
        this.version = event.getModMetadata().version;
        if (FMLCommonHandler.instance().getSide().isServer()) {
            throw new RuntimeException(this.name + " should not be installed on a server!");
        }
        this.loadConfig(event);
    }

    private void loadConfig(FMLPreInitializationEvent event) {
        ConfigHelper configHelper = new ConfigHelper(event);
        this.debug = configHelper.loadDebug(this.debug);
        this.enabled = configHelper.loadEnabled(this.enabled);
    }

    @SideOnly(value=Side.CLIENT)
    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        this.load();
        this.initComponents();
        this.activate();
    }

    private void initComponents() {
        ExtendedUpdateData extendedUpdateData = new ExtendedUpdateData(this.library, this.errorHandler);
        this.mumbleData = extendedUpdateData;
        this.updateTicker = new UpdateTicker();
        this.api = new MumbleLinkAPIImpl();
        this.api.setExtendedUpdateData(extendedUpdateData);
    }

    @Override
    public MumbleLinkAPI getApi() {
        return this.api;
    }

    @Override
    public void activate() {
        this.updateTicker.activate();
    }

    @Override
    public void deactivate() {
        this.updateTicker.deactivate();
    }

    @Override
    public boolean debugging() {
        return this.debug;
    }

    public static boolean debug() {
        return MumbleLinkImpl.instance.debug;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }
}

