/*
 * Decompiled with CFR 0.152.
 */
package zsawyer.mods.mumblelink.addons.pa.es;

import javax.management.InstanceNotFoundException;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Logger;
import zsawyer.mods.mumblelink.api.Activateable;
import zsawyer.mods.mumblelink.api.IdentityManipulator;
import zsawyer.mods.mumblelink.api.MumbleLink;
import zsawyer.mods.mumblelink.util.ConfigHelper;
import zsawyer.mods.mumblelink.util.InstanceHelper;
import zsawyer.mods.mumblelink.util.json.JSONArray;
import zsawyer.mods.mumblelink.util.json.JSONException;
import zsawyer.mods.mumblelink.util.json.JSONObject;

@Mod(modid="ExtendedPASupport", useMetadata=true)
public class ExtendedPASupport
implements Activateable,
IdentityManipulator {
    public static Logger LOG;
    public static final String MOD_ID = "ExtendedPASupport";
    @Mod.Instance(value="ExtendedPASupport")
    public static ExtendedPASupport instance;
    private boolean enabled = true;
    private boolean debug = false;
    private String name = "ExtendedPASupport for MumbleLink";
    private String version = "unknown";
    private MumbleLink mumbleLinkInstance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LOG = event.getModLog();
        if (FMLCommonHandler.instance().getSide().isServer()) {
            throw new RuntimeException(this.getName() + " should not be installed on a server!");
        }
        this.loadConfig(event);
    }

    private void loadConfig(FMLPreInitializationEvent event) {
        ConfigHelper configHelper = new ConfigHelper(event);
        this.debug = configHelper.loadDebug(this.debug);
        this.enabled = configHelper.loadEnabled(this.enabled);
    }

    @SideOnly(value=Side.CLIENT)
    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        try {
            this.mumbleLinkInstance = InstanceHelper.getMumbleLink();
            if (this.enabled) {
                this.activate();
            }
        }
        catch (InstanceNotFoundException e) {
            FMLClientHandler.instance().haltGame("Error in mod " + this.getName() + this.getVersion() + ": no instance of " + "MumbleLink" + " found!", (Throwable)e);
        }
    }

    @Override
    public void activate() {
        this.mumbleLinkInstance.getApi().register(this);
    }

    @Override
    public void deactivate() {
        this.mumbleLinkInstance.getApi().unregister(this);
    }

    @Override
    public String manipulateIdentity(String identity, Minecraft game, int maxLength) {
        try {
            JSONObject newIdentity = new JSONObject(identity);
            this.appendToIdentity(newIdentity, game);
            this.printDebug(newIdentity, "identity");
            return newIdentity.toString();
        }
        catch (JSONException e) {
            LOG.fatal("could not generate identity", (Throwable)e);
            return identity;
        }
    }

    private void appendToIdentity(JSONObject identity, Minecraft game) throws JSONException {
        JSONArray spawnCoordinates = new JSONArray();
        spawnCoordinates.put(game.field_71441_e.func_72912_H().func_76079_c());
        spawnCoordinates.put(game.field_71441_e.func_72912_H().func_76075_d());
        spawnCoordinates.put(game.field_71441_e.func_72912_H().func_76074_e());
        identity.put("worldSpawn", spawnCoordinates);
        identity.put("dimension", game.field_71439_g.field_71093_bK);
    }

    private void printDebug(JSONObject objectToPrint, String nameOfObject) {
        if (this.debug) {
            LOG.info(nameOfObject + ": " + objectToPrint.toString(), new Object[]{""});
        }
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }
}

