/*
 * Decompiled with CFR 0.152.
 */
package zsawyer.mods.mumblelink.util;

import java.util.Arrays;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ConfigHelper {
    private Configuration config;

    public ConfigHelper(Configuration config) {
        this.config = config;
    }

    public ConfigHelper(FMLPreInitializationEvent event) {
        this.config = new Configuration(event.getSuggestedConfigurationFile());
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void commit() {
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public boolean loadBoolean(String key, String comment, boolean defaultValue) {
        boolean value = this.config.get("general", key, defaultValue, ConfigHelper.configComment(comment, new Boolean[]{true, false})).getBoolean(defaultValue);
        this.commit();
        return value;
    }

    public boolean loadEnabled(boolean defaultValue) {
        return this.loadBoolean(Config.Key.enabled.toString(), "whether this addon should do stuff", defaultValue);
    }

    public boolean loadDebug(boolean defaultValue) {
        return this.loadBoolean(Config.Key.debug.toString(), "whether to turn on debuggin (extended logging)", defaultValue);
    }

    public static String configComment(String comment, Object[] availableValues) {
        return comment + System.getProperty("line.separator") + "available values: " + Arrays.toString(availableValues);
    }

    public static class Config {

        public static enum Key {
            enabled,
            debug;

        }
    }
}

