/*
 * Decompiled with CFR 0.152.
 */
package zsawyer.mods.mumblelink;

import net.minecraft.client.Minecraft;
import zsawyer.mods.mumblelink.error.ErrorHandlerImpl;
import zsawyer.mods.mumblelink.error.ModErrorHandler;
import zsawyer.mods.mumblelink.loader.PackageLibraryLoader;
import zsawyer.mods.mumblelink.mumble.MumbleInitializer;
import zsawyer.mods.mumblelink.mumble.UpdateData;
import zsawyer.mumble.jna.LinkAPILibrary;

public class MumbleLinkBase {
    protected MumbleInitializer mumbleInititer;
    protected Thread mumbleInititerThread;
    protected UpdateData mumbleData;
    protected LinkAPILibrary library;
    protected ErrorHandlerImpl errorHandler;

    public void load() {
        this.initComponents();
    }

    private void initComponents() {
        this.errorHandler = ErrorHandlerImpl.getInstance();
        try {
            this.library = new PackageLibraryLoader().loadLibrary("LinkAPI");
        }
        catch (Exception e) {
            this.errorHandler.throwError(ModErrorHandler.ModError.LIBRARY_LOAD_FAILED, e);
        }
        this.mumbleData = new UpdateData(this.library, this.errorHandler);
        this.mumbleInititer = new MumbleInitializer(this.library, this.errorHandler);
        this.mumbleInititerThread = new Thread(this.mumbleInititer);
    }

    public void tryUpdateMumble(Minecraft game) {
        if (this.mumbleInititer.isMumbleInitialized()) {
            if (game.field_71439_g != null && game.field_71441_e != null) {
                this.mumbleData.set(game);
                this.mumbleData.send();
            }
        } else {
            try {
                this.mumbleInititerThread.start();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
        }
    }
}

