/*
 * Decompiled with CFR 0.152.
 */
package zsawyer.mods.mumblelink.error;

import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.apache.logging.log4j.Level;
import zsawyer.mods.mumblelink.MumbleLinkImpl;
import zsawyer.mods.mumblelink.error.ModErrorHandler;
import zsawyer.mods.mumblelink.error.NativeInitErrorHandler;
import zsawyer.mods.mumblelink.error.NativeUpdateErrorHandler;
import zsawyer.mods.mumblelink.notification.BufferedChatNotifier;
import zsawyer.mods.mumblelink.notification.UserNotifier;
import zsawyer.mods.mumblelink.util.SingletonFactory;

public class ErrorHandlerImpl
implements ModErrorHandler,
NativeInitErrorHandler,
NativeUpdateErrorHandler {
    private UserNotifier chat = new BufferedChatNotifier(Minecraft.func_71410_x());

    @Override
    public void throwError(ModErrorHandler.ModError modError, Throwable cause) {
        this.log(Level.FATAL, cause.getMessage(), cause);
        this.haltMinecraftUsingAnException(modError.toString(), cause);
    }

    private void haltMinecraftUsingAnException(String message, Throwable err) {
        FMLClientHandler.instance().haltGame("Error in mod " + MumbleLinkImpl.instance.getName() + MumbleLinkImpl.instance.getVersion() + ": " + message, err);
    }

    @Override
    public void handleError(ModErrorHandler.ModError err, Throwable stack) {
        this.chatMessage("[MumbleLink] Error: " + err.toString());
        this.log(Level.WARN, err.toString(), stack);
    }

    private void log(Level severity, String message, Throwable stack) {
        MumbleLinkImpl.LOG.log(severity, "[" + MumbleLinkImpl.instance.getName() + MumbleLinkImpl.instance.getVersion() + "]" + "[" + severity.toString() + "] " + message, stack);
    }

    private void chatMessage(String message) {
        this.chat.print(message);
    }

    @Override
    public void handleError(NativeUpdateErrorHandler.NativeUpdateError fromCode) {
        if (fromCode != NativeUpdateErrorHandler.NativeUpdateError.NO_ERROR) {
            this.log(Level.WARN, "Update failed! Error: " + fromCode.getCode() + " (" + fromCode.toString() + ")", null);
        }
    }

    @Override
    public void handleError(NativeInitErrorHandler.NativeInitError fromCode) {
        if (fromCode == NativeInitErrorHandler.NativeInitError.NO_ERROR) {
            this.chat.print("Mumble linked.");
        }
    }

    public static ErrorHandlerImpl getInstance() {
        try {
            return SingletonFactory.getInstance(ErrorHandlerImpl.class);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

