/*
 * Decompiled with CFR 0.152.
 */
package zsawyer.mods.mumblelink.mumble;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import zsawyer.mods.mumblelink.MumbleLinkImpl;
import zsawyer.mods.mumblelink.api.ContextManipulator;
import zsawyer.mods.mumblelink.api.IdentityManipulator;
import zsawyer.mods.mumblelink.error.NativeUpdateErrorHandler;
import zsawyer.mods.mumblelink.mumble.UpdateData;
import zsawyer.mumble.jna.LinkAPILibrary;

public class ExtendedUpdateData
extends UpdateData {
    protected ArrayList<IdentityManipulator> identityManipulators = new ArrayList();
    protected ArrayList<ContextManipulator> contextManipulators = new ArrayList();

    public ExtendedUpdateData(LinkAPILibrary mumbleLink, NativeUpdateErrorHandler errorHandler) {
        super(mumbleLink, errorHandler);
    }

    @Override
    protected String generateContext(Minecraft game, int maxLength) {
        String context = super.generateContext(game, maxLength);
        for (ContextManipulator contextManipulator : this.contextManipulators) {
            String newContext = contextManipulator.manipulateContext(context, game, maxLength);
            if (!this.verify("context", newContext, maxLength)) continue;
            context = newContext;
        }
        if (MumbleLinkImpl.debug()) {
            MumbleLinkImpl.LOG.info("context: " + context);
        }
        return context;
    }

    @Override
    protected String generateIdentity(Minecraft game, int maxLength) {
        String identity = super.generateIdentity(game, maxLength);
        for (IdentityManipulator identityManipulator : this.identityManipulators) {
            String newIdentity = identityManipulator.manipulateIdentity(identity, game, maxLength);
            if (!this.verify("identity", newIdentity, maxLength)) continue;
            identity = newIdentity;
        }
        if (MumbleLinkImpl.debug()) {
            MumbleLinkImpl.LOG.info("identity: " + identity);
        }
        return identity;
    }

    private boolean verify(String type, String value, int maxLength) {
        if (value.length() > maxLength) {
            MumbleLinkImpl.LOG.fatal(type + " (" + value.length() + ") is too long (max. " + maxLength + "): '" + value + "'");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(IdentityManipulator manipulator) {
        ArrayList<IdentityManipulator> arrayList = this.identityManipulators;
        synchronized (arrayList) {
            this.identityManipulators.add(manipulator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(IdentityManipulator manipulator) {
        ArrayList<IdentityManipulator> arrayList = this.identityManipulators;
        synchronized (arrayList) {
            this.identityManipulators.remove(manipulator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ContextManipulator manipulator) {
        ArrayList<ContextManipulator> arrayList = this.contextManipulators;
        synchronized (arrayList) {
            this.contextManipulators.add(manipulator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(ContextManipulator manipulator) {
        ArrayList<ContextManipulator> arrayList = this.contextManipulators;
        synchronized (arrayList) {
            this.contextManipulators.remove(manipulator);
        }
    }
}

